/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractImplicitTypeInspection;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/HasPlatformTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractImplicitTypeInspection;", "publicAPIOnly", "", "reportPlatformArguments", "(ZZ)V", "problemText", "", "getProblemText", "()Ljava/lang/String;", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "createOptionsPanel", "Ljavax/swing/JComponent;", "kotlin.idea"})
public final class HasPlatformTypeInspection
extends AbstractImplicitTypeInspection {
    @NotNull
    private final String problemText;
    @JvmField
    public boolean publicAPIOnly;
    @JvmField
    public boolean reportPlatformArguments;

    @NotNull
    protected String getProblemText() {
        return this.problemText;
    }

    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtCallableDeclaration element3) {
        block4: {
            PsiElement expression2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                KotlinType kotlinType = SpecifyTypeExplicitlyIntention.Companion.dangerousFlexibleTypeOrNull(element3, this.publicAPIOnly, this.reportPlatformArguments);
                if (kotlinType == null) {
                    return null;
                }
                KotlinType type2 = kotlinType;
                if (!TypeUtils.isNullableType((KotlinType)type2)) break block4;
                ASTNode aSTNode = element3.getNode().findChildByType((IElementType)KtTokens.EQ);
                PsiElement psiElement2 = aSTNode != null && (aSTNode = aSTNode.getPsi()) != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)aSTNode, (boolean)false, (int)1, null) : (expression2 = null);
                if (expression2 == null) break block4;
                if (!this.reportPlatformArguments) break block5;
                KotlinType kotlinType2 = TypeUtils.makeNotNullable((KotlinType)type2);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"TypeUtils.makeNotNullable(type)");
                if (UtilsKt.isFlexibleRecursive(kotlinType2)) break block4;
            }
            return CollectionsKt.listOf((Object)new IntentionWrapper((IntentionAction)new AddExclExclCallFix(expression2), element3.getContainingFile()));
        }
        return null;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(KotlinBundle.message("apply.only.to.public.or.protected.members", new Object[0]), "publicAPIOnly");
        panel2.addCheckbox(KotlinBundle.message("report.for.types.with.platform.arguments", new Object[0]), "reportPlatformArguments");
        return (JComponent)panel2;
    }

    public HasPlatformTypeInspection(boolean publicAPIOnly, boolean reportPlatformArguments) {
        super((Function2<? super KtCallableDeclaration, ? super AbstractImplicitTypeInspection, Boolean>)((Function2)1.INSTANCE));
        this.publicAPIOnly = publicAPIOnly;
        this.reportPlatformArguments = reportPlatformArguments;
        this.problemText = KotlinBundle.message("declaration.has.type.inferred.from.a.platform.call.which.can.lead.to.unchecked.nullability.issues", new Object[0]);
    }

    public /* synthetic */ HasPlatformTypeInspection(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public HasPlatformTypeInspection() {
        this(false, false, 3, null);
    }
}

