/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractPrimitiveRangeToInspection;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001b\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/EmptyRangeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractPrimitiveRangeToInspection;", "()V", "visitRangeToExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "longValueOrNull", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Ljava/lang/Long;", "ReplaceWithDownToFix", "kotlin.idea"})
public final class EmptyRangeInspection
extends AbstractPrimitiveRangeToInspection {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitRangeToExpression(@NotNull KtExpression expression2, @NotNull ProblemsHolder holder) {
        void left;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(expression2);
        if (pair == null) {
            return;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        KtExpression ktExpression = (KtExpression)pair2.component1();
        KtExpression right = (KtExpression)pair2.component2();
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.PARTIAL);
        Long l = left;
        if (l == null || (l = this.longValueOrNull((KtExpression)l, context2)) == null) {
            return;
        }
        long startValue = l;
        Object object = right;
        if (object == null || (object = this.longValueOrNull((KtExpression)object, context2)) == null) {
            return;
        }
        long endValue = (Long)object;
        if (startValue <= endValue) {
            return;
        }
        holder.registerProblem((PsiElement)expression2, KotlinBundle.message("this.range.is.empty.did.you.mean.to.use.downto", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithDownToFix()});
    }

    private final Long longValueOrNull(KtExpression $this$longValueOrNull, BindingContext context2) {
        ConstantValue<Object> constantValue = AbstractPrimitiveRangeToInspection.Companion.constantValueOrNull($this$longValueOrNull, context2);
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/EmptyRangeInspection$ReplaceWithDownToFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    public static final class ReplaceWithDownToFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.down.to.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void left;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair == null) {
                return;
            }
            Pair<KtExpression, KtExpression> pair2 = pair;
            KtExpression ktExpression2 = (KtExpression)pair2.component1();
            KtExpression right = (KtExpression)pair2.component2();
            if (left == null || right == null) {
                return;
            }
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null), (String)"$0 downTo $1", (Object[])new Object[]{left, right}, (boolean)false, (int)4, null));
        }
    }
}

