/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeActionKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/DeleteEqualsAndHashCodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
public final class DeleteEqualsAndHashCodeFix
implements LocalQuickFix {
    @NotNull
    public static final DeleteEqualsAndHashCodeFix INSTANCE;

    @NotNull
    public String getName() {
        return KotlinBundle.message("delete.equals.and.hash.code.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        block4: {
            FunctionDescriptor functionDescriptor2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement $this$getStrictParentOfType$iv = psiElement2;
            boolean $i$f$getStrictParentOfType = false;
            KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)true);
            if (ktObjectDeclaration == null) {
                return;
            }
            KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
            ClassDescriptor classDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)((KtClassOrObject)objectDeclaration), null, (int)1, null);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            FunctionDescriptor functionDescriptor3 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(classDescriptor2, false);
            if (functionDescriptor3 != null && (functionDescriptor3 = functionDescriptor3.getSource()) != null && (functionDescriptor3 = KotlinSourceElementKt.getPsi((SourceElement)functionDescriptor3)) != null) {
                functionDescriptor3.delete();
            }
            if ((functionDescriptor2 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(classDescriptor2, false)) == null || (functionDescriptor2 = functionDescriptor2.getSource()) == null || (functionDescriptor2 = KotlinSourceElementKt.getPsi((SourceElement)functionDescriptor2)) == null) break block4;
            functionDescriptor2.delete();
        }
    }

    private DeleteEqualsAndHashCodeFix() {
    }

    static {
        DeleteEqualsAndHashCodeFix deleteEqualsAndHashCodeFix;
        INSTANCE = deleteEqualsAndHashCodeFix = new DeleteEqualsAndHashCodeFix();
    }
}

