/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertTwoComparisonsToRangeCheckInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceRangeToWithUntilInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J:\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J2\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\f\u0010'\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010(\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010)\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010*\u001a\u00020\u0016*\u00020\u0013H\u0002J\u000e\u0010+\u001a\u00020\u0016*\u0004\u0018\u00010\"H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRangeExpressionData", "Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "condition", "firstLess", "Lorg/jetbrains/kotlin/psi/KtExpression;", "firstGreater", "firstStrict", "", "secondLess", "secondGreater", "secondStrict", "value", "min", "max", "incrementMinByOne", "decrementMaxByOne", "getDoubleConstant", "intExpr", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "inspectionText", "isApplicable", "isComparable", "isFloatingPoint", "isInteger", "isSimple", "isValidTypeForIncrementDecrementByOne", "RangeExpressionData", "kotlin.idea"})
public final class ConvertTwoComparisonsToRangeCheckInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("two.comparisons.should.be.converted.to.a.range.check", new Object[0]);
    }

    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("convert.to.a.range.check", new Object[0]);
    }

    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element3);
        if (rangeExpressionData == null) {
            return false;
        }
        RangeExpressionData rangeData = rangeExpressionData;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction function2 = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (function2 != null && function2.hasModifier(KtTokens.OPERATOR_KEYWORD) && Intrinsics.areEqual((Object)function2.getNameAsName(), (Object)OperatorNameConventions.CONTAINS)) {
            BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
            DeclarationDescriptor functionDescriptor2 = (DeclarationDescriptor)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function2);
            KtBinaryExpression newExpression2 = rangeData.createExpression();
            BindingContext newContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)((KtExpression)newExpression2), (KtExpression)((KtExpression)element3), (BindingContext)context2, null, null, null, (int)28, null);
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)newExpression2.getOperationReference()), (BindingContext)newContext);
            if (Intrinsics.areEqual((Object)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null), (Object)functionDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block2: {
            KtBinaryExpression ktBinaryExpression;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element3);
            if (rangeExpressionData == null) {
                return;
            }
            RangeExpressionData rangeData = rangeExpressionData;
            PsiElement replaced2 = element3.replace((PsiElement)rangeData.createExpression());
            PsiElement psiElement2 = replaced2;
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            if ((ktBinaryExpression = (KtBinaryExpression)psiElement2) == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null) break block2;
            KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtBinaryExpression it = ktBinaryExpression2;
            boolean bl3 = false;
            KtBinaryExpression ktBinaryExpression3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktBinaryExpression3, (String)"it");
            ReplaceRangeToWithUntilInspection.Companion.applyFixIfApplicable((KtExpression)ktBinaryExpression3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final RangeExpressionData generateRangeExpressionData(KtBinaryExpression condition2) {
        void secondLess;
        void firstLess;
        if (Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.ANDAND) ^ true) {
            return null;
        }
        KtExpression ktExpression = condition2.getLeft();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression firstCondition = ktBinaryExpression;
        KtExpression ktExpression2 = condition2.getRight();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression secondCondition = ktBinaryExpression2;
        IElementType iElementType = firstCondition.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"firstCondition.operationToken");
        IElementType firstOpToken = iElementType;
        IElementType iElementType2 = secondCondition.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"secondCondition.operationToken");
        IElementType secondOpToken = iElementType2;
        KtExpression ktExpression3 = firstCondition.getLeft();
        if (ktExpression3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"firstCondition.left ?: return null");
        KtExpression firstLeft = ktExpression3;
        KtExpression ktExpression4 = firstCondition.getRight();
        if (ktExpression4 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"firstCondition.right ?: return null");
        KtExpression firstRight = ktExpression4;
        KtExpression ktExpression5 = secondCondition.getLeft();
        if (ktExpression5 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression5, (String)"secondCondition.left ?: return null");
        KtExpression secondLeft = ktExpression5;
        KtExpression ktExpression6 = secondCondition.getRight();
        if (ktExpression6 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression6, (String)"secondCondition.right ?: return null");
        KtExpression secondRight = ktExpression6;
        generateRangeExpressionData.1 $fun$isStrictComparison$1 = generateRangeExpressionData.1.INSTANCE;
        boolean firstStrict = $fun$isStrictComparison$1.invoke(firstOpToken);
        boolean secondStrict = $fun$isStrictComparison$1.invoke(secondOpToken);
        generateRangeExpressionData.2 $fun$orderLessAndGreater$2 = generateRangeExpressionData.2.INSTANCE;
        KtExpression ktExpression7 = $fun$orderLessAndGreater$2.invoke(firstOpToken, firstLeft, firstRight);
        if (ktExpression7 == null) {
            return null;
        }
        KtExpression ktExpression8 = ktExpression7;
        KtExpression ktExpression9 = (KtExpression)ktExpression8.component1();
        KtExpression firstGreater = (KtExpression)ktExpression8.component2();
        Pair<KtExpression, KtExpression> pair = $fun$orderLessAndGreater$2.invoke(secondOpToken, secondLeft, secondRight);
        if (pair == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        ktExpression8 = (KtExpression)pair2.component1();
        KtExpression secondGreater = (KtExpression)pair2.component2();
        return this.generateRangeExpressionData((KtExpression)firstLess, firstGreater, firstStrict, (KtExpression)secondLess, secondGreater, secondStrict);
    }

    private final boolean isSimple(KtExpression $this$isSimple) {
        return $this$isSimple instanceof KtConstantExpression || $this$isSimple instanceof KtNameReferenceExpression;
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression firstLess, KtExpression firstGreater, boolean firstStrict, KtExpression secondLess, KtExpression secondGreater, boolean secondStrict) {
        return !(firstGreater instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstGreater, secondLess) ? this.generateRangeExpressionData(firstGreater, firstLess, secondGreater, firstStrict, secondStrict) : (!(firstLess instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstLess, secondGreater) ? this.generateRangeExpressionData(firstLess, secondLess, firstGreater, secondStrict, firstStrict) : null);
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression value, KtExpression min, KtExpression max, boolean incrementMinByOne, boolean decrementMaxByOne) {
        Function3<KtExpression, BindingContext, Integer, String> $fun$getChangeBy$3 = new Function3<KtExpression, BindingContext, Integer, String>(this){
            final /* synthetic */ ConvertTwoComparisonsToRangeCheckInspection this$0;

            @Nullable
            public final String invoke(@NotNull KtExpression $this$getChangeBy, @NotNull BindingContext context2, int number) {
                Intrinsics.checkNotNullParameter((Object)$this$getChangeBy, (String)"$this$getChangeBy");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$getChangeBy, (BindingContext)context2);
                if (kotlinType == null) {
                    return null;
                }
                KotlinType type2 = kotlinType;
                if (!ConvertTwoComparisonsToRangeCheckInspection.access$isValidTypeForIncrementDecrementByOne(this.this$0, type2)) {
                    return null;
                }
                KtExpression ktExpression = $this$getChangeBy;
                if (ktExpression instanceof KtConstantExpression) {
                    String string;
                    Object object = ConstantExpressionEvaluator.Companion.getConstant($this$getChangeBy, context2);
                    if (object == null || (object = object.getValue(type2)) == null) {
                        return null;
                    }
                    Object constantValue = object;
                    if (KotlinBuiltIns.isInt((KotlinType)type2)) {
                        Object object2 = constantValue;
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int n = (Integer)object2 + number;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = n;
                        boolean bl3 = false;
                        String text2 = ((KtConstantExpression)$this$getChangeBy).getText();
                        String string2 = text2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                        if (StringsKt.startsWith$default((String)string2, (String)"0x", (boolean)false, (int)2, null)) {
                            StringBuilder stringBuilder = new StringBuilder().append("0x");
                            int n2 = it;
                            int n3 = 16;
                            boolean bl4 = false;
                            String string3 = Integer.toString(n2, CharsKt.checkRadix((int)n3));
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                            string = stringBuilder.append(string3).toString();
                        } else if (StringsKt.startsWith$default((String)text2, (String)"0b", (boolean)false, (int)2, null)) {
                            StringBuilder stringBuilder = new StringBuilder().append("0b");
                            int n4 = it;
                            int n5 = 2;
                            boolean bl5 = false;
                            String string4 = Integer.toString(n4, CharsKt.checkRadix((int)n5));
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                            string = stringBuilder.append(string4).toString();
                        } else {
                            string = String.valueOf(it);
                        }
                    } else if (KotlinBuiltIns.isLong((KotlinType)type2)) {
                        Object object3 = constantValue;
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        long l = (Long)object3 + (long)number;
                        boolean bl = false;
                        boolean bl6 = false;
                        long it = l;
                        boolean bl7 = false;
                        String text3 = ((KtConstantExpression)$this$getChangeBy).getText();
                        String string5 = text3;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text");
                        if (StringsKt.startsWith$default((String)string5, (String)"0x", (boolean)false, (int)2, null)) {
                            StringBuilder stringBuilder = new StringBuilder().append("0x");
                            long l2 = it;
                            int n = 16;
                            boolean bl8 = false;
                            String string6 = Long.toString(l2, CharsKt.checkRadix((int)n));
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                            string = stringBuilder.append(string6).toString();
                        } else if (StringsKt.startsWith$default((String)text3, (String)"0b", (boolean)false, (int)2, null)) {
                            StringBuilder stringBuilder = new StringBuilder().append("0b");
                            long l3 = it;
                            int n = 2;
                            boolean bl9 = false;
                            String string7 = Long.toString(l3, CharsKt.checkRadix((int)n));
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                            string = stringBuilder.append(string7).toString();
                        } else {
                            string = String.valueOf(it);
                        }
                    } else if (KotlinBuiltIns.isChar((KotlinType)type2)) {
                        Object object4 = constantValue;
                        if (object4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        string = "" + '\'' + (char)(((Character)object4).charValue() + number) + '\'';
                    } else {
                        string = null;
                    }
                    return string;
                }
                return number >= 0 ? '(' + $this$getChangeBy.getText() + " + " + number + ')' : '(' + $this$getChangeBy.getText() + " - " + -number + ')';
            }
            {
                this.this$0 = convertTwoComparisonsToRangeCheckInspection;
                super(3);
            }
        };
        if (!this.isSimple(min) || !this.isSimple(max)) {
            return null;
        }
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)((KtElement)value), null, (int)1, null);
        KotlinType valType = CallUtilKt.getType((KtExpression)value, (BindingContext)context2);
        KotlinType minType = CallUtilKt.getType((KtExpression)min, (BindingContext)context2);
        KotlinType maxType = CallUtilKt.getType((KtExpression)max, (BindingContext)context2);
        if (valType == null || minType == null || maxType == null) {
            return null;
        }
        if (!this.isComparable(valType)) {
            return null;
        }
        KtExpression minVal = min;
        KtExpression maxVal = max;
        if (Intrinsics.areEqual((Object)minType, (Object)valType) ^ true || Intrinsics.areEqual((Object)maxType, (Object)valType) ^ true) {
            if (TypeUtilsKt.isPrimitiveNumberType((KotlinType)valType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)minType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)maxType)) {
                if (KotlinBuiltIns.isChar((KotlinType)valType) || KotlinBuiltIns.isChar((KotlinType)minType) || KotlinBuiltIns.isChar((KotlinType)maxType)) {
                    return null;
                }
                if (this.isInteger(valType) && (this.isFloatingPoint(minType) || this.isFloatingPoint(maxType))) {
                    return null;
                }
                if (this.isFloatingPoint(valType)) {
                    if (this.isInteger(minType)) {
                        String string = this.getDoubleConstant(min, minType, context2);
                        if (string == null) {
                            return null;
                        }
                        minVal = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)minVal), (boolean)false, (int)2, null).createExpression(string);
                    }
                    if (this.isInteger(maxType)) {
                        String string = this.getDoubleConstant(max, maxType, context2);
                        if (string == null) {
                            return null;
                        }
                        maxVal = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)maxVal), (boolean)false, (int)2, null).createExpression(string);
                    }
                }
            } else {
                return null;
            }
        }
        if ((incrementMinByOne || decrementMaxByOne) && !this.isValidTypeForIncrementDecrementByOne(valType)) {
            return null;
        }
        String minText = incrementMinByOne ? $fun$getChangeBy$3.invoke(minVal, context2, 1) : minVal.getText();
        String maxText = decrementMaxByOne ? $fun$getChangeBy$3.invoke(maxVal, context2, -1) : maxVal.getText();
        String string = minText;
        if (string == null) {
            return null;
        }
        String string2 = maxText;
        if (string2 == null) {
            return null;
        }
        return new RangeExpressionData(value, string, string2);
    }

    private final String getDoubleConstant(KtExpression intExpr, KotlinType type2, BindingContext context2) {
        Object object = ConstantExpressionEvaluator.Companion.getConstant(intExpr, context2);
        if (object == null || (object = object.getValue(type2)) == null) {
            return null;
        }
        Object intConst = object;
        Object object2 = intConst;
        if (!(object2 instanceof Number)) {
            object2 = null;
        }
        Number number = (Number)object2;
        return number != null ? String.valueOf(number.doubleValue()) : null;
    }

    private final boolean isComparable(KotlinType $this$isComparable) {
        return DescriptorUtils.isSubtypeOfClass((KotlinType)$this$isComparable, (DeclarationDescriptor)((DeclarationDescriptor)TypeUtilsKt.getBuiltIns((KotlinType)$this$isComparable).getComparable()));
    }

    private final boolean isFloatingPoint(KotlinType $this$isFloatingPoint) {
        return KotlinBuiltIns.isFloat((KotlinType)$this$isFloatingPoint) || KotlinBuiltIns.isDouble((KotlinType)$this$isFloatingPoint);
    }

    private final boolean isInteger(KotlinType $this$isInteger) {
        return KotlinBuiltIns.isInt((KotlinType)$this$isInteger) || KotlinBuiltIns.isLong((KotlinType)$this$isInteger) || KotlinBuiltIns.isShort((KotlinType)$this$isInteger) || KotlinBuiltIns.isByte((KotlinType)$this$isInteger);
    }

    private final boolean isValidTypeForIncrementDecrementByOne(KotlinType $this$isValidTypeForIncrementDecrementByOne) {
        if ($this$isValidTypeForIncrementDecrementByOne == null) {
            return false;
        }
        return this.isInteger($this$isValidTypeForIncrementDecrementByOne) || KotlinBuiltIns.isChar((KotlinType)$this$isValidTypeForIncrementDecrementByOne);
    }

    public ConvertTwoComparisonsToRangeCheckInspection() {
        super(KtBinaryExpression.class);
    }

    public static final /* synthetic */ boolean access$isValidTypeForIncrementDecrementByOne(ConvertTwoComparisonsToRangeCheckInspection $this, KotlinType $this$access_u24isValidTypeForIncrementDecrementByOne) {
        return $this.isValidTypeForIncrementDecrementByOne($this$access_u24isValidTypeForIncrementDecrementByOne);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "", "value", "Lorg/jetbrains/kotlin/psi/KtExpression;", "min", "", "max", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Ljava/lang/String;)V", "getMax", "()Ljava/lang/String;", "getMin", "getValue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "component1", "component2", "component3", "copy", "createExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "equals", "", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class RangeExpressionData {
        @NotNull
        private final KtExpression value;
        @NotNull
        private final String min;
        @NotNull
        private final String max;

        @NotNull
        public final KtBinaryExpression createExpression() {
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)this.value), (boolean)false, (int)2, null);
            KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0 in $1..$2", (Object[])new Object[]{this.value, factory2.createExpression(this.min), factory2.createExpression(this.max)}, (boolean)false, (int)4, null);
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            return (KtBinaryExpression)ktExpression;
        }

        @NotNull
        public final KtExpression getValue() {
            return this.value;
        }

        @NotNull
        public final String getMin() {
            return this.min;
        }

        @NotNull
        public final String getMax() {
            return this.max;
        }

        public RangeExpressionData(@NotNull KtExpression value, @NotNull String min, @NotNull String max) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            this.value = value;
            this.min = min;
            this.max = max;
        }

        @NotNull
        public final KtExpression component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.min;
        }

        @NotNull
        public final String component3() {
            return this.max;
        }

        @NotNull
        public final RangeExpressionData copy(@NotNull KtExpression value, @NotNull String min, @NotNull String max) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            return new RangeExpressionData(value, min, max);
        }

        public static /* synthetic */ RangeExpressionData copy$default(RangeExpressionData rangeExpressionData, KtExpression ktExpression, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = rangeExpressionData.value;
            }
            if ((n & 2) != 0) {
                string = rangeExpressionData.min;
            }
            if ((n & 4) != 0) {
                string2 = rangeExpressionData.max;
            }
            return rangeExpressionData.copy(ktExpression, string, string2);
        }

        @NotNull
        public String toString() {
            return "RangeExpressionData(value=" + this.value + ", min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            KtExpression ktExpression = this.value;
            String string = this.min;
            String string2 = this.max;
            return ((ktExpression != null ? ktExpression.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RangeExpressionData)) break block3;
                    RangeExpressionData rangeExpressionData = (RangeExpressionData)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)rangeExpressionData.value) || !Intrinsics.areEqual((Object)this.min, (Object)rangeExpressionData.min) || !Intrinsics.areEqual((Object)this.max, (Object)rangeExpressionData.max)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

