/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertNaNEqualityQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "inverted", "", "(Z)V", "getInverted", "()Z", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
final class ConvertNaNEqualityQuickFix
implements LocalQuickFix {
    private final boolean inverted;

    @NotNull
    public String getName() {
        return KotlinBundle.message("convert.na.n.equality.quick.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtBinaryExpression)) {
            psiElement2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element3 = ktBinaryExpression;
        if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element3.getLeft())) {
            ktExpression = element3.getRight();
            if (ktExpression == null) {
                return;
            }
        } else if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element3.getRight())) {
            ktExpression = element3.getLeft();
            if (ktExpression == null) {
                return;
            }
        } else {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"when {\n            eleme\u2026 else -> return\n        }");
        KtExpression other = ktExpression;
        String pattern = this.inverted ? "!$0.isNaN()" : "$0.isNaN()";
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null), (String)pattern, (Object[])new Object[]{other}, (boolean)false, (int)4, null));
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    public ConvertNaNEqualityQuickFix(boolean inverted) {
        this.inverted = inverted;
    }
}

