/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightExitPointsHandlerFactoryKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactoryBase;", "()V", "createHighlightUsagesHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lcom/intellij/psi/PsiElement;", "Companion", "OnExitUsagesHandler", "kotlin.idea"})
public final class KotlinHighlightExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    private static final TokenSet RETURN_AND_THROW;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public HighlightUsagesHandlerBase<?> createHighlightUsagesHandler(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull PsiElement target2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        HighlightUsagesHandlerBase highlightUsagesHandlerBase = KotlinHighlightExitPointsHandlerFactory.Companion.getOnReturnOrThrowUsageHandler(editor2, file2, target2);
        if (highlightUsagesHandlerBase == null) {
            highlightUsagesHandlerBase = KotlinHighlightExitPointsHandlerFactory.Companion.getOnLambdaCallUsageHandler(editor2, file2, target2);
        }
        return highlightUsagesHandlerBase;
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.RETURN_KEYWORD, (IElementType)KtTokens.THROW_KEYWORD});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens\u2026, KtTokens.THROW_KEYWORD)");
        RETURN_AND_THROW = tokenSet;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0016\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00132\u0016\u0010\u0017\u001a\u0012\u0012\u000e\b\u0000\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00130\u0018H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory$OnExitUsagesHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightReferences", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getHighlightReferences", "()Z", "getTarget", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "computeUsages", "", "targets", "", "getTargets", "", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "kotlin.idea"})
    private static final class OnExitUsagesHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        @NotNull
        private final KtExpression target;
        private final boolean highlightReferences;

        @NotNull
        public List<KtExpression> getTargets() {
            return CollectionsKt.listOf((Object)this.target);
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
            selectionConsumer.consume(targets);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            block0: {
                KtDeclarationWithBody relevantFunction;
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                KtDeclarationWithBody ktDeclarationWithBody = relevantFunction = this.target instanceof KtFunctionLiteral ? (KtDeclarationWithBody)this.target : KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(this.target);
                if (ktDeclarationWithBody == null) break block0;
                ktDeclarationWithBody.accept((PsiElementVisitor)new KtVisitorVoid(this, relevantFunction){
                    final /* synthetic */ OnExitUsagesHandler this$0;
                    final /* synthetic */ KtDeclarationWithBody $relevantFunction;

                    public void visitKtElement(@NotNull KtElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        ProgressIndicatorProvider.checkCanceled();
                        element3.acceptChildren((PsiElementVisitor)this);
                    }

                    public void visitExpression(@NotNull KtExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (this.$relevantFunction instanceof KtFunctionLiteral && this.occurrenceForFunctionLiteralReturnExpression(expression2)) {
                            return;
                        }
                        super.visitExpression(expression2);
                    }

                    private final boolean occurrenceForFunctionLiteralReturnExpression(KtExpression expression2) {
                        if (!KtPsiUtil.isStatement((PsiElement)((PsiElement)expression2))) {
                            return false;
                        }
                        if (expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression || expression2 instanceof KtBlockExpression) {
                            return false;
                        }
                        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.FULL);
                        if (!BindingContextUtilsKt.isUsedAsResultOfLambda((KtExpression)expression2, (BindingContext)bindingContext2)) {
                            return false;
                        }
                        if (Intrinsics.areEqual((Object)KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(expression2), (Object)this.$relevantFunction) ^ true) {
                            return false;
                        }
                        OnExitUsagesHandler.access$addOccurrence(this.this$0, (PsiElement)expression2);
                        return true;
                    }

                    private final void visitReturnOrThrow(KtExpression expression2) {
                        if (Intrinsics.areEqual((Object)KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(expression2), (Object)this.$relevantFunction)) {
                            OnExitUsagesHandler.access$addOccurrence(this.this$0, (PsiElement)expression2);
                        }
                    }

                    public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.visitReturnOrThrow((KtExpression)expression2);
                    }

                    public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.visitReturnOrThrow((KtExpression)expression2);
                    }
                    {
                        this.this$0 = this$0;
                        this.$relevantFunction = $captured_local_variable$1;
                    }
                });
            }
        }

        public boolean highlightReferences() {
            return this.highlightReferences;
        }

        @NotNull
        public final KtExpression getTarget() {
            return this.target;
        }

        public final boolean getHighlightReferences() {
            return this.highlightReferences;
        }

        public OnExitUsagesHandler(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull KtExpression target2, boolean highlightReferences) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super(editor2, file2);
            this.target = target2;
            this.highlightReferences = highlightReferences;
        }

        public /* synthetic */ OnExitUsagesHandler(Editor editor2, PsiFile psiFile, KtExpression ktExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(editor2, psiFile, ktExpression, bl);
        }

        public static final /* synthetic */ void access$addOccurrence(OnExitUsagesHandler $this, PsiElement p0) {
            $this.addOccurrence(p0);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory$Companion;", "", "()V", "RETURN_AND_THROW", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getOnLambdaCallUsageHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lcom/intellij/psi/PsiElement;", "getOnReturnOrThrowUsageHandler", "kotlin.idea"})
    public static final class Companion {
        private final HighlightUsagesHandlerBase<?> getOnReturnOrThrowUsageHandler(Editor editor2, PsiFile file2, PsiElement target2) {
            if (!(target2 instanceof LeafPsiElement) || !RETURN_AND_THROW.contains(((LeafPsiElement)target2).getElementType())) {
                return null;
            }
            KtExpression ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)target2, (Class[])new Class[]{KtReturnExpression.class, KtThrowExpression.class});
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"PsiTreeUtil.getParentOfT\u2026         ) ?: return null");
            KtExpression returnOrThrow = ktExpression;
            return new OnExitUsagesHandler(editor2, file2, returnOrThrow, false, 8, null);
        }

        private final HighlightUsagesHandlerBase<?> getOnLambdaCallUsageHandler(Editor editor2, PsiFile file2, PsiElement target2) {
            if (!(target2 instanceof LeafPsiElement) || Intrinsics.areEqual((Object)((LeafPsiElement)target2).getElementType(), (Object)KtTokens.IDENTIFIER) ^ true) {
                return null;
            }
            PsiElement psiElement2 = ((LeafPsiElement)target2).getParent();
            if (!(psiElement2 instanceof KtNameReferenceExpression)) {
                psiElement2 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)psiElement2;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression refExpr = ktNameReferenceExpression;
            PsiElement psiElement3 = refExpr.getParent();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression call = ktCallExpression;
            if (Intrinsics.areEqual((Object)call.getCalleeExpression(), (Object)refExpr) ^ true) {
                return null;
            }
            List list = call.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.lambdaArguments");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
            if (ktLambdaArgument == null) {
                return null;
            }
            KtLambdaArgument lambda2 = ktLambdaArgument;
            KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
            if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktLambdaExpression, (String)"lambda.getLambdaExpressi\u2026ionLiteral ?: return null");
            KtLambdaExpression literal = ktLambdaExpression;
            return new OnExitUsagesHandler(editor2, file2, (KtExpression)literal, true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

