/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.hierarchy.calls.CallHierarchyUtilsKt;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCalleeTreeStructure;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallerTreeStructure;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0014J \u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\b\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0014J \u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011`\u0012H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/CallHierarchyBrowserBase;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "type", "", "psiElement", "createTrees", "", "trees", "", "Ljavax/swing/JTree;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "Lkotlin/Comparator;", "getElementFromDescriptor", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "isApplicableElement", "", "Companion", "kotlin.idea"})
public final class KotlinCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        CallHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisMethodAction = new CallHierarchyBrowserBase.BaseOnThisMethodAction();
        JTree jTree = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"createTree(false)");
        JTree tree1 = jTree;
        PopupHandler.installPopupMenu((JComponent)tree1, (String)"CallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        AnAction anAction = ActionManager.getInstance().getAction("CallHierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstanc\u2026ns.ACTION_CALL_HIERARCHY)");
        baseOnThisMethodAction.registerCustomShortcutSet(anAction.getShortcutSet(), (JComponent)tree1);
        trees.put("Callees of {0}", tree1);
        JTree jTree2 = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree2, (String)"createTree(false)");
        JTree tree2 = jTree2;
        PopupHandler.installPopupMenu((JComponent)tree2, (String)"CallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        AnAction anAction2 = ActionManager.getInstance().getAction("CallHierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"ActionManager.getInstanc\u2026ns.ACTION_CALL_HIERARCHY)");
        baseOnThisMethodAction.registerCustomShortcutSet(anAction2.getShortcutSet(), (JComponent)tree2);
        trees.put("Callers of {0}", tree2);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return KotlinCallHierarchyBrowser.Companion.getTargetElement(descriptor2);
    }

    protected boolean isApplicableElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof PsiClass ? false : CallHierarchyUtilsKt.isCallHierarchyElement(element3);
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type2, @NotNull PsiElement psiElement2) {
        HierarchyTreeStructure hierarchyTreeStructure;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtElement)) {
            return null;
        }
        switch (type2) {
            case "Callers of {0}": {
                KtElement ktElement = (KtElement)psiElement2;
                String string = this.getCurrentScopeType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentScopeType");
                hierarchyTreeStructure = new KotlinCallerTreeStructure(ktElement, string);
                break;
            }
            case "Callees of {0}": {
                KtElement ktElement = (KtElement)psiElement2;
                String string = this.getCurrentScopeType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentScopeType");
                hierarchyTreeStructure = new KotlinCalleeTreeStructure(ktElement, string);
                break;
            }
            default: {
                hierarchyTreeStructure = null;
            }
        }
        return hierarchyTreeStructure;
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> getComparator() {
        Comparator comparator = JavaHierarchyUtil.getComparator((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"JavaHierarchyUtil.getComparator(myProject)");
        return comparator;
    }

    public KotlinCallHierarchyBrowser(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super(element3.getProject(), element3);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyBrowser$Companion;", "", "()V", "getTargetElement", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "kotlin.idea"})
    public static final class Companion {
        private final PsiElement getTargetElement(HierarchyNodeDescriptor descriptor2) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor = descriptor2;
            if (!(hierarchyNodeDescriptor instanceof KotlinCallHierarchyNodeDescriptor)) {
                hierarchyNodeDescriptor = null;
            }
            KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor = (KotlinCallHierarchyNodeDescriptor)hierarchyNodeDescriptor;
            return kotlinCallHierarchyNodeDescriptor != null ? kotlinCallHierarchyNodeDescriptor.getPsiElement() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

