/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J4\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "preprocessEnterInStringLiteral", "", "psiFile", "caretAdvanceRef", "Companion", "kotlin.idea"})
public final class KotlinEnterHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG;
    private static final TokenSet FORCE_INDENT_IN_LAMBDA_AFTER;
    @NotNull
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof KtFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.preprocessEnterInStringLiteral(file, editor, caretOffsetRef, caretAdvance)) {
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        v0 = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNull((Object)v0);
        if (!v0.SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        v1 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"editor.document");
        document = v1;
        v2 = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"document.charsSequence");
        text = v2;
        v3 = caretOffsetRef.get();
        Intrinsics.checkNotNull((Object)v3);
        caretOffset = ((Number)v3).intValue();
        var10_10 = caretOffset;
        if (0 > var10_10 || text.length() < var10_10) {
            return EnterHandlerDelegate.Result.Continue;
        }
        elementAt = file.findElementAt(caretOffset);
        if (elementAt instanceof PsiWhiteSpace) {
            v4 = elementAt.getText();
            Intrinsics.checkNotNull((Object)v4);
            if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        elementBefore = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter((PsiFile)file, (int)caretOffset);
        elementAfter = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore((PsiFile)file, (int)caretOffset);
        if (elementBefore == null) ** GOTO lbl-1000
        v5 = elementBefore.getNode();
        Intrinsics.checkNotNull((Object)v5);
        if (KotlinEnterHandler.FORCE_INDENT_IN_LAMBDA_AFTER.contains(v5.getElementType())) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = isAfterLBraceOrArrow = false;
        }
        if (elementAfter == null) ** GOTO lbl-1000
        v7 = elementAfter.getNode();
        Intrinsics.checkNotNull((Object)v7);
        if (Intrinsics.areEqual((Object)v7.getElementType(), (Object)KtTokens.RBRACE)) lbl-1000:
        // 2 sources

        {
            v8 = true;
        } else {
            v8 = isBeforeRBrace = false;
        }
        if (isAfterLBraceOrArrow && isBeforeRBrace) {
            v9 = elementBefore;
            Intrinsics.checkNotNull((Object)v9);
            if (v9.getParent() instanceof KtFunctionLiteral) {
                v10 = originalHandler;
                if (v10 != null) {
                    v11 = editor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"editor.caretModel");
                    v10.execute(editor, v11.getCurrentCaret(), dataContext);
                }
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                try {
                    v12 = CodeStyleManager.getInstance((Project)file.getProject());
                    Intrinsics.checkNotNull((Object)v12);
                    v13 = editor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"editor.caretModel");
                    v12.adjustLineIndent(file, v13.getOffset());
                }
                catch (IncorrectOperationException e) {
                    KotlinEnterHandler.LOG.error((Throwable)e);
                }
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private final boolean preprocessEnterInStringLiteral(PsiFile psiFile, Editor editor2, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvanceRef) {
        IElementType tokenType;
        PsiElement psiAtOffset;
        Integer caretOffset;
        Integer n = caretOffset = (Integer)caretOffsetRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"caretOffset");
        PsiElement psiElement2 = psiFile.findElementAt(n.intValue());
        if (psiElement2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"psiFile.findElementAt(caretOffset) ?: return false");
        PsiElement $this$getStrictParentOfType$iv = psiAtOffset = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtStringTemplateExpression.class, (boolean)true);
        if (ktStringTemplateExpression == null) {
            return false;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        if (!KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)stringTemplate)) {
            return false;
        }
        ASTNode aSTNode = psiAtOffset.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"psiAtOffset.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"psiAtOffset.node.elementType");
        IElementType iElementType2 = tokenType = iElementType;
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.CLOSING_QUOTE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.REGULAR_STRING_PART) || Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.ESCAPE_SEQUENCE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document doc = document;
            int caretAdvance = 1;
            if (stringTemplate.getParent() instanceof KtDotQualifiedExpression) {
                doc.insertString(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)stringTemplate)), (CharSequence)")");
                doc.insertString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)stringTemplate)), (CharSequence)"(");
                Integer n2 = caretOffset;
                caretOffset = n2 + 1;
                ++caretAdvance;
            }
            doc.insertString(caretOffset.intValue(), (CharSequence)"\" + \"");
            caretOffsetRef.set((Object)(caretOffset + 3));
            caretAdvanceRef.set((Object)caretAdvance);
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinEnterHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(KotlinEnterHandler::class.java)");
        LOG = logger;
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.ARROW, (IElementType)KtTokens.LBRACE});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens.ARROW, KtTokens.LBRACE)");
        FORCE_INDENT_IN_LAMBDA_AFTER = tokenSet;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterHandler$Companion;", "", "()V", "FORCE_INDENT_IN_LAMBDA_AFTER", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

