/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.conversion.copy.ContextDeclarations;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$WhenMappings;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$isParsedAsFile$;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedJavaCode;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedKotlinCode;
import org.jetbrains.kotlin.idea.conversion.copy.DataForConversion;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.JavaContextDeclarationRenderer;
import org.jetbrains.kotlin.idea.conversion.copy.PlainTextPasteImportResolver;
import org.jetbrains.kotlin.idea.core.util.RangeUtilsKt;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004FGHIB\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010-\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00100\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00101\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00102\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00103\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u000bH\u0002JF\u00105\u001a\u0002062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020$2\u000e\u0010:\u001a\n\u0012\u0006\b\u0000\u0012\u00020*0;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J&\u0010=\u001a\u00020>*\u00020?2\u0006\u0010\u001f\u001a\u00020 2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020*H\u0002J\u0014\u0010C\u001a\u00020D*\u00020?2\u0006\u0010E\u001a\u00020\"H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "javaContextDeclarationRenderer", "Lorg/jetbrains/kotlin/idea/conversion/copy/JavaContextDeclarationRenderer;", "pasteContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getPasteContext", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "createCopiedJavaCode", "Lorg/jetbrains/kotlin/idea/conversion/copy/CopiedJavaCode;", "prefix", "", "templateWithoutPrefix", "text", "detectConversionContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "project", "Lcom/intellij/openapi/project/Project;", "detectPasteTarget", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "isParsedAsFile", "", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "isParsedAsJavaCode", "context", "isParsedAsJavaFile", "isParsedAsKotlinCode", "isParsedAsKotlinFile", "parseAsFile", "prepareCopiedJavaCodeByContext", "target", "processTransferableData", "", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "indented", "Lcom/intellij/openapi/util/Ref;", "values", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/DataForConversion;", "targetModule", "Lcom/intellij/openapi/module/Module;", "useNewJ2k", "tryResolveImports", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "targetFile", "Companion", "JavaContext", "KotlinContext", "MyTransferableData", "kotlin.idea"})
public final class ConvertTextJavaCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    private final Logger LOG;
    private final JavaContextDeclarationRenderer javaContextDeclarationRenderer;
    private static boolean conversionPerformed;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (file2 instanceof KtFile) {
            String string = ((KtFile)file2).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
            return CollectionsKt.listOf((Object)new CopiedKotlinCode(string, startOffsets, endOffsets));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            if (content2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (content2.isDataFlavorSupported(CopiedKotlinCode.Companion.getDATA_FLAVOR()) || content2.isDataFlavorSupported(CopiedJavaCode.Companion.getDATA_FLAVOR())) {
                    return CollectionsKt.emptyList();
                }
                Object object = content2.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String text2 = (String)object;
                return CollectionsKt.listOf((Object)new MyTransferableData(text2));
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.LOG.error(e);
        }
        return CollectionsKt.emptyList();
    }

    public void processTransferableData(@NotNull Project project2, @NotNull Editor editor2, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        DumbService dumbService = DumbService.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return;
        }
        KotlinEditorOptions kotlinEditorOptions = KotlinEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinEditorOptions, (String)"KotlinEditorOptions.getInstance()");
        if (!kotlinEditorOptions.isEnableJavaToKotlinConversion()) {
            return;
        }
        Object object = CollectionsKt.single(values);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor.MyTransferableData");
        }
        String string = TextBlockTransferable.convertLineSeparators((Editor)editor2, (String)((MyTransferableData)object).getText(), (Collection)values);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextBlockTransferable.co\u2026erableData).text, values)");
        String text2 = string;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor2.getDocument());
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return;
        }
        KtFile targetFile2 = ktFile;
        psiDocumentManager.commitDocument(editor2.getDocument());
        boolean useNewJ2k = ConvertJavaCopyPasteProcessorKt.checkUseNewJ2k(targetFile2);
        Module targetModule = ProjectStructureUtilKt.getModule((PsiElement)targetFile2);
        KtElement ktElement = this.detectPasteTarget(targetFile2, bounds.getStartOffset(), bounds.getEndOffset());
        if (ktElement == null) {
            return;
        }
        KtElement pasteTarget = ktElement;
        JavaContext javaContext = this.detectConversionContext(this.getPasteContext(pasteTarget), text2, project2);
        if (javaContext == null) {
            return;
        }
        JavaContext conversionContext = javaContext;
        if (!ConvertJavaCopyPasteProcessorKt.confirmConvertJavaOnPaste(project2, true)) {
            return;
        }
        CopiedJavaCode copiedJavaCode = this.prepareCopiedJavaCodeByContext(text2, conversionContext, pasteTarget);
        DataForConversion dataForConversion = DataForConversion.Companion.prepare(copiedJavaCode, project2);
        Function0<Unit> $fun$convert$1 = new Function0<Unit>(this, dataForConversion, targetFile2, project2, targetModule, useNewJ2k, editor2, bounds, psiDocumentManager){
            final /* synthetic */ ConvertTextJavaCopyPasteProcessor this$0;
            final /* synthetic */ DataForConversion $dataForConversion;
            final /* synthetic */ KtFile $targetFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ Module $targetModule;
            final /* synthetic */ boolean $useNewJ2k;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ RangeMarker $bounds;
            final /* synthetic */ PsiDocumentManager $psiDocumentManager;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void convertedImportsText;
                ElementAndTextList additionalImports = ConvertTextJavaCopyPasteProcessor.access$tryResolveImports(this.this$0, this.$dataForConversion, this.$targetFile);
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin(additionalImports, this.$project, this.$targetModule, this.$useNewJ2k).getText();
                ConversionResult convertedResult = ConvertTextJavaCopyPasteProcessor.access$convertCodeToKotlin(this.this$0, this.$dataForConversion, this.$project, this.$targetModule, this.$useNewJ2k);
                String convertedText = convertedResult.getText();
                Object object = ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<RangeMarker>(this, (Ref.ObjectRef)convertedImportsText, convertedText){
                    final /* synthetic */ processTransferableData.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $convertedImportsText;
                    final /* synthetic */ String $convertedText;

                    @NotNull
                    public final RangeMarker invoke() {
                        int importsInsertOffset;
                        KtImportList ktImportList = this.this$0.$targetFile.getImportList();
                        int n = importsInsertOffset = ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0;
                        if (this.this$0.$targetFile.getImportDirectives().isEmpty() && importsInsertOffset > 0) {
                            this.$convertedImportsText.element = "\n" + (String)this.$convertedImportsText.element;
                        }
                        CharSequence charSequence = (String)this.$convertedImportsText.element;
                        boolean bl = false;
                        if (!StringsKt.isBlank((CharSequence)charSequence)) {
                            this.this$0.$editor.getDocument().insertString(importsInsertOffset, (CharSequence)((String)this.$convertedImportsText.element));
                        }
                        int startOffset = this.this$0.$bounds.getStartOffset();
                        this.this$0.$editor.getDocument().replaceString(startOffset, this.this$0.$bounds.getEndOffset(), (CharSequence)this.$convertedText);
                        int endOffsetAfterCopy = startOffset + this.$convertedText.length();
                        this.this$0.$editor.getCaretModel().moveToOffset(endOffsetAfterCopy);
                        return this.this$0.$editor.getDocument().createRangeMarker(startOffset, startOffset + this.$convertedText.length());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$convertedImportsText = objectRef;
                        this.$convertedText = string;
                        super(0);
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction {\n       \u2026ext.length)\n            }");
                RangeMarker newBounds2 = (RangeMarker)object;
                this.$psiDocumentManager.commitAllDocuments();
                if (this.$useNewJ2k) {
                    PostProcessor postProcessor = J2kConverterExtension.Companion.extension(this.$useNewJ2k).createPostProcessor(true);
                    Iterable $this$forEach$iv = convertedResult.getImportsToAdd();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FqName fqName = (FqName)element$iv;
                        boolean bl = false;
                        postProcessor.insertImport(this.$targetFile, fqName);
                    }
                }
                ConvertJavaCopyPasteProcessorKt.runPostProcessing(this.$project, this.$targetFile, RangeUtilsKt.getRange((RangeMarker)newBounds2), convertedResult.getConverterContext(), this.$useNewJ2k);
                ConvertTextJavaCopyPasteProcessor.Companion.setConversionPerformed(true);
            }
            {
                this.this$0 = convertTextJavaCopyPasteProcessor;
                this.$dataForConversion = dataForConversion;
                this.$targetFile = ktFile;
                this.$project = project2;
                this.$targetModule = module;
                this.$useNewJ2k = bl;
                this.$editor = editor2;
                this.$bounds = rangeMarker;
                this.$psiDocumentManager = psiDocumentManager;
                super(0);
            }
        };
        boolean $i$f$measureTimeMillis = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        $fun$convert$1.invoke();
        long conversionTime = System.currentTimeMillis() - start$iv;
        J2KFusCollector.Companion.log(ConversionType.TEXT_EXPRESSION, ConvertJavaCopyPasteProcessorKt.checkUseNewJ2k(targetFile2), conversionTime, ConvertJavaCopyPasteProcessorKt.linesCount(dataForConversion.getElementsAndTexts()), 1);
    }

    private final ConversionResult convertCodeToKotlin(DataForConversion $this$convertCodeToKotlin, Project project2, Module targetModule, boolean useNewJ2k) {
        return ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin($this$convertCodeToKotlin.getElementsAndTexts(), project2, targetModule, useNewJ2k);
    }

    private final KotlinContext getPasteContext(KtElement $this$pasteContext) {
        KtElement ktElement = $this$pasteContext;
        return ktElement instanceof KtFile ? KotlinContext.TOP_LEVEL : (ktElement instanceof KtClassBody ? KotlinContext.CLASS_BODY : (ktElement instanceof KtBlockExpression ? KotlinContext.IN_BLOCK : KotlinContext.EXPRESSION));
    }

    private final KtElement detectPasteTarget(KtFile file2, int startOffset, int endOffset2) {
        PsiFile newFile;
        if (ConvertJavaCopyPasteProcessorKt.isNoConversionPosition(file2, startOffset)) {
            return null;
        }
        String fileText = file2.getText();
        String dummyDeclarationText = "fun dummy(){}";
        StringBuilder stringBuilder = new StringBuilder();
        String string = fileText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileText");
        String string2 = string;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append(' ').append(dummyDeclarationText).append('\n');
        string2 = fileText;
        n = 0;
        String string5 = string2.substring(endOffset2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String newFileText = stringBuilder2.append(string5).toString();
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        LanguageFileType languageFileType = (LanguageFileType)kotlinFileType;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        PsiFile psiFile = newFile = this.parseAsFile(newFileText, languageFileType, project2);
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtPsiFactoryKt.setAnalysisContext((KtFile)((KtFile)psiFile), (PsiElement)((PsiElement)file2));
        PsiElement psiElement2 = newFile.findElementAt(startOffset + 1);
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"newFile.findElementAt(st\u2026ffset + 1) ?: return null");
        PsiElement funKeyword = psiElement2;
        ASTNode aSTNode = funKeyword.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"funKeyword.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.FUN_KEYWORD) ^ true) {
            return null;
        }
        PsiElement psiElement3 = funKeyword.getParent();
        if (!(psiElement3 instanceof KtFunction)) {
            psiElement3 = null;
        }
        KtFunction ktFunction = (KtFunction)psiElement3;
        if (ktFunction == null) {
            return null;
        }
        KtFunction declaration2 = ktFunction;
        PsiElement psiElement4 = declaration2.getParent();
        if (!(psiElement4 instanceof KtElement)) {
            psiElement4 = null;
        }
        return (KtElement)psiElement4;
    }

    private final JavaContext detectConversionContext(KotlinContext pasteContext, String text2, Project project2) {
        if (this.isParsedAsKotlinCode(text2, pasteContext, project2)) {
            return null;
        }
        Function1<JavaContext, JavaContext> $fun$check$1 = new Function1<JavaContext, JavaContext>(this, text2, project2){
            final /* synthetic */ ConvertTextJavaCopyPasteProcessor this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ Project $project;

            @Nullable
            public final JavaContext invoke(@NotNull JavaContext $this$check) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$check), (String)"$this$check");
                JavaContext javaContext = $this$check;
                boolean bl = false;
                boolean bl2 = false;
                JavaContext it = javaContext;
                boolean bl3 = false;
                return ConvertTextJavaCopyPasteProcessor.access$isParsedAsJavaCode(this.this$0, this.$text, it, this.$project) ? javaContext : null;
            }
            {
                this.this$0 = convertTextJavaCopyPasteProcessor;
                this.$text = string;
                this.$project = project2;
                super(1);
            }
        };
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$0[pasteContext.ordinal()]) {
            case 1: {
                JavaContext javaContext = $fun$check$1.invoke(JavaContext.TOP_LEVEL);
                if (javaContext != null) {
                    JavaContext javaContext2 = javaContext;
                    boolean bl = false;
                    boolean bl2 = false;
                    JavaContext it = javaContext2;
                    boolean bl3 = false;
                    return it;
                }
                JavaContext javaContext3 = $fun$check$1.invoke(JavaContext.CLASS_BODY);
                if (javaContext3 != null) {
                    JavaContext javaContext4 = javaContext3;
                    boolean bl = false;
                    boolean bl4 = false;
                    JavaContext it = javaContext4;
                    boolean bl5 = false;
                    return it;
                }
                return null;
            }
            case 2: {
                return $fun$check$1.invoke(JavaContext.CLASS_BODY);
            }
            case 3: {
                return $fun$check$1.invoke(JavaContext.IN_BLOCK);
            }
            case 4: {
                return $fun$check$1.invoke(JavaContext.EXPRESSION);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean isParsedAsJavaCode(String text2, JavaContext context2, Project project2) {
        boolean bl;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1: {
                bl = this.isParsedAsJavaFile(text2, project2);
                break;
            }
            case 2: {
                bl = this.isParsedAsJavaFile("class Dummy { " + text2 + "\n}", project2);
                break;
            }
            case 3: {
                bl = this.isParsedAsJavaFile("class Dummy { void foo() {" + text2 + "\n}\n}", project2);
                break;
            }
            case 4: {
                bl = this.isParsedAsJavaFile("class Dummy { Object field = " + text2 + "; }", project2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isParsedAsKotlinCode(String text2, KotlinContext context2, Project project2) {
        boolean bl;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$2[context2.ordinal()]) {
            case 1: {
                bl = this.isParsedAsKotlinFile(text2, project2);
                break;
            }
            case 2: {
                bl = this.isParsedAsKotlinFile("class Dummy { " + text2 + "\n}", project2);
                break;
            }
            case 3: {
                bl = this.isParsedAsKotlinFile("fun foo() {" + text2 + "\n}", project2);
                break;
            }
            case 4: {
                bl = this.isParsedAsKotlinFile("val v = " + text2, project2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isParsedAsJavaFile(String text2, Project project2) {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"JavaFileType.INSTANCE");
        return this.isParsedAsFile(text2, (LanguageFileType)javaFileType, project2);
    }

    private final boolean isParsedAsKotlinFile(String text2, Project project2) {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        return this.isParsedAsFile(text2, (LanguageFileType)kotlinFileType, project2);
    }

    private final boolean isParsedAsFile(String text2, LanguageFileType fileType, Project project2) {
        PsiFile psiFile = this.parseAsFile(text2, fileType, project2);
        PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)psiFile;
        Function1 predicate$iv = isParsedAsFile$$inlined$anyDescendantOfType$1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    private final PsiFile parseAsFile(String text2, LanguageFileType fileType, Project project2) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)text2, LocalTimeCounter.currentTime(), true);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026nter.currentTime(), true)");
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementAndTextList tryResolveImports(DataForConversion $this$tryResolveImports, KtFile targetFile2) {
        void $this$flatMapTo$iv$iv;
        PlainTextPasteImportResolver importResolver = new PlainTextPasteImportResolver($this$tryResolveImports, targetFile2);
        importResolver.addImportsFromTargetFile();
        importResolver.tryResolveReferences();
        Iterable $this$flatMap$iv = importResolver.getAddedImports();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiImportStatementBase importStatement = (PsiImportStatementBase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Object[]{"\n", importStatement});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        List list2 = CollectionsKt.plus((Collection)list, (Object)"\n\n");
        return new ElementAndTextList(list2);
    }

    /*
     * WARNING - void declaration
     */
    private final CopiedJavaCode prepareCopiedJavaCodeByContext(String text2, JavaContext context2, KtElement target2) {
        CopiedJavaCode copiedJavaCode;
        String string;
        PsiFile psiFile = target2.getContainingFile();
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile targetFile2 = (KtFile)psiFile;
        ContextDeclarations contextDeclarations = this.javaContextDeclarationRenderer.render(target2);
        String string2 = contextDeclarations.component1();
        String memberDeclarations2 = contextDeclarations.component2();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        KtPackageDirective ktPackageDirective = targetFile2.getPackageDirective();
        if (ktPackageDirective != null) {
            KtPackageDirective ktPackageDirective2 = ktPackageDirective;
            boolean bl6 = false;
            boolean bl7 = false;
            KtPackageDirective it = ktPackageDirective2;
            boolean bl8 = false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.text");
            CharSequence charSequence = string3;
            boolean bl9 = false;
            if (charSequence.length() > 0) {
                $this$buildString.append(it.getText());
                $this$buildString.append(";\n");
            }
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String prefix = string4;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$3[context2.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Object[] $this$ifNotEmpty;
                boolean bl10;
                void $this$getParentOfType$iv;
                PsiElement psiElement2 = (PsiElement)target2;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
                Object[] lightClass = ktClass2 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2)) : null;
                bl3 = false;
                bl4 = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl11 = false;
                boolean bl12 = false;
                StringBuilder $this$buildString2 = stringBuilder2;
                boolean bl13 = false;
                $this$buildString2.append("class ");
                Object object = lightClass;
                if (lightClass == null || (object = object.getName()) == null) {
                    object = "Dummy";
                }
                $this$buildString2.append((String)object);
                Object[] objectArray = lightClass;
                if (lightClass != null && (objectArray = objectArray.getExtendsListTypes()) != null) {
                    Object[] $this$ifNotEmpty$iv = objectArray;
                    boolean $i$f$ifNotEmpty = false;
                    Object[] objectArray2 = $this$ifNotEmpty$iv;
                    boolean bl14 = false;
                    Object[] objectArray3 = objectArray2;
                    bl10 = false;
                    if (!(objectArray3.length == 0)) {
                        $this$ifNotEmpty = $this$ifNotEmpty$iv;
                        boolean bl15 = false;
                        StringBuilder cfr_ignored_0 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$ifNotEmpty, (Appendable)$this$buildString2, null, (CharSequence)" extends ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.1.1.INSTANCE, (int)58, null);
                    }
                }
                Object[] objectArray4 = lightClass;
                if (lightClass != null && (objectArray4 = objectArray4.getImplementsListTypes()) != null) {
                    Object[] $this$ifNotEmpty$iv = objectArray4;
                    boolean $i$f$ifNotEmpty = false;
                    Object[] objectArray5 = $this$ifNotEmpty$iv;
                    boolean bl16 = false;
                    Object[] objectArray6 = objectArray5;
                    bl10 = false;
                    if (!(objectArray6.length == 0)) {
                        $this$ifNotEmpty = $this$ifNotEmpty$iv;
                        boolean bl17 = false;
                        StringBuilder cfr_ignored_1 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$ifNotEmpty, (Appendable)$this$buildString2, null, (CharSequence)" implements ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.2.1.INSTANCE, (int)58, null);
                    }
                }
                String string5 = stringBuilder2.toString();
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String classDef2 = string;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$4[context2.ordinal()]) {
            case 1: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, "$", text2);
                break;
            }
            case 2: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, classDef2 + " {\n" + memberDeclarations2 + " $\n}", text2);
                break;
            }
            case 3: {
                void localDeclarations2;
                copiedJavaCode = this.createCopiedJavaCode(prefix, classDef2 + " {\n" + memberDeclarations2 + " void foo() {\n" + (String)localDeclarations2 + " $\n}\n}", text2);
                break;
            }
            case 4: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, classDef2 + " {\nObject field = $\n}", text2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return copiedJavaCode;
    }

    private final CopiedJavaCode createCopiedJavaCode(String prefix, String templateWithoutPrefix, String text2) {
        String template2 = prefix + templateWithoutPrefix;
        int index = StringsKt.indexOf$default((CharSequence)template2, (String)"$", (int)0, (boolean)false, (int)6, null);
        boolean bl = index >= 0;
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = template2;
        n = 0;
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(text2);
        string = template2;
        n = index + 1;
        bl4 = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String fileText = stringBuilder2.append(string5).toString();
        return new CopiedJavaCode(fileText, new int[]{index}, new int[]{index + text2.length()});
    }

    public ConvertTextJavaCopyPasteProcessor() {
        Logger logger = Logger.getInstance(ConvertTextJavaCopyPasteProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Conve\u2026steProcessor::class.java)");
        this.LOG = logger;
        this.javaContextDeclarationRenderer = new JavaContextDeclarationRenderer();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ ElementAndTextList access$tryResolveImports(ConvertTextJavaCopyPasteProcessor $this, DataForConversion $this$access_u24tryResolveImports, KtFile targetFile2) {
        return $this.tryResolveImports($this$access_u24tryResolveImports, targetFile2);
    }

    public static final /* synthetic */ ConversionResult access$convertCodeToKotlin(ConvertTextJavaCopyPasteProcessor $this, DataForConversion $this$access_u24convertCodeToKotlin, Project project2, Module targetModule, boolean useNewJ2k) {
        return $this.convertCodeToKotlin($this$access_u24convertCodeToKotlin, project2, targetModule, useNewJ2k);
    }

    public static final /* synthetic */ boolean access$isParsedAsJavaCode(ConvertTextJavaCopyPasteProcessor $this, String text2, JavaContext context2, Project project2) {
        return $this.isParsedAsJavaCode(text2, context2, project2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getFlavor", "Ljava/awt/datatransfer/DataFlavor;", "getOffsetCount", "", "getOffsets", "offsets", "", "index", "setOffsets", "Companion", "kotlin.idea"})
    private static final class MyTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final String text;
        @NotNull
        private static final DataFlavor DATA_FLAVOR;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(@Nullable int[] offsets, int index) {
            return index;
        }

        public int setOffsets(@Nullable int[] offsets, int index) {
            return index;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public MyTransferableData(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        static {
            Companion = new Companion(null);
            DATA_FLAVOR = new DataFlavor(ConvertTextJavaCopyPasteProcessor.class, "class: ConvertTextJavaCopyPasteProcessor");
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData$Companion;", "", "()V", "DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getDATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "kotlin.idea"})
        public static final class Companion {
            @NotNull
            public final DataFlavor getDATA_FLAVOR() {
                return DATA_FLAVOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class KotlinContext
    extends Enum<KotlinContext> {
        public static final /* enum */ KotlinContext TOP_LEVEL;
        public static final /* enum */ KotlinContext CLASS_BODY;
        public static final /* enum */ KotlinContext IN_BLOCK;
        public static final /* enum */ KotlinContext EXPRESSION;
        private static final /* synthetic */ KotlinContext[] $VALUES;

        static {
            KotlinContext[] kotlinContextArray = new KotlinContext[4];
            KotlinContext[] kotlinContextArray2 = kotlinContextArray;
            kotlinContextArray[0] = TOP_LEVEL = new KotlinContext();
            kotlinContextArray[1] = CLASS_BODY = new KotlinContext();
            kotlinContextArray[2] = IN_BLOCK = new KotlinContext();
            kotlinContextArray[3] = EXPRESSION = new KotlinContext();
            $VALUES = kotlinContextArray;
        }

        public static KotlinContext[] values() {
            return (KotlinContext[])$VALUES.clone();
        }

        public static KotlinContext valueOf(String string) {
            return Enum.valueOf(KotlinContext.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class JavaContext
    extends Enum<JavaContext> {
        public static final /* enum */ JavaContext TOP_LEVEL;
        public static final /* enum */ JavaContext CLASS_BODY;
        public static final /* enum */ JavaContext IN_BLOCK;
        public static final /* enum */ JavaContext EXPRESSION;
        private static final /* synthetic */ JavaContext[] $VALUES;

        static {
            JavaContext[] javaContextArray = new JavaContext[4];
            JavaContext[] javaContextArray2 = javaContextArray;
            javaContextArray[0] = TOP_LEVEL = new JavaContext();
            javaContextArray[1] = CLASS_BODY = new JavaContext();
            javaContextArray[2] = IN_BLOCK = new JavaContext();
            javaContextArray[3] = EXPRESSION = new JavaContext();
            $VALUES = javaContextArray;
        }

        public static JavaContext[] values() {
            return (JavaContext[])$VALUES.clone();
        }

        public static JavaContext valueOf(String string) {
            return Enum.valueOf(JavaContext.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$Companion;", "", "()V", "conversionPerformed", "", "getConversionPerformed", "()Z", "setConversionPerformed", "(Z)V", "kotlin.idea"})
    public static final class Companion {
        @TestOnly
        public final boolean getConversionPerformed() {
            return conversionPerformed;
        }

        public final void setConversionPerformed(boolean bl) {
            conversionPerformed = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

