/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.application.options.CodeStyle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.SuppressKotlinCodeStyleComponent;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.SuppressKotlinCodeStyleState;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"KOTLIN_UPDATE_CODE_STYLE_GROUP_ID", "", "createNotification", "Lcom/intellij/notification/Notification;", "notifyKotlinStyleUpdateIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class NewCodeStyleNotificationKt {
    private static final String KOTLIN_UPDATE_CODE_STYLE_GROUP_ID = "Update Kotlin code style";

    public static final void notifyKotlinStyleUpdateIfNeeded(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
        if (Intrinsics.areEqual((Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults((CodeStyleSettings)codeStyleSettings), (Object)"KOTLIN_OFFICIAL")) {
            return;
        }
        if (((SuppressKotlinCodeStyleState)SuppressKotlinCodeStyleComponent.Companion.getInstance(project2).getState()).getDisableForAll()) {
            return;
        }
        Notification notification = NewCodeStyleNotificationKt.createNotification();
        NotificationsConfiguration.getNotificationsConfiguration().register(KOTLIN_UPDATE_CODE_STYLE_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
        notification.notify(project2);
    }

    private static final Notification createNotification() {
        Notification notification = new Notification(KOTLIN_UPDATE_CODE_STYLE_GROUP_ID, KotlinBundle.message("configuration.kotlin.code.style", new Object[0]), KotlinBundle.htmlMessage("configuration.notification.update.code.style.to.official", new Object[0]), NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)KotlinBundle.message("configuration.apply.new.code.style", new Object[0]), (BiConsumer)createNotification.1.INSTANCE)).addAction((AnAction)NotificationAction.createExpiring((String)KotlinBundle.message("configuration.do.not.suggest.new.code.style", new Object[0]), (BiConsumer)createNotification.2.INSTANCE)).setImportant(true);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Notification(\n        KO\u2026      .setImportant(true)");
        return notification;
    }
}

