/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.HyperlinkEvent;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.actions.ConfigurePluginUpdatesAction;
import org.jetbrains.kotlin.idea.configuration.ModuleCompilerInfo;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.OutdatedBundledCompilerNotificationKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.psi.UserDataProperty;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0003\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017\u001a@\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001d2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"3\u0010\b\u001a\u0004\u0018\u00010\u0003*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"NUMBER_OF_MODULES_TO_SHOW", "", "OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID", "", "SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME", "alreadyNotified", "Ljava/util/concurrent/ConcurrentHashMap;", "<set-?>", "externalCompilerVersion", "Lcom/intellij/openapi/module/Module;", "getExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "setExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "externalCompilerVersion$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "createKotlinVersion", "Lkotlin/KotlinVersion;", "versionStr", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "createOutdatedBundledCompilerMessage", "project", "Lcom/intellij/openapi/project/Project;", "bundledCompilerVersion", "notifyOutdatedBundledCompilerIfNecessary", "", "selectedModulesForPopup", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/configuration/ModuleCompilerInfo;", "Lkotlin/collections/ArrayList;", "maxCompilerInfo", "newerModuleCompilerInfos", "kotlin.idea"})
public final class OutdatedBundledCompilerNotificationKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private static final UserDataProperty externalCompilerVersion$delegate;
    private static ConcurrentHashMap<String, String> alreadyNotified;
    private static final int NUMBER_OF_MODULES_TO_SHOW = 2;
    private static final String SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME = "outdated.bundled.kotlin.compiler";
    private static final String OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID = "Outdated Bundled Kotlin Compiler";

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(OutdatedBundledCompilerNotificationKt.class, "externalCompilerVersion", "getExternalCompilerVersion(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", 1))};
        Key key = Key.create((String)"EXTERNAL_COMPILER_VERSION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"EXTERNAL_COMPILER_VERSION\")");
        externalCompilerVersion$delegate = new UserDataProperty(key);
        alreadyNotified = new ConcurrentHashMap();
    }

    @Nullable
    public static final String getExternalCompilerVersion(@NotNull Module $this$externalCompilerVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$externalCompilerVersion, (String)"$this$externalCompilerVersion");
        return (String)externalCompilerVersion$delegate.getValue((UserDataHolder)$this$externalCompilerVersion, $$delegatedProperties[0]);
    }

    public static final void setExternalCompilerVersion(@NotNull Module $this$externalCompilerVersion, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)$this$externalCompilerVersion, (String)"$this$externalCompilerVersion");
        externalCompilerVersion$delegate.setValue((UserDataHolder)$this$externalCompilerVersion, $$delegatedProperties[0], (Object)string);
    }

    public static final void notifyOutdatedBundledCompilerIfNecessary(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project2).getValue(SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME))) {
            return;
        }
        String string = OutdatedBundledCompilerNotificationKt.createOutdatedBundledCompilerMessage$default(project2, null, 2, null);
        if (string == null) {
            return;
        }
        String message2 = string;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        new Notification(OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID, KotlinBundle.message("configuration.title.outdated.bundled.kotlin.compiler", new Object[0]), message2, NotificationType.WARNING).setListener(new NotificationListener(project2, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) return;
                String string = event.getDescription();
                if (string == null) throw (Throwable)((Object)new AssertionError());
                switch (string) {
                    case "update": {
                        AnAction action2 = ActionManager.getInstance().getAction(ConfigurePluginUpdatesAction.Companion.getACTION_ID());
                        DataManager dataManager = DataManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
                        AsyncResult asyncResult = dataManager.getDataContextFromFocus();
                        Intrinsics.checkNotNullExpressionValue((Object)asyncResult, (String)"DataManager.getInstance().dataContextFromFocus");
                        DataContext dataContext = (DataContext)asyncResult.getResult();
                        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"GoToAction", (DataContext)dataContext);
                        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026TION_SEARCH, dataContext)");
                        AnActionEvent actionEvent = anActionEvent;
                        action2.actionPerformed(actionEvent);
                        break;
                    }
                    case "ignore": {
                        if (this.$project.isDisposed()) break;
                        PropertiesComponent.getInstance((Project)this.$project).setValue("outdated.bundled.kotlin.compiler", this.$pluginVersion);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                notification.expire();
            }
            {
                this.$project = project2;
                this.$pluginVersion = string;
            }
        }).notify(project2);
    }

    @Nullable
    public static final String createOutdatedBundledCompilerMessage(@NotNull Project project2, @NotNull String bundledCompilerVersion) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bundledCompilerVersion, (String)"bundledCompilerVersion");
        KotlinVersion kotlinVersion = OutdatedBundledCompilerNotificationKt.createKotlinVersion(bundledCompilerVersion);
        if (kotlinVersion == null) {
            return null;
        }
        KotlinVersion bundledCompilerMajorVersion = kotlinVersion;
        ModuleCompilerInfo maxCompilerInfo = null;
        ArrayList<ModuleCompilerInfo> newerModuleCompilerInfos = new ArrayList<ModuleCompilerInfo>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            KotlinVersion externalCompilerMajorVersion;
            String externalCompilerVersion;
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            if (OutdatedBundledCompilerNotificationKt.getExternalCompilerVersion(module2) == null) {
                continue;
            }
            if (OutdatedBundledCompilerNotificationKt.createKotlinVersion(externalCompilerVersion) == null) {
                continue;
            }
            KotlinVersion languageMajorVersion = OutdatedBundledCompilerNotificationKt.createKotlinVersion(PlatformKt.getLanguageVersionSettings((Module)module).getLanguageVersion());
            if (externalCompilerMajorVersion.compareTo(bundledCompilerMajorVersion) <= 0 || languageMajorVersion.compareTo(bundledCompilerMajorVersion) <= 0) continue;
            ModuleCompilerInfo moduleCompilerInfo = new ModuleCompilerInfo(module, externalCompilerVersion, externalCompilerMajorVersion, languageMajorVersion);
            newerModuleCompilerInfos.add(moduleCompilerInfo);
            if (maxCompilerInfo != null && VersionComparatorUtil.COMPARATOR.compare(externalCompilerVersion, maxCompilerInfo.getExternalCompilerVersion()) <= 0) continue;
            maxCompilerInfo = moduleCompilerInfo;
        }
        if (maxCompilerInfo == null) {
            return null;
        }
        String lastProjectNotified = alreadyNotified.get(project2.getName());
        if (Intrinsics.areEqual((Object)lastProjectNotified, (Object)maxCompilerInfo.getExternalCompilerVersion())) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                return null;
            }
        }
        Map map2 = alreadyNotified;
        String string = project2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        map2.put(string, maxCompilerInfo.getExternalCompilerVersion());
        ArrayList<ModuleCompilerInfo> selectedNewerModulesInfos = OutdatedBundledCompilerNotificationKt.selectedModulesForPopup(project2, maxCompilerInfo, newerModuleCompilerInfos);
        if (selectedNewerModulesInfos.isEmpty()) {
            return null;
        }
        String modulesStr2 = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)selectedNewerModulesInfos), (int)2), (CharSequence)"", null, null, (int)0, null, (Function1)createOutdatedBundledCompilerMessage.modulesStr.1.INSTANCE, (int)30, null);
        if (selectedNewerModulesInfos.size() > 2) {
            modulesStr2 = modulesStr2 + "<li> ... </li>";
        }
        modulesStr2 = StringsKt.removeSuffix((String)modulesStr2, (CharSequence)"<br/>");
        return StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.trimIndent((String)("\n        <p>" + KotlinBundle.message("configuration.text.the.compiler.bundled.to.kotlin.plugin", bundledCompilerVersion) + "</p>\n        <ul>" + modulesStr2 + "</ul>\n        <p>" + KotlinBundle.message("configuration.text.this.may.cause.different.set.of.errors.and.warnings.reported.in.ide.p", new Object[0]) + "</p>\n        <p><a href=\"update\">" + KotlinBundle.message("configuration.action.text.update", new Object[0]) + "</a>  <a href=\"ignore\">" + KotlinBundle.message("configuration.action.text.ignore", new Object[0]) + "</a></p>"))), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (String)"<br/>", (String)"\n", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String createOutdatedBundledCompilerMessage$default(Project project2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = KotlinCompilerVersion.VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KotlinCompilerVersion.VERSION");
            string = string2;
        }
        return OutdatedBundledCompilerNotificationKt.createOutdatedBundledCompilerMessage(project2, string);
    }

    private static final ArrayList<ModuleCompilerInfo> selectedModulesForPopup(Project project2, ModuleCompilerInfo maxCompilerInfo, ArrayList<ModuleCompilerInfo> newerModuleCompilerInfos) {
        HashSet<Module> selectedBaseModules = new HashSet<Module>();
        ArrayList<ModuleCompilerInfo> selectedNewerModulesInfos = new ArrayList<ModuleCompilerInfo>();
        ModuleSourceRootMap moduleSourceRootMap = new ModuleSourceRootMap(project2);
        for (ModuleCompilerInfo moduleCompilerInfo : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)maxCompilerInfo), (Iterable)newerModuleCompilerInfos)) {
            KotlinVersion languageMajorVersion = moduleCompilerInfo.getLanguageMajorVersion();
            KotlinVersion externalCompilerMajorVersion = moduleCompilerInfo.getExternalCompilerMajorVersion();
            ModuleSourceRootGroup wholeModuleGroup = moduleSourceRootMap.getWholeModuleGroup(moduleCompilerInfo.getModule());
            if (!selectedBaseModules.contains(wholeModuleGroup.getBaseModule())) {
                selectedNewerModulesInfos.add(new ModuleCompilerInfo(wholeModuleGroup.getBaseModule(), moduleCompilerInfo.getExternalCompilerVersion(), externalCompilerMajorVersion, languageMajorVersion));
                selectedBaseModules.add(wholeModuleGroup.getBaseModule());
            }
            if (selectedNewerModulesInfos.size() <= 2) continue;
            break;
        }
        return selectedNewerModulesInfos;
    }

    private static final KotlinVersion createKotlinVersion(LanguageVersion languageVersion) {
        return new KotlinVersion(languageVersion.getMajor(), languageVersion.getMinor(), 0);
    }

    private static final KotlinVersion createKotlinVersion(String versionStr) {
        if (Intrinsics.areEqual((Object)versionStr, (Object)"@snapshot@")) {
            return new KotlinVersion(255, 255, 0);
        }
        String string = "(\\d+)\\.(\\d+).*";
        boolean bl = false;
        Regex regex = new Regex(string);
        MatchResult matchResult = regex.matchEntire((CharSequence)versionStr);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String string2 = (String)matchResult2.getGroupValues().get(1);
        boolean bl2 = false;
        int major = Integer.parseInt(string2);
        String string3 = (String)matchResult2.getGroupValues().get(2);
        boolean bl3 = false;
        int minor = Integer.parseInt(string3);
        return new KotlinVersion(major, minor, 0);
    }
}

