/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\r\u001a$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f*\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\r*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\r*\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0014"}, d2={"externalProjectId", "", "Lcom/intellij/openapi/module/Module;", "getExternalProjectId", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "externalProjectPath", "getExternalProjectPath", "isSourceRootPrefix", "", "externalId", "previousModuleExternalId", "allModules", "", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "exclude", "", "excludeModules", "", "getWholeModuleGroup", "toModuleGroup", "kotlin.idea"})
public final class ModuleSourceRootMapKt {
    @NotNull
    public static final ModuleSourceRootGroup toModuleGroup(@NotNull Module $this$toModuleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$toModuleGroup, (String)"$this$toModuleGroup");
        Project project2 = $this$toModuleGroup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return new ModuleSourceRootMap(project2).toModuleGroup($this$toModuleGroup);
    }

    @NotNull
    public static final ModuleSourceRootGroup getWholeModuleGroup(@NotNull Module $this$getWholeModuleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$getWholeModuleGroup, (String)"$this$getWholeModuleGroup");
        Project project2 = $this$getWholeModuleGroup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return new ModuleSourceRootMap(project2).getWholeModuleGroup($this$getWholeModuleGroup);
    }

    private static final boolean isSourceRootPrefix(String externalId, String previousModuleExternalId) {
        return externalId.length() < previousModuleExternalId.length() && StringsKt.startsWith$default((String)previousModuleExternalId, (String)externalId, (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String getExternalProjectId(@NotNull Module $this$externalProjectId) {
        Intrinsics.checkNotNullParameter((Object)$this$externalProjectId, (String)"$this$externalProjectId");
        return ExternalSystemApiUtil.getExternalProjectId((Module)$this$externalProjectId);
    }

    @Nullable
    public static final String getExternalProjectPath(@NotNull Module $this$externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$externalProjectPath, (String)"$this$externalProjectPath");
        return ExternalSystemApiUtil.getExternalProjectPath((Module)$this$externalProjectPath);
    }

    @NotNull
    public static final Set<Module> allModules(@NotNull ModuleSourceRootGroup $this$allModules) {
        Intrinsics.checkNotNullParameter((Object)$this$allModules, (String)"$this$allModules");
        LinkedHashSet<Module> result2 = new LinkedHashSet<Module>();
        result2.add($this$allModules.getBaseModule());
        result2.addAll((Collection)$this$allModules.getSourceRootModules());
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleSourceRootGroup> exclude(@NotNull List<ModuleSourceRootGroup> $this$exclude, @NotNull Collection<? extends Module> excludeModules) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$exclude, (String)"$this$exclude");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        Iterable $this$mapNotNull$iv = $this$exclude;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleSourceRootGroup moduleSourceRootGroup;
            List remainingSourceRootModules;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv$iv;
            boolean bl2 = false;
            if ((excludeModules.contains(it.getBaseModule()) ? null : ((remainingSourceRootModules = CollectionsKt.minus((Iterable)it.getSourceRootModules(), (Iterable)excludeModules)).isEmpty() ? null : new ModuleSourceRootGroup(it.getBaseModule(), remainingSourceRootModules))) == null) continue;
            moduleSourceRootGroup = moduleSourceRootGroup;
            boolean bl3 = false;
            boolean bl4 = false;
            ModuleSourceRootGroup it$iv$iv = moduleSourceRootGroup;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ boolean access$isSourceRootPrefix(String externalId, String previousModuleExternalId) {
        return ModuleSourceRootMapKt.isSourceRootPrefix(externalId, previousModuleExternalId);
    }
}

