/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinInlayParameterHintsProvider;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "getBlackListDependencyLanguage", "Lcom/intellij/lang/Language;", "getDefaultBlackList", "", "", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getInlayPresentation", "inlayText", "getMethodInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "elem", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "getSettingsPreview", "kotlin.idea"})
public final class KotlinInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    public Set<String> getDefaultBlackList() {
        return SetsKt.setOf((Object[])new String[]{"*listOf", "*setOf", "*arrayOf", "*ListOf", "*SetOf", "*ArrayOf", "*assert*(*)", "*mapOf", "*MapOf", "kotlin.require*(*)", "kotlin.check*(*)", "*contains*(value)", "*containsKey(key)", "kotlin.lazyOf(value)", "*SequenceBuilder.resume(value)", "*SequenceBuilder.yield(value)"});
    }

    @NotNull
    public String getSettingsPreview() {
        return "fun callsAnotherFun() {\n    anotherFunction(1, 2)            \n}\n\nfun anotherFunction(a: Int = 10, b: Int = 5): Int {\n    val sum = a + b\n    return sum * 2\n} ";
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element3) {
        HintInfo.MethodInfo methodInfo;
        KtValueArgumentList ktValueArgumentList;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!HintType.PARAMETER_HINT.isApplicable(element3)) {
            return null;
        }
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtValueArgumentList)) {
            psiElement2 = null;
        }
        if ((ktValueArgumentList = (KtValueArgumentList)psiElement2) == null || (ktValueArgumentList = ktValueArgumentList.getParent()) == null) {
            return null;
        }
        KtValueArgumentList parent2 = ktValueArgumentList;
        KtValueArgumentList ktValueArgumentList2 = parent2;
        if (!(ktValueArgumentList2 instanceof KtCallElement)) {
            ktValueArgumentList2 = null;
        }
        KtCallElement ktCallElement = (KtCallElement)ktValueArgumentList2;
        if (ktCallElement != null) {
            KtCallElement ktCallElement2 = ktCallElement;
            boolean bl = false;
            boolean bl2 = false;
            KtCallElement it = ktCallElement2;
            boolean bl3 = false;
            methodInfo = this.getMethodInfo(it);
        } else {
            methodInfo = null;
        }
        return (HintInfo)methodInfo;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return HintType.PARAMETER_HINT.isApplicable(element3) ? HintType.PARAMETER_HINT.provideHints(element3) : CollectionsKt.emptyList();
    }

    @NotNull
    public Language getBlackListDependencyLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaLanguage, (String)"JavaLanguage.INSTANCE");
        return (Language)javaLanguage;
    }

    @NotNull
    public String getInlayPresentation(@NotNull String inlayText) {
        Intrinsics.checkNotNullParameter((Object)inlayText, (String)"inlayText");
        return inlayText;
    }

    private final HintInfo.MethodInfo getMethodInfo(KtCallElement elem) {
        CallableDescriptor resolvedCallee;
        ResolvedCall resolvedCall2;
        ResolvedCall resolvedCall3 = resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)elem), null, (int)1, null);
        Object object = resolvedCallee = resolvedCall3 != null ? resolvedCall3.getCandidateDescriptor() : null;
        if (resolvedCallee instanceof FunctionDescriptor) {
            Object object2;
            List list = ((FunctionDescriptor)resolvedCallee).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolvedCallee.valueParameters");
            List paramNames2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getMethodInfo.paramNames.1.INSTANCE), (Function1)getMethodInfo.paramNames.2.INSTANCE), (Function1)getMethodInfo.paramNames.3.INSTANCE));
            if (resolvedCallee instanceof ConstructorDescriptor) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)resolvedCallee).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"resolvedCallee.containingDeclaration");
                object2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptorWithTypeParameters)).asString();
            } else {
                object2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCallee));
                if (object2 == null || (object2 = object2.asString()) == null) {
                    return null;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"if (resolvedCallee is Co\u2026sString() ?: return null)");
            Object fqName = object2;
            return new HintInfo.MethodInfo((String)fqName, paramNames2);
        }
        return null;
    }
}

