/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.internal.DumbModeTrembleAction;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "kotlin.idea"})
public final class DumbModeTrembleAction
extends DumbAwareAction {
    private static final String SETTING_REGISTRY_KEY = "action.dumb.tremble";
    private static final String DEFAULT_SETTINGS_STRING = "800_2000_200_400";
    private static final Companion.Settings DEFAULT_SETTINGS;
    private static final Logger LOG;
    private static final Key<Boolean> DUMB_TREMBLE;
    @NotNull
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        if (DumbModeTrembleAction.Companion.isTrembleDumb(project3)) {
            DumbModeTrembleAction.Companion.setTrembleDumb(project3, false);
        } else {
            DumbModeTrembleAction.Companion.setTrembleDumb(project3, true);
            DumbModeTrembleAction.Companion.dumbModeTremble(project3);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(false);
            return;
        }
        boolean isTrembleDumb = DumbModeTrembleAction.Companion.isTrembleDumb(project2);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setText(isTrembleDumb ? KotlinBundle.message("disable.tremble.dumb.mode", new Object[0]) : KotlinBundle.message("enable.tremble.dumb.mode", new Object[0]));
    }

    static {
        Companion = new Companion(null);
        DEFAULT_SETTINGS = DumbModeTrembleAction.Companion.parseSettings(DEFAULT_SETTINGS_STRING);
        Logger logger = Logger.getInstance(DumbModeTrembleAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DumbM\u2026rembleAction::class.java)");
        LOG = logger;
        Key key = Key.create((String)"DumbModeTrembleAction");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"DumbModeTrembleAction\")");
        DUMB_TREMBLE = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion;", "", "()V", "DEFAULT_SETTINGS", "Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion$Settings;", "DEFAULT_SETTINGS_STRING", "", "DUMB_TREMBLE", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SETTING_REGISTRY_KEY", "dumbModeTremble", "", "project", "Lcom/intellij/openapi/project/Project;", "isTrembleDumb", "parseSettings", "settingsString", "readSettings", "setTrembleDumb", "value", "Settings", "kotlin.idea"})
    public static final class Companion {
        private final void dumbModeTremble(Project project2) {
            Settings settings = this.readSettings();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project2, settings){
                final /* synthetic */ Project $project;
                final /* synthetic */ Settings $settings;

                public final void run() {
                    DumbModeTrembleAction.access$getLOG$cp().info("Dumb Mode Tremble enabled");
                    while (org.jetbrains.kotlin.idea.actions.internal.DumbModeTrembleAction$Companion.access$isTrembleDumb(DumbModeTrembleAction.Companion, this.$project)) {
                        TimeoutUtil.sleep((long)Random.Default.nextLong(this.$settings.getDisableMinMillis(), this.$settings.getDisableMaxMillis()));
                        DumbService.getInstance((Project)this.$project).queueTask(new DumbModeTask(this){
                            final /* synthetic */ dumbModeTremble.1 this$0;

                            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                                TimeoutUtil.sleep((long)Random.Default.nextLong(this.this$0.$settings.getEnableMinMillis(), this.this$0.$settings.getEnableMaxMillis()));
                                indicator.checkCanceled();
                            }
                            {
                                this.this$0 = this$0;
                            }
                        });
                    }
                    DumbModeTrembleAction.access$getLOG$cp().info("Dumb Mode Tremble disabled");
                }
                {
                    this.$project = project2;
                    this.$settings = settings;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final Settings parseSettings(String settingsString) {
            Iterable $this$map$iv;
            List numberStrings = StringsKt.split$default((CharSequence)settingsString, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null);
            if (numberStrings.size() != 4) {
                LOG.error("Bad action.dumb.tremble value: `" + numberStrings + '`');
                return DEFAULT_SETTINGS;
            }
            try {
                void $this$mapTo$iv$iv;
                $this$map$iv = numberStrings;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void var13_18 = it;
                    boolean bl2 = false;
                    Long l = Long.parseLong((String)var13_18);
                    collection.add(l);
                }
                $this$map$iv = (List)destination$iv$iv;
            }
            catch (NumberFormatException _) {
                LOG.error("Can't parse longs in action.dumb.tremble value: `" + numberStrings + '`');
                return DEFAULT_SETTINGS;
            }
            Iterable numbers = $this$map$iv;
            long disableMinMillis = ((Number)numbers.get(0)).longValue();
            long disableMaxMillis = ((Number)numbers.get(1)).longValue();
            long enableMinMillis = ((Number)numbers.get(2)).longValue();
            long enableMaxMillis = ((Number)numbers.get(3)).longValue();
            long l = disableMinMillis;
            if (0L <= l && disableMaxMillis > l && 0L <= (l = enableMinMillis) && enableMaxMillis > l) {
                return new Settings(disableMinMillis, disableMaxMillis, enableMinMillis, enableMaxMillis);
            }
            return DEFAULT_SETTINGS;
        }

        private final Settings readSettings() {
            String string;
            try {
                string = Registry.stringValue((String)DumbModeTrembleAction.SETTING_REGISTRY_KEY);
            }
            catch (MissingResourceException _) {
                return DEFAULT_SETTINGS;
            }
            String string2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"try {\n                Re\u2026LT_SETTINGS\n            }");
            String settingsString = string2;
            return this.parseSettings(settingsString);
        }

        private final void setTrembleDumb(Project project2, boolean value) {
            project2.putUserData(DUMB_TREMBLE, (Object)value);
        }

        private final boolean isTrembleDumb(Project project2) {
            return (Boolean)project2.getUserData(DUMB_TREMBLE) == Boolean.TRUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion$Settings;", "", "disableMinMillis", "", "disableMaxMillis", "enableMinMillis", "enableMaxMillis", "(JJJJ)V", "getDisableMaxMillis", "()J", "getDisableMinMillis", "getEnableMaxMillis", "getEnableMinMillis", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        private static final class Settings {
            private final long disableMinMillis;
            private final long disableMaxMillis;
            private final long enableMinMillis;
            private final long enableMaxMillis;

            public final long getDisableMinMillis() {
                return this.disableMinMillis;
            }

            public final long getDisableMaxMillis() {
                return this.disableMaxMillis;
            }

            public final long getEnableMinMillis() {
                return this.enableMinMillis;
            }

            public final long getEnableMaxMillis() {
                return this.enableMaxMillis;
            }

            public Settings(long disableMinMillis, long disableMaxMillis, long enableMinMillis, long enableMaxMillis) {
                this.disableMinMillis = disableMinMillis;
                this.disableMaxMillis = disableMaxMillis;
                this.enableMinMillis = enableMinMillis;
                this.enableMaxMillis = enableMaxMillis;
            }

            public final long component1() {
                return this.disableMinMillis;
            }

            public final long component2() {
                return this.disableMaxMillis;
            }

            public final long component3() {
                return this.enableMinMillis;
            }

            public final long component4() {
                return this.enableMaxMillis;
            }

            @NotNull
            public final Settings copy(long disableMinMillis, long disableMaxMillis, long enableMinMillis, long enableMaxMillis) {
                return new Settings(disableMinMillis, disableMaxMillis, enableMinMillis, enableMaxMillis);
            }

            public static /* synthetic */ Settings copy$default(Settings settings, long l, long l2, long l3, long l4, int n, Object object) {
                if ((n & 1) != 0) {
                    l = settings.disableMinMillis;
                }
                if ((n & 2) != 0) {
                    l2 = settings.disableMaxMillis;
                }
                if ((n & 4) != 0) {
                    l3 = settings.enableMinMillis;
                }
                if ((n & 8) != 0) {
                    l4 = settings.enableMaxMillis;
                }
                return settings.copy(l, l2, l3, l4);
            }

            @NotNull
            public String toString() {
                return "Settings(disableMinMillis=" + this.disableMinMillis + ", disableMaxMillis=" + this.disableMaxMillis + ", enableMinMillis=" + this.enableMinMillis + ", enableMaxMillis=" + this.enableMaxMillis + ")";
            }

            public int hashCode() {
                return ((Long.hashCode(this.disableMinMillis) * 31 + Long.hashCode(this.disableMaxMillis)) * 31 + Long.hashCode(this.enableMinMillis)) * 31 + Long.hashCode(this.enableMaxMillis);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Settings)) break block3;
                        Settings settings = (Settings)object;
                        if (this.disableMinMillis != settings.disableMinMillis || this.disableMaxMillis != settings.disableMaxMillis || this.enableMinMillis != settings.enableMinMillis || this.enableMaxMillis != settings.enableMaxMillis) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

