/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinActionKt;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverterServices;
import org.jetbrains.kotlin.j2k.OldJavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u001a\u001a\u00020\u0014*\u00020\tH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allJavaFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "isAnyJavaFileSelected", "", "files", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isEnabled", "selectedJavaFiles", "update", "isSuitableDirectory", "Companion", "kotlin.idea"})
public final class JavaToKotlinAction
extends AnAction {
    @NotNull
    private static final String title;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List javaFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter(this.selectedJavaFiles(e), (Function1)actionPerformed.javaFiles.1.INSTANCE));
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"CommonDataKeys.PROJECT.g\u2026(e.dataContext) ?: return");
        Project project3 = project2;
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"e.getData(LangDataKeys.MODULE) ?: return");
        Module module2 = module;
        if (javaFiles2.isEmpty()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project3);
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinBundle.message("action.j2k.errornothing.to.convert", new Object[0]), MessageType.ERROR, null).createBalloon();
            StatusBar statusBar2 = statusBar;
            Intrinsics.checkNotNullExpressionValue((Object)statusBar2, (String)"statusBar");
            balloon.showInCenterOf(statusBar2.getComponent());
        }
        if (!J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).doCheckBeforeConversion(project3, module2)) {
            return;
        }
        PsiErrorElement firstSyntaxError2 = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles2), (Function1)actionPerformed.firstSyntaxError.1.INSTANCE));
        if (firstSyntaxError2 != null) {
            String string;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv22 = javaFiles2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv22;
            Collection destination$iv$iv222 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it))) continue;
                destination$iv$iv222.add(element$iv$iv);
            }
            $this$filter$iv22 = (List)destination$iv$iv222;
            $i$f$filter = false;
            int count = $this$filter$iv22.size();
            boolean $this$filter$iv22 = count > 0;
            $i$f$filter = false;
            boolean $this$filterTo$iv$iv2 = false;
            if (_Assertions.ENABLED && !$this$filter$iv22) {
                boolean destination$iv$iv222 = false;
                String destination$iv$iv222 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)destination$iv$iv222));
            }
            PsiFile psiFile = firstSyntaxError2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"firstSyntaxError.containingFile");
            String string2 = psiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"firstSyntaxError.containingFile.name");
            String firstFileName = string2;
            switch (count) {
                case 1: {
                    string = KotlinBundle.message("action.j2k.correction.errors.single", firstFileName);
                    break;
                }
                default: {
                    string = KotlinBundle.message("action.j2k.correction.errors.multiple", firstFileName, count - 1);
                }
            }
            String question = string;
            String okText = KotlinBundle.message("action.j2k.correction.investigate", new Object[0]);
            String cancelText = KotlinBundle.message("action.j2k.correction.proceed", new Object[0]);
            if (Messages.showOkCancelDialog((Project)project3, (String)question, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)firstSyntaxError2.getNavigationElement());
                return;
            }
        }
        org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.convertFiles$default(Companion, javaFiles2, project3, module2, false, false, false, 56, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        if (CidrUtil.isRunningInCidrIde()) {
            return false;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"e.getData(CommonDataKeys\u2026LE_ARRAY) ?: return false");
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return false");
        Project project3 = project2;
        if ((Module)e.getData(LangDataKeys.MODULE) == null) {
            return false;
        }
        return this.isAnyJavaFileSelected(project3, virtualFiles);
    }

    private final boolean isAnyJavaFileSelected(Project project2, VirtualFile[] files) {
        boolean bl;
        block4: {
            boolean bl2;
            int n;
            block3: {
                VirtualFile[] $this$any$iv = files;
                boolean $i$f$any = false;
                VirtualFile[] virtualFileArray = $this$any$iv;
                int n2 = virtualFileArray.length;
                for (n = 0; n < n2; ++n) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = virtualFileArray[n];
                    boolean bl3 = false;
                    if (!this.isSuitableDirectory(it)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager manager = psiManager;
            VirtualFile[] $this$any$iv = files;
            boolean $i$f$any = false;
            VirtualFile[] virtualFileArray = $this$any$iv;
            n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray[i];
                boolean bl4 = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"java") && manager.findFile(it) instanceof PsiJavaFile && it.isWritable())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSuitableDirectory(VirtualFile $this$isSuitableDirectory) {
        return $this$isSuitableDirectory.isDirectory() && !($this$isSuitableDirectory.getFileType() instanceof ArchiveFileType) && $this$isSuitableDirectory.isWritable();
    }

    private final Sequence<PsiJavaFile> selectedJavaFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"e.getData(CommonDataKeys\u2026Y) ?: return sequenceOf()");
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project2 = e.getProject();
        if (project2 == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return sequenceOf()");
        Project project3 = project2;
        return this.allJavaFiles(virtualFiles, project3);
    }

    private final Sequence<PsiJavaFile> allJavaFiles(VirtualFile[] filesOrDirs, Project project2) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager manager = psiManager;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof PsiJavaFile)) {
                    psiFile = null;
                }
                return (PsiJavaFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (VirtualFile file2 : filesOrDirs) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        title = KotlinBundle.message("action.j2k.name", new Object[0]);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Companion;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "javaFiles", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "forceUsingOldJ2k", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertedTexts", "uniqueKotlinFileName", "javaFile", "kotlin.idea"})
    public static final class Companion {
        private final String uniqueKotlinFileName(VirtualFile javaFile) {
            Path nioFile = javaFile.getFileSystem().getNioPath(javaFile);
            int i = 0;
            while (true) {
                block4: {
                    String fileName;
                    block3: {
                        Path path;
                        fileName = javaFile.getNameWithoutExtension() + (i > 0 ? Integer.valueOf(i) : "") + ".kt";
                        if (nioFile == null) break block3;
                        Intrinsics.checkNotNullExpressionValue((Object)nioFile.resolveSibling(fileName), (String)"nioFile.resolveSibling(fileName)");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        boolean bl = false;
                        if (!Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
                    }
                    return fileName;
                }
                ++i;
            }
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles2, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)javaFiles2, (Iterable)convertedTexts)) {
                void psiFile;
                PsiJavaFile psiJavaFile = (PsiJavaFile)pair.component1();
                String text2 = (String)pair.component2();
                try {
                    String errorMessage;
                    String string;
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument((PsiFile)psiFile);
                    if (document == null) {
                        Object[] objectArray = new Object[1];
                        String string2 = psiFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
                        objectArray[0] = string2;
                        string = KotlinBundle.message("action.j2k.error.cant.find.document", objectArray);
                    } else if (!document.isWritable()) {
                        Object[] objectArray = new Object[1];
                        String string3 = psiFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"psiFile.name");
                        objectArray[0] = string3;
                        string = KotlinBundle.message("action.j2k.error.read.only", objectArray);
                    } else {
                        string = errorMessage = null;
                    }
                    if (errorMessage != null) {
                        String message2 = KotlinBundle.message("action.j2k.error.cant.save.result", errorMessage);
                        MessagesEx.error((Project)psiFile.getProject(), (String)message2).showLater();
                        continue;
                    }
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)document2);
                    document2.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile)) {
                        PerFileMappings mapping;
                        ScratchFileService scratchFileService = ScratchFileService.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)scratchFileService, (String)"ScratchFileService.getInstance()");
                        Intrinsics.checkNotNullExpressionValue((Object)scratchFileService.getScratchesMapping(), (String)"ScratchFileService.getInstance().scratchesMapping");
                        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
                        mapping.setMapping(virtualFile, (Object)kotlinFileType.getLanguage());
                    } else {
                        VirtualFile virtualFile2 = virtualFile;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
                        String fileName = this.uniqueKotlinFileName(virtualFile2);
                        JavaToKotlinActionKt.setPathBeforeJ2K(virtualFile, virtualFile.getPath());
                        virtualFile.rename((Object)this, fileName);
                    }
                    Collection collection = result2;
                    boolean bl = false;
                    collection.add(virtualFile);
                }
                catch (IOException e) {
                    Project project2 = psiFile.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project2, (String)string).showLater();
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> javaFiles2, @NotNull Project project2, @NotNull Module module, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k) {
            void externalCodeUpdate;
            void converterResult;
            Intrinsics.checkNotNullParameter(javaFiles2, (String)"javaFiles");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0<Unit> $fun$convert$1 = new Function0<Unit>(forceUsingOldJ2k, project2, module, (Ref.ObjectRef)converterResult, javaFiles2){
                final /* synthetic */ boolean $forceUsingOldJ2k;
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;
                final /* synthetic */ Ref.ObjectRef $converterResult;
                final /* synthetic */ List $javaFiles;

                public final void invoke() {
                    JavaToKotlinConverter converter = this.$forceUsingOldJ2k ? (JavaToKotlinConverter)new OldJavaToKotlinConverter(this.$project, ConverterSettings.Companion.getDefaultSettings(), (JavaToKotlinConverterServices)IdeaJavaToKotlinServices.INSTANCE) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createJavaToKotlinConverter(this.$project, this.$module, ConverterSettings.Companion.getDefaultSettings(), (JavaToKotlinConverterServices)IdeaJavaToKotlinServices.INSTANCE);
                    PostProcessor postProcessor = this.$forceUsingOldJ2k ? (PostProcessor)new J2kPostProcessor(true) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createPostProcessor(true);
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    Intrinsics.checkNotNull((Object)progressIndicator);
                    this.$converterResult.element = converter.filesToKotlin(this.$javaFiles, postProcessor, progressIndicator);
                }
                {
                    this.$forceUsingOldJ2k = bl;
                    this.$project = project2;
                    this.$module = module;
                    this.$converterResult = objectRef;
                    this.$javaFiles = list;
                    super(0);
                }
            };
            Function0<Unit> $fun$convertWithStatistics$2 = new Function0<Unit>($fun$convert$1, javaFiles2){
                final /* synthetic */ convertFiles.1 $convert$1;
                final /* synthetic */ List $javaFiles;

                public final void invoke() {
                    boolean $i$f$measureTimeMillis = false;
                    boolean bl = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl2 = false;
                    this.$convert$1.invoke();
                    long conversionTime = System.currentTimeMillis() - start$iv;
                    int linesCount2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Integer>(this){
                        final /* synthetic */ convertFiles.2 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke() {
                            void var3_3;
                            Iterable $this$sumBy$iv = this.this$0.$javaFiles;
                            boolean $i$f$sumBy = false;
                            int sum$iv = 0;
                            for (T element$iv : $this$sumBy$iv) {
                                void it;
                                PsiJavaFile psiJavaFile = (PsiJavaFile)element$iv;
                                int n = sum$iv;
                                boolean bl = false;
                                int n2 = StringUtil.getLineBreakCount((CharSequence)it.getText());
                                sum$iv = n + n2;
                            }
                            return (int)var3_3;
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }))).intValue();
                    J2KFusCollector.Companion.log(ConversionType.FILES, ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled(), conversionTime, linesCount2, this.$javaFiles.size());
                }
                {
                    this.$convert$1 = var1_1;
                    this.$javaFiles = list;
                    super(0);
                }
            };
            Function0 function0 = (Function0)new Function0<Unit>($fun$convertWithStatistics$2){
                final /* synthetic */ convertFiles.2 $convertWithStatistics$2;

                public final void invoke() {
                    this.$convertWithStatistics$2.invoke();
                }
                {
                    this.$convertWithStatistics$2 = var1_1;
                    super(0, null, "convertWithStatistics", "invoke()V", 0);
                }
            };
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            }, this.getTitle(), true, project2)) {
                return CollectionsKt.emptyList();
            }
            function0 = new Ref.ObjectRef();
            function0.element = null;
            FilesResult filesResult = (FilesResult)converterResult.element;
            if (filesResult == null) {
                return CollectionsKt.emptyList();
            }
            FilesResult result2 = filesResult;
            ExternalCodeProcessing externalCodeProcessing = result2.getExternalCodeProcessing();
            if (enableExternalCodeProcessing && externalCodeProcessing != null) {
                String question = KotlinBundle.message("action.j2k.correction.required", new Object[0]);
                if (!askExternalCodeProcessing || Messages.showYesNoDialog((Project)project2, (String)question, (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Ref.ObjectRef)externalCodeUpdate, externalCodeProcessing){
                        final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;
                        final /* synthetic */ ExternalCodeProcessing $externalCodeProcessing;

                        public final void run() {
                            ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ convertFiles.4 this$0;

                                public final void invoke() {
                                    Ref.ObjectRef objectRef = this.this$0.$externalCodeUpdate;
                                    ExternalCodeProcessing externalCodeProcessing = this.this$0.$externalCodeProcessing;
                                    ProgressManager progressManager = ProgressManager.getInstance();
                                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                                    Intrinsics.checkNotNull((Object)progressIndicator);
                                    objectRef.element = externalCodeProcessing.prepareWriteOperation(progressIndicator);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                        {
                            this.$externalCodeUpdate = objectRef;
                            this.$externalCodeProcessing = externalCodeProcessing;
                        }
                    }, this.getTitle(), true, project2);
                }
            }
            return (List)ApplicationUtilsKt.executeWriteCommand((Project)project2, (String)KotlinBundle.message("action.j2k.task.name", new Object[0]), null, (Function0)((Function0)new Function0<List<? extends KtFile>>(project2, javaFiles2, result2, (Ref.ObjectRef)externalCodeUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $javaFiles;
                final /* synthetic */ FilesResult $result;
                final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<KtFile> invoke() {
                    void var1_19;
                    block4: {
                        void $this$mapTo$iv$iv;
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                        Iterable $this$map$iv = org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.access$saveResults(JavaToKotlinAction.Companion, this.$javaFiles, this.$result.getResults());
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv22 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                            Collection collection = destination$iv$iv22;
                            boolean bl = false;
                            PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, (Project)this.$project);
                            if (psiFile == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                            }
                            KtFile ktFile = (KtFile)psiFile;
                            collection.add(ktFile);
                        }
                        Iterable $this$onEach$iv = (List)destination$iv$iv22;
                        boolean $i$f$onEach = false;
                        iterable = $this$onEach$iv;
                        boolean destination$iv$iv22 = false;
                        $i$f$mapTo = false;
                        Iterable $this$apply$iv = iterable;
                        boolean bl = false;
                        for (E element$iv : $this$apply$iv) {
                            KtFile it = (KtFile)element$iv;
                            boolean bl2 = false;
                            UtilsKt.commitAndUnblockDocument((PsiFile)it);
                        }
                        List newFiles = (List)iterable;
                        Function1 function1 = (Function1)this.$externalCodeUpdate.element;
                        if (function1 != null) {
                            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)newFiles);
                        }
                        PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                        KtFile ktFile = (KtFile)CollectionsKt.singleOrNull((List)newFiles);
                        if (ktFile == null) break block4;
                        KtFile ktFile2 = ktFile;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        KtFile it = ktFile2;
                        boolean bl5 = false;
                        FileEditorManager.getInstance((Project)this.$project).openFile(it.getVirtualFile(), true);
                    }
                    return var1_19;
                }
                {
                    this.$project = project2;
                    this.$javaFiles = list;
                    this.$result = filesResult;
                    this.$externalCodeUpdate = objectRef;
                    super(0);
                }
            }));
        }

        public static /* synthetic */ List convertFiles$default(Companion companion, List list, Project project2, Module module, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return companion.convertFiles(list, project2, module, bl, bl2, bl3);
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$saveResults(Companion $this, List javaFiles2, List convertedTexts) {
            return $this.saveResults(javaFiles2, convertedTexts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

