/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PlatformVersion;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightSettings;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/IDESettingsFUSCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.idea"})
public final class IDESettingsFUSCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final BooleanEventField scriptingAREnabledField;
    private static final StringEventField scriptingDefNameField;
    private static final PrimitiveEventField<PluginInfo> scriptingPluginInfoField;
    private static final EventId3<String, Boolean, PluginInfo> scriptingAREvent;
    private static final EventId2<Boolean, PluginInfo> unambiguousImportsEvent;
    private static final EventId2<Boolean, PluginInfo> optimizeImportsEvent;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (PlatformVersion.Companion.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set metrics = new LinkedHashSet();
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinPluginUtil.INSTANCE.getKOTLIN_PLUGIN_ID());
        for (ScriptDefinition definition : ScriptDefinitionsManager.Companion.getInstance(project2).getAllDefinitions()) {
            if (!definition.getCanAutoReloadScriptConfigurationsBeSwitchedOff()) continue;
            boolean scriptingAutoReloadEnabled = KotlinScriptingSettings.Companion.getInstance(project2).autoReloadConfigurations(definition);
            metrics.add(scriptingAREvent.metric((Object)definition.getName(), (Object)scriptingAutoReloadEnabled, (Object)pluginInfo));
        }
        KotlinCodeInsightSettings settings = KotlinCodeInsightSettings.Companion.getInstance();
        KotlinCodeInsightWorkspaceSettings projectSettings = KotlinCodeInsightWorkspaceSettings.Companion.getInstance(project2);
        metrics.add(unambiguousImportsEvent.metric((Object)settings.addUnambiguousImportsOnTheFly, (Object)pluginInfo));
        metrics.add(optimizeImportsEvent.metric((Object)projectSettings.optimizeImportsOnTheFly, (Object)pluginInfo));
        return metrics;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("kotlin.ide.settings", 4);
        scriptingAREnabledField = EventFields.Boolean((String)"enabled");
        scriptingDefNameField = EventFields.String((String)"definition_name", (List)CollectionsKt.listOf((Object[])new String[]{"KotlinInitScript", "KotlinSettingsScript", "KotlinBuildScript", "Script_definition_for_extension_scripts_and_IDE_console", "MainKtsScript", "Kotlin_Script", "Space_Automation"}));
        scriptingPluginInfoField = EventFields.PluginInfo;
        scriptingAREvent = GROUP.registerEvent("scriptingAutoReloadEnabled", (EventField)scriptingDefNameField, (EventField)scriptingAREnabledField, (EventField)scriptingPluginInfoField);
        unambiguousImportsEvent = GROUP.registerEvent("addUnambiguousImportsOnTheFly", (EventField)EventFields.Boolean((String)"enabled"), (EventField)EventFields.PluginInfo);
        optimizeImportsEvent = GROUP.registerEvent("optimizeImportsOnTheFly", (EventField)EventFields.Boolean((String)"enabled"), (EventField)EventFields.PluginInfo);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/IDESettingsFUSCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "optimizeImportsEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "scriptingAREnabledField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "scriptingAREvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "scriptingDefNameField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "scriptingPluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "unambiguousImportsEvent", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

