/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.recommenders.java.models;

import com.jetbrains.recommenders.java.commons.Recommendation;
import com.jetbrains.recommenders.java.commons.names.IFieldName;
import com.jetbrains.recommenders.java.commons.names.IMemberName;
import com.jetbrains.recommenders.java.commons.names.IName;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.commons.names.VmFieldName;
import com.jetbrains.recommenders.java.commons.names.VmMethodName;
import com.jetbrains.recommenders.java.commons.names.VmTypeName;
import com.jetbrains.recommenders.java.models.IStaticsModel;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeBuilder;
import org.eclipse.recommenders.jayes.io.jbif.JayesBifReader;
import org.eclipse.recommenders.jayes.util.triangulation.IEliminationHeuristic;
import org.eclipse.recommenders.jayes.util.triangulation.MinDegree;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00120\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/recommenders/java/models/StaticsModel;", "Lcom/jetbrains/recommenders/java/models/IStaticsModel;", "receiverType", "Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "net", "Lorg/eclipse/recommenders/jayes/BayesNet;", "(Lcom/jetbrains/recommenders/java/commons/names/ITypeName;Lorg/eclipse/recommenders/jayes/BayesNet;)V", "junctionTree", "Lorg/eclipse/recommenders/jayes/inference/jtree/JunctionTreeAlgorithm;", "members", "", "Lcom/jetbrains/recommenders/java/commons/names/IMemberName;", "Lorg/eclipse/recommenders/jayes/BayesNode;", "root", "getMembers", "", "getReceiverType", "recommend", "Lcom/jetbrains/recommenders/java/commons/Recommendation;", "toName", "declaringType", "node", "Companion", "recommenders-java-jayes"})
public final class StaticsModel
implements IStaticsModel {
    private final BayesNode root;
    private final Map<IMemberName, BayesNode> members;
    private final JunctionTreeAlgorithm junctionTree;
    private final ITypeName receiverType;
    @NotNull
    public static final String TRUE = "true";
    @NotNull
    public static final String FALSE = "false";
    @NotNull
    public static final String ROOT = "root";
    @NotNull
    public static final String PREFIX_METHOD = "m:";
    @NotNull
    public static final String PREFIX_FIELD = "f:";
    @NotNull
    public static final String FILE_SUFFIX = "jbif";
    @JvmField
    @NotNull
    public static final IStaticsModel NULL;
    public static final Companion Companion;

    private final IMemberName toName(ITypeName declaringType, BayesNode node) {
        IMemberName iMemberName;
        String string = node.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.name");
        if (StringsKt.startsWith$default((String)string, (String)PREFIX_METHOD, (boolean)false, (int)2, null)) {
            String string2 = declaringType.getIdentifier();
            String string3 = node.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.name");
            String string4 = string3;
            int n = 2;
            String string5 = string2;
            VmMethodName.Companion companion = VmMethodName.Companion;
            boolean bl = false;
            String string6 = string4;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            String string8 = string7;
            iMemberName = (IMemberName)companion.of(string5, string8);
        } else {
            String string9 = node.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"node.name");
            if (StringsKt.startsWith$default((String)string9, (String)PREFIX_FIELD, (boolean)false, (int)2, null)) {
                String string10 = node.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"node.name");
                String string11 = string10;
                int n = 2;
                VmFieldName.Companion companion = VmFieldName.Companion;
                boolean bl = false;
                String string12 = string11;
                if (string12 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
                String string14 = string13;
                iMemberName = (IMemberName)companion.of(string14);
            } else {
                throw (Throwable)new IllegalArgumentException("Unexpected node declaringType: " + node + ".name");
            }
        }
        return iMemberName;
    }

    @Override
    @NotNull
    public ITypeName getReceiverType() {
        return this.receiverType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Recommendation<IMemberName>> recommend() {
        void $this$mapTo$iv$iv;
        Map<IMemberName, BayesNode> $this$map$iv = this.members;
        boolean $i$f$map = false;
        Map<IMemberName, BayesNode> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Recommendation recommendation = Recommendation.Companion.of(it.getKey(), this.junctionTree.getBeliefs((BayesNode)it.getValue())[0]);
            collection.add(recommendation);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public List<IMemberName> getMembers() {
        return CollectionsKt.toList((Iterable)this.members.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public StaticsModel(@NotNull ITypeName receiverType, @NotNull BayesNet net) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BayesNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv2;
        Iterable $this$first$iv;
        StaticsModel staticsModel;
        Iterable iterable;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)receiverType, (String)"receiverType");
            Intrinsics.checkParameterIsNotNull((Object)net, (String)"net");
            this.receiverType = receiverType;
            List list = net.getNodes();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"net.nodes");
            iterable = list;
            staticsModel = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                BayesNode it2 = (BayesNode)element$iv2;
                boolean bl = false;
                BayesNode bayesNode = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bayesNode, (String)"it");
                if (!StaticsModel.Companion.isRootNode(bayesNode)) continue;
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object object = element$iv2;
        Object t = object;
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"net.nodes.first { isRootNode(it) }");
        staticsModel.root = (BayesNode)t;
        List list = net.getNodes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"net.nodes");
        $this$first$iv = list;
        staticsModel = this;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BayesNode)element$iv$iv;
            boolean bl = false;
            BayesNode bayesNode = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bayesNode, (String)"it");
            if (!(!StaticsModel.Companion.isRootNode(bayesNode))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BayesNode)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            BayesNode bayesNode = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bayesNode, (String)"it");
            Pair pair = TuplesKt.to((Object)this.toName(this.receiverType, bayesNode), (Object)it);
            object.add((Pair)pair);
        }
        object = (List)destination$iv$iv;
        staticsModel.members = MapsKt.toMap((Iterable)((Iterable)object));
        iterable = new JunctionTreeAlgorithm();
        staticsModel = this;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply = iterable;
        boolean bl3 = false;
        $this$apply.setJunctionTreeBuilder(JunctionTreeBuilder.forHeuristic((IEliminationHeuristic)((IEliminationHeuristic)new MinDegree())));
        $this$apply.setNetwork(net);
        $this$apply.setEvidence(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.root, (Object)TRUE)));
        object = iterable;
        staticsModel.junctionTree = object;
    }

    static {
        Companion = new Companion(null);
        NULL = new IStaticsModel(){

            @NotNull
            public ITypeName getReceiverType() {
                return IStaticsModel.DefaultImpls.getReceiverType(this);
            }

            @NotNull
            public List<IMemberName> getMembers() {
                return IStaticsModel.DefaultImpls.getMembers(this);
            }

            @NotNull
            public List<Recommendation<IMemberName>> recommend() {
                return IStaticsModel.DefaultImpls.recommend(this);
            }

            public void reset() {
                IStaticsModel.DefaultImpls.reset(this);
            }
        };
    }

    @Override
    public void reset() {
        IStaticsModel.DefaultImpls.reset(this);
    }

    @JvmStatic
    @NotNull
    public static final IStaticsModel load(@NotNull Path location, @NotNull ITypeName name) {
        return Companion.load(location, name);
    }

    @JvmStatic
    @NotNull
    public static final IStaticsModel load(@NotNull InputStream stream, @NotNull ITypeName name) {
        return Companion.load(stream, name);
    }

    @JvmStatic
    @NotNull
    public static final IStaticsModel of(@NotNull ITypeName name, @NotNull BayesNet net) {
        return Companion.of(name, net);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/recommenders/java/models/StaticsModel$Companion;", "", "()V", "FALSE", "", "FILE_SUFFIX", "NULL", "Lcom/jetbrains/recommenders/java/models/IStaticsModel;", "PREFIX_FIELD", "PREFIX_METHOD", "ROOT", "TRUE", "isRootNode", "", "it", "Lorg/eclipse/recommenders/jayes/BayesNode;", "load", "stream", "Ljava/io/InputStream;", "name", "Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "location", "Ljava/nio/file/Path;", "normalizeNodeKey", "Lcom/jetbrains/recommenders/java/commons/names/IName;", "of", "net", "Lorg/eclipse/recommenders/jayes/BayesNet;", "recommenders-java-jayes"})
    public static final class Companion {
        private final boolean isRootNode(BayesNode it) {
            return Intrinsics.areEqual((Object)StaticsModel.ROOT, (Object)it.getName());
        }

        @JvmStatic
        @NotNull
        public final IStaticsModel load(@NotNull Path location, @NotNull ITypeName name) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            InputStream inputStream = Files.newInputStream(location, new OpenOption[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(location)");
            return this.load(inputStream, name);
        }

        @JvmStatic
        @NotNull
        public final IStaticsModel load(@NotNull InputStream stream, @NotNull ITypeName name) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            BayesNet bayesNet = new JayesBifReader(stream).read();
            Intrinsics.checkExpressionValueIsNotNull((Object)bayesNet, (String)"JayesBifReader(stream).read()");
            return new StaticsModel(name, bayesNet);
        }

        @JvmStatic
        @NotNull
        public final IStaticsModel of(@NotNull ITypeName name, @NotNull BayesNet net) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)net, (String)"net");
            return new StaticsModel(name, net);
        }

        @NotNull
        public final IName normalizeNodeKey(@NotNull IName name) {
            IName iName;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (name instanceof IFieldName) {
                VmFieldName f = (VmFieldName)name;
                iName = (IName)VmFieldName.Companion.of((ITypeName)f.getDeclaringType(), f.getName(), (ITypeName)VmTypeName.NULL);
            } else {
                iName = name;
            }
            return iName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

