/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResultKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.ProjectImportingWizardService;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.JpsModuleConfigurationUpdater;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.ProjectImporter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ<\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n0\u0010R\u00020\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaJpsWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/ProjectImportingWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "project", "Lcom/intellij/openapi/project/Project;", "modulesModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "modulesBuilder", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;", "ideWizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModifiableModuleModel;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;)V", "importProject", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "path", "Ljava/nio/file/Path;", "modulesIrs", "", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "buildSystem", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/buildSystem/BuildSystemType;", "isSuitableFor", "", "buildSystemType", "kotlin.project-wizard.idea"})
public final class IdeaJpsWizardService
implements ProjectImportingWizardService,
IdeaWizardService {
    private final Project project;
    private final ModifiableModuleModel modulesModel;
    private final NewProjectWizardModuleBuilder modulesBuilder;
    private final IdeWizard ideWizard;

    public boolean isSuitableFor(@NotNull BuildSystemType buildSystemType2) {
        Intrinsics.checkNotNullParameter((Object)buildSystemType2, (String)"buildSystemType");
        return buildSystemType2 == BuildSystemType.Jps;
    }

    @NotNull
    public TaskResult<Unit> importProject(@NotNull Context.Reader reader, @NotNull Path path, @NotNull List<? extends ModuleIR> modulesIrs, @NotNull BuildSystemType buildSystem) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(modulesIrs, (String)"modulesIrs");
        Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
        KotlinSdkType.Companion.setUpIfNeeded$default((KotlinSdkType.Companion)KotlinSdkType.Companion, null, null, (int)3, null);
        ProjectImporter projectImporter = new ProjectImporter(this.project, this.modulesModel, path, modulesIrs);
        this.modulesBuilder.addModuleConfigurationUpdater(new JpsModuleConfigurationUpdater(this.ideWizard.getJpsData(), projectImporter, this.project, reader));
        projectImporter.import();
        return (TaskResult)TaskResultKt.getUNIT_SUCCESS();
    }

    public IdeaJpsWizardService(@NotNull Project project, @NotNull ModifiableModuleModel modulesModel, @NotNull NewProjectWizardModuleBuilder modulesBuilder, @NotNull IdeWizard ideWizard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulesModel, (String)"modulesModel");
        Intrinsics.checkNotNullParameter((Object)((Object)modulesBuilder), (String)"modulesBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)ideWizard), (String)"ideWizard");
        this.project = project;
        this.modulesModel = modulesModel;
        this.modulesBuilder = modulesBuilder;
        this.ideWizard = ideWizard;
    }
}

