/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 G2\u00020\u0001:\u0001GB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J*\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020+2\b\u00105\u001a\u0004\u0018\u000106H\u0004J\u000e\u00107\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\n\u00108\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u00109\u001a\u00020\u00152\u0006\u00100\u001a\u000201J\u0016\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u001d2\u0006\u00100\u001a\u000201J3\u0010<\u001a\u00020/2\b\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010+2\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ,\u0010C\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020+2\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0017J*\u0010C\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020+2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020F2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u0004\u0018\u00010+8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006H"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "contents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "mainProject", "getMainProject", "()Lcom/android/tools/lint/detector/api/Project;", "phase", "", "getPhase", "()I", "getProject", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "suppressCommentPrefix", "", "getSuppressCommentPrefix", "()Ljava/lang/String;", "doReport", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "findConfiguration", "getContents", "isEnabled", "isSuppressedWithComment", "startOffset", "log", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "report", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "Companion", "android.sdktools.lint-api"})
@Beta
public class Context {
    @NotNull
    private final Configuration configuration;
    private Boolean containsCommentSuppress;
    @NotNull
    private final Project mainProject;
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    @JvmField
    @NotNull
    public final File file;
    private CharSequence contents;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    @NotNull
    public final Project getMainProject() {
        return this.mainProject;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkInfo, (String)"project.getSdkInfo()");
        return sdkInfo;
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable LintFix quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Object source = location.getSource();
        if (source instanceof Node) {
            if (this instanceof XmlContext && ((Node)source).getOwnerDocument() == ((XmlContext)this).document) {
                ((XmlContext)this).report(issue, (Node)source, location, message, quickfixData);
                return;
            }
            if (this.driver.isSuppressed(null, issue, (Node)source)) {
                return;
            }
        } else if (source instanceof PsiElement) {
            if (this instanceof JavaContext) {
                Context javaContext = this;
                if (Intrinsics.areEqual((Object)((PsiElement)source).getContainingFile(), (Object)((JavaContext)javaContext).getPsiFile())) {
                    ((JavaContext)javaContext).report(issue, (PsiElement)source, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, (PsiElement)source)) {
                return;
            }
        } else if (source instanceof UElement) {
            PsiElement element = ((UElement)source).getPsi();
            if (element != null && this instanceof JavaContext) {
                Context javaContext = this;
                if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)((JavaContext)javaContext).getPsiFile())) {
                    ((JavaContext)javaContext).report(issue, (UElement)source, location, message, quickfixData);
                    return;
                }
            }
            if (element instanceof UAnnotated ? this.driver.isSuppressed(null, issue, (UAnnotated)element) : this.driver.isSuppressed(null, issue, element)) {
                return;
            }
        }
        this.doReport(issue, location, message, quickfixData);
    }

    public static /* synthetic */ void report$default(Context context2, Issue issue, Location location, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context2.report(issue, location, string, lintFix);
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message) {
        Context.report$default(this, issue, location, message, null, 8, null);
    }

    @Deprecated(message="Here for temporary compatibility; the new typed quickfix data parameter should be used instead", replaceWith=@ReplaceWith(imports={}, expression="report(issue, location, message)"))
    public final void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable Object quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Context.report$default(this, issue, location, message, null, 8, null);
    }

    protected final void doReport(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable LintFix quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (location == Location.NONE) {
            return;
        }
        Configuration configuration = this.findConfiguration(location.getFile());
        if (configuration != this.configuration && this.configuration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        Severity severity = configuration.getSeverity(issue);
        if (severity == Severity.IGNORE) {
            return;
        }
        this.driver.getClient().report(this, issue, severity, location, message, TextFormat.RAW, quickfixData);
    }

    @NotNull
    public final Configuration findConfiguration(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ConfigurationHierarchy configurations = this.driver.getClient().getConfigurations();
        File dir = file.getParentFile();
        Object object = ConfigurationHierarchy.getConfigurationForFolder$default(configurations, dir, null, 2, null);
        if (object == null) {
            Context context2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Context $this$run = context2;
            boolean bl3 = false;
            Project project = $this$run.driver.findProjectFor(file);
            Object object2 = project;
            if (object2 == null || (object2 = ((Project)object2).getConfiguration($this$run.driver)) == null) {
                object2 = $this$run.configuration;
            }
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project?.getConfiguration(driver) ?: configuration");
        }
        return object;
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        this.driver.getClient().log(exception, format, Arrays.copyOf(args, args.length));
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path2;
        String string = path2 = this.file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null)) {
            return "noinspection ";
        }
        if (StringsKt.endsWith$default((String)path2, (String)".xml", (boolean)false, (int)2, null)) {
            return "<!--suppress ";
        }
        if (StringsKt.endsWith$default((String)path2, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        CharSequence contents;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        String string = this.getSuppressCommentPrefix();
        if (string == null) {
            return false;
        }
        String prefix = string;
        if (startOffset <= 0) {
            return false;
        }
        CharSequence charSequence = this.getContents();
        if (charSequence == null) {
            charSequence = contents = (CharSequence)"";
        }
        if (startOffset >= contents.length()) {
            return false;
        }
        int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int index = Context.Companion.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index != -1 && index + prefix.length() < lineStart) {
            String line = ((Object)contents.subSequence(index + prefix.length(), lineStart)).toString();
            return Companion.isSuppressedWithComment(line, issue);
        }
        return false;
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file, @Nullable CharSequence contents) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.file = file;
        this.contents = contents;
        Configuration configuration = this.getClient().getConfiguration(this.file);
        if (configuration == null) {
            Configuration configuration2 = this.project.getConfiguration(this.driver);
            configuration = configuration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"project.getConfiguration(driver)");
        }
        this.configuration = configuration;
        Project project2 = main;
        if (project2 == null) {
            project2 = this.project;
        }
        this.mainProject = project2;
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/Context$Companion;", "", "()V", "findPrefixOnPreviousLine", "", "contents", "", "lineStart", "prefix", "", "isSuppressedWithComment", "", "line", "category", "Lcom/android/tools/lint/detector/api/Category;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isWord", "word", "index", "isWordDelimiter", "c", "", "lineContainsId", "id", "android.sdktools.lint-api"})
    public static final class Companion {
        @VisibleForTesting
        public final boolean isSuppressedWithComment(@NotNull String line, @NotNull Issue issue) {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            return this.lineContainsId(line, issue.getId()) || this.lineContainsId(line, "all") || this.isSuppressedWithComment(line, issue.getCategory());
        }

        private final boolean isSuppressedWithComment(String line, Category category) {
            return this.lineContainsId(line, category.getName()) || category.getParent() != null && (this.lineContainsId(line, category.getFullName()) || this.isSuppressedWithComment(line, category.getParent()));
        }

        private final boolean lineContainsId(String line, String id) {
            for (int index = 0; index < line.length(); index += id.length()) {
                if ((index = StringsKt.indexOf((CharSequence)line, (String)id, (int)index, (boolean)true)) == -1) {
                    return false;
                }
                if (!this.isWord(line, id, index)) continue;
                return true;
            }
            return false;
        }

        private final boolean isWord(String line, String word, int index) {
            int end = index + word.length();
            if (end < line.length() && !this.isWordDelimiter(line.charAt(end))) {
                return false;
            }
            if (index > 0 && !this.isWordDelimiter(line.charAt(index - 1))) {
                int prefixStart = index - "AndroidLint".length();
                return index >= "AndroidLint".length() && StringsKt.regionMatches$default((String)line, (int)prefixStart, (String)"AndroidLint", (int)0, (int)"AndroidLint".length(), (boolean)false, (int)16, null) && (prefixStart == 0 || this.isWordDelimiter(line.charAt(prefixStart - 1)));
            }
            return true;
        }

        private final boolean isWordDelimiter(char c) {
            char c2 = c;
            boolean bl = false;
            return !Character.isJavaIdentifierPart(c2);
        }

        private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
            char first = prefix.charAt(0);
            boolean seenNonWhitespace = false;
            for (int offset = lineStart - 2; offset >= 0; --offset) {
                char c = contents.charAt(offset);
                if (seenNonWhitespace && c == '\n') {
                    return -1;
                }
                if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                if (c != first || !CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) continue;
                return offset;
            }
            return -1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

