/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0013H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0016J\"\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002J*\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0006H\u0016J\b\u0010)\u001a\u00020\fH\u0016J\b\u0010*\u001a\u00020\fH\u0016J\b\u0010+\u001a\u00020\fH\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010-\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010/\u001a\u000200H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u00061"}, d2={"Lcom/android/tools/lint/client/api/FlagConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;)V", "baselineFile", "Ljava/io/File;", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "allowSuppress", "", "computeSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "disabledCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "disabledIds", "", "enabledCategories", "enabledIds", "exactCategories", "exactCheckedIds", "fatalOnly", "getDefaultSeverity", "getDefinedSeverity", "getVisibleSeverity", "severity", "ignore", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "file", "issueId", "isCheckAllWarnings", "isIgnoreWarnings", "isWarningsAsErrors", "neverEnabledImplicitly", "setSeverity", "severityOverride", "unsupported", "", "android.sdktools.lint-api"})
public class FlagConfiguration
extends Configuration {
    @Nullable
    private File baselineFile;

    public boolean fatalOnly() {
        return false;
    }

    public boolean isWarningsAsErrors() {
        return false;
    }

    public boolean isIgnoreWarnings() {
        return false;
    }

    public boolean isCheckAllWarnings() {
        return false;
    }

    public boolean allowSuppress() {
        return true;
    }

    @NotNull
    public Set<String> disabledIds() {
        return SetsKt.emptySet();
    }

    @NotNull
    public Set<String> enabledIds() {
        return SetsKt.emptySet();
    }

    @Nullable
    public Set<String> exactCheckedIds() {
        return null;
    }

    @Nullable
    public Set<Category> disabledCategories() {
        return null;
    }

    @Nullable
    public Set<Category> enabledCategories() {
        return null;
    }

    @Nullable
    public Set<Category> exactCategories() {
        return null;
    }

    @Nullable
    public Severity severityOverride(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return null;
    }

    @Override
    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (issue.getSuppressNames() != null) {
            return this.getDefaultSeverity(issue);
        }
        Severity severity = this.computeSeverity(issue, source);
        if (this.fatalOnly()) {
            if (severity == null) {
                Severity configuredSeverity = this.getClient().getConfigurations().getDefinedSeverityWithoutOverride(source, issue);
                if (configuredSeverity != null && configuredSeverity == Severity.FATAL) {
                    return configuredSeverity;
                }
                if (configuredSeverity != null) {
                    return Severity.IGNORE;
                }
                if (issue.getDefaultSeverity() != Severity.FATAL) {
                    return Severity.IGNORE;
                }
            } else if (severity != Severity.FATAL) {
                return Severity.IGNORE;
            }
        }
        if (this.fatalOnly() && (severity == null && issue.getDefaultSeverity() != Severity.FATAL || severity != null && severity != Severity.FATAL)) {
            return Severity.IGNORE;
        }
        if (this.isWarningsAsErrors() || this.isIgnoreWarnings()) {
            Severity impliedSeverity;
            Severity severity2;
            Severity severity3 = severity;
            if (severity3 == null) {
                severity3 = severity2 = this.getConfigurations().getDefinedSeverityWithoutOverride(source, issue);
            }
            if (severity3 == null) {
                severity2 = impliedSeverity = this.getDefaultSeverity(issue);
            }
            if (this.isWarningsAsErrors() && impliedSeverity == Severity.WARNING) {
                if (issue == IssueRegistry.BASELINE) {
                    return severity;
                }
                severity = Severity.ERROR;
            }
            if (this.isIgnoreWarnings() && impliedSeverity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
        }
        return severity;
    }

    private final Void unsupported() {
        String string = "This method should not be invoked on a synthetic (non XML) configuration";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Void void_ = this.unsupported();
        throw null;
    }

    @Override
    public void ignore(@NotNull Issue issue, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Void void_ = this.unsupported();
        throw null;
    }

    @Override
    public void ignore(@NotNull String issueId, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Void void_ = this.unsupported();
        throw null;
    }

    @Override
    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Void void_ = this.unsupported();
        throw null;
    }

    @Override
    @Nullable
    public File getBaselineFile() {
        return this.baselineFile;
    }

    @Override
    public void setBaselineFile(@Nullable File file) {
        this.baselineFile = file;
    }

    @Override
    @NotNull
    protected Severity getDefaultSeverity(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.isCheckAllWarnings() ? (this.neverEnabledImplicitly(issue) ? super.getDefaultSeverity(issue) : issue.getDefaultSeverity()) : super.getDefaultSeverity(issue);
    }

    private final boolean neverEnabledImplicitly(Issue issue) {
        return Intrinsics.areEqual((Object)issue.getId(), (Object)"WrongThreadInterprocedural");
    }

    private final Severity computeSeverity(Issue issue, Configuration source) {
        Category category;
        Set<Category> enabledCategories;
        Set<String> enabled;
        String id;
        Severity severity;
        block10: {
            block11: {
                Category category2;
                if (issue.getSuppressNames() != null && !this.allowSuppress()) {
                    return this.getDefaultSeverity(issue);
                }
                Configuration configuration = this.getParent();
                severity = configuration != null ? configuration.getDefinedSeverity(issue, source) : null;
                id = issue.getId();
                Set<String> suppress = this.disabledIds();
                if (suppress.contains(id)) {
                    return Severity.IGNORE;
                }
                Set<Category> disabledCategories = this.disabledCategories();
                if (disabledCategories != null && (disabledCategories.contains(category2 = issue.getCategory()) || category2.getParent() != null && disabledCategories.contains(category2.getParent()))) {
                    return Severity.IGNORE;
                }
                Severity manual = this.severityOverride(issue);
                if (manual != null) {
                    return manual;
                }
                enabled = this.enabledIds();
                Set<String> exact = this.exactCheckedIds();
                enabledCategories = this.enabledCategories();
                Set<Category> exactCategories = this.exactCategories();
                category = issue.getCategory();
                if (exact != null) {
                    if (exact.contains(id)) {
                        return this.getVisibleSeverity(issue, severity, source);
                    }
                    if (category != Category.LINT) {
                        return Severity.IGNORE;
                    }
                }
                if (exactCategories == null) break block10;
                if (exactCategories.contains(category) || category.getParent() != null && exactCategories.contains(category.getParent())) {
                    return this.getVisibleSeverity(issue, severity, source);
                }
                if (category != Category.LINT) break block11;
                Set<Category> set = this.disabledCategories();
                if (set == null) break block10;
                if (!set.contains(Category.LINT)) break block10;
            }
            return Severity.IGNORE;
        }
        if (enabled.contains(id) || enabledCategories != null && (enabledCategories.contains(category) || category.getParent() != null && enabledCategories.contains(category.getParent())) || this.isCheckAllWarnings() && !this.neverEnabledImplicitly(issue)) {
            return this.getVisibleSeverity(issue, severity, source);
        }
        return severity;
    }

    private final Severity getVisibleSeverity(Issue issue, Severity severity, Configuration source) {
        Severity configuredSeverity = this.getClient().getConfigurations().getDefinedSeverityWithoutOverride(source, issue);
        if (configuredSeverity != null && configuredSeverity != Severity.IGNORE) {
            if (configuredSeverity == Severity.WARNING && this.isWarningsAsErrors()) {
                return Severity.ERROR;
            }
            return configuredSeverity;
        }
        Severity visibleSeverity = severity;
        if ((visibleSeverity == null || visibleSeverity == Severity.IGNORE) && (visibleSeverity = issue.getDefaultSeverity()) == Severity.IGNORE) {
            visibleSeverity = this.isWarningsAsErrors() ? Severity.ERROR : Severity.WARNING;
        }
        return visibleSeverity;
    }

    public FlagConfiguration(@NotNull ConfigurationHierarchy configurations) {
        Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
        super(configurations);
        Configuration configuration = this.getParent();
        this.baselineFile = configuration != null ? configuration.getBaselineFile() : null;
    }
}

