/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.ultimate.project.ProjectIndexLookupRequest;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexRecentCommits;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSetting;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSettingsKt;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011H\u0086\b\u00f8\u0001\u0000\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexRecentCommits;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "buildProjectLookupUrlList", "", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setting", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;", "projectIndexesSuggestRequests", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "checkLicense", "Lkotlin/Function1;", "", "intellij.indexing.shared.ultimate"})
public final class ProjectSharedIndexesKt {
    private static final ExtensionPointName<ProjectSharedIndexRecentCommits> EP_NAME;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SharedIndexSuggestion> projectIndexesSuggestRequests(@NotNull Project project2, @NotNull Function1<? super Project, Unit> checkLicense) {
        void $this$mapTo$iv$iv;
        int $i$f$projectIndexesSuggestRequests = 0;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(checkLicense, (String)"checkLicense");
        if (!ProjectSharedIndexes.INSTANCE.isEnabled() || project2.isDefault()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        List<ProjectSharedIndexSetting> resolvedProjectSettings = ProjectSharedIndexSettingsKt.resolvedProjectSettings(project2);
        if (resolvedProjectSettings.isEmpty()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        checkLicense.invoke((Object)project2);
        Iterable $this$map$iv = resolvedProjectSettings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void setting;
            ProjectSharedIndexSetting projectSharedIndexSetting = (ProjectSharedIndexSetting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SharedIndexId id = new SharedIndexId("project", setting.getUrl(), setting.getIndexId());
            SharedIndexSuggestion sharedIndexSuggestion = new SharedIndexSuggestion((ProjectSharedIndexSetting)setting, id, project2){
                @NotNull
                private final SharedIndexId sharedIndexId;
                @NotNull
                private final String url;
                @NotNull
                private final String testConnectionUrl;
                final /* synthetic */ ProjectSharedIndexSetting $setting;
                final /* synthetic */ SharedIndexId $id;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$setting = $captured_local_variable$1;
                    this.$id = $captured_local_variable$2;
                    this.$project$inlined = project2;
                    this.sharedIndexId = $captured_local_variable$2;
                    this.url = $captured_local_variable$1.getUrl();
                    this.testConnectionUrl = StringsKt.trimEnd((String)this.getUrl(), (char[])new char[]{'/'}) + "/index.json.xz";
                }

                @NotNull
                public SharedIndexId getSharedIndexId() {
                    return this.sharedIndexId;
                }

                @NotNull
                public String getUrl() {
                    return this.url;
                }

                @NotNull
                public String getTestConnectionUrl() {
                    return this.testConnectionUrl;
                }

                @NotNull
                public ProjectIndexLookupRequest resolveRequest(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return new ProjectIndexLookupRequest(this.$setting, ProjectSharedIndexesKt.buildProjectLookupUrlList(this.$project$inlined, indicator, this.$setting));
                }

                @NotNull
                public String toString() {
                    return "ProjectSharedIndexSuggestion(" + this.$id + ", " + this.$setting.getUrl() + ')';
                }

                @NotNull
                public String getSharedIndexDownloadedPresentableText() {
                    String string = SharedIndexesBundle.message((String)"eventLog.downloaded.project", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedIndexesBundle.mess\u2026tLog.downloaded.project\")");
                    return string;
                }

                @NotNull
                public String getSharedIndexConsentNotificationKindPresentableText() {
                    String string = SharedIndexesBundle.message((String)"notification.consent.content.kind.project", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedIndexesBundle.mess\u2026nt.content.kind.project\")");
                    return string;
                }
            };
            collection.add(sharedIndexSuggestion);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final List<String> buildProjectLookupUrlList(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull ProjectSharedIndexSetting setting) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        String url2 = setting.getUrl();
        LinkedHashSet mergedList = new LinkedHashSet();
        if (setting.getResolveCommits()) {
            boolean isChanged;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List possibleCommits = new ArrayList();
            EP_NAME.forEachExtensionSafe(new Consumer(possibleCommits, project2, indicator){
                final /* synthetic */ List $possibleCommits;
                final /* synthetic */ Project $project;
                final /* synthetic */ ProgressIndicator $indicator;

                public final void accept(ProjectSharedIndexRecentCommits it) {
                    Collection collection = this.$possibleCommits;
                    List<String> list = it.listRecentCommits(this.$project, this.$indicator);
                    boolean bl = false;
                    collection.add(list);
                }
                {
                    this.$possibleCommits = list;
                    this.$project = project2;
                    this.$indicator = progressIndicator;
                }
            });
            Iterable $this$map$iv = possibleCommits;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Iterator iterator = it.iterator();
                collection.add(iterator);
            }
            List iterators = (List)destination$iv$iv;
            do {
                isChanged = false;
                for (Iterator it : iterators) {
                    if (!it.hasNext()) continue;
                    isChanged = true;
                    Collection collection = mergedList;
                    StringBuilder stringBuilder = new StringBuilder().append(url2).append("/vcs/");
                    String string = (String)it.next();
                    boolean bl3 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    string = string3;
                    bl3 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = stringBuilder.append(StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (char[])new char[]{'/'})).toString();
                    bl3 = false;
                    collection.add(string);
                }
            } while (isChanged);
        }
        Collection collection = mergedList;
        boolean bl = false;
        collection.add(url2);
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)mergedList));
    }

    static {
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.projectsSharedIndexesRecentCommits");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026redIndexesRecentCommits\")");
        EP_NAME = extensionPointName;
    }
}

