/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/ultimate/project/ProjectIndexChunk;", "Lcom/intellij/indexing/shared/generator/IndexChunk;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "kind", "", "getKind", "()Ljava/lang/String;", "name", "Lorg/jetbrains/annotations/NotNull;", "getName", "rootIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "getRootIterators", "()Ljava/util/List;", "toString", "intellij.indexing.shared.ultimate"})
public final class ProjectIndexChunk
implements IndexChunk {
    @NotNull
    private final String name;
    @NotNull
    private final String kind;
    private final Project project;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public List<IndexableFilesIterator> getRootIterators() {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        List list = fileBasedIndex2.getOrderedIndexableFilesProviders(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fileBasedIndex.getOrdere\u2026leFilesProviders(project)");
        return list;
    }

    @NotNull
    public String toString() {
        return "Project Index Chunk for '" + this.getName() + '\'';
    }

    public ProjectIndexChunk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        String string = FileUtil.sanitizeFileName((String)this.project.getName(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.sanitizeFileName(project.name, true)");
        this.name = string;
        this.kind = "project";
    }
}

