/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.java.jdk;

import com.intellij.indexing.shared.generator.ConsoleLog;
import com.intellij.indexing.shared.generator.DumpSharedIndexCommand;
import com.intellij.indexing.shared.generator.IndexesExporter;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.ProjectUtilKt;
import com.intellij.indexing.shared.java.jdk.JdkSupport;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.ultimate.java.jdk.DumpJdkIndexArgs;
import com.intellij.indexing.shared.ultimate.java.jdk.DumpJdkIndexStarter;
import com.intellij.indexing.shared.ultimate.java.jdk.JdkIndexChunk;
import com.intellij.indexing.shared.util.ArgsParser;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/ultimate/java/jdk/DumpJdkIndexStarter;", "Lcom/intellij/indexing/shared/generator/DumpSharedIndexCommand;", "Lcom/intellij/indexing/shared/ultimate/java/jdk/DumpJdkIndexArgs;", "()V", "commandDescription", "", "getCommandDescription", "()Ljava/lang/String;", "commandName", "getCommandName", "configureJdk", "Lcom/intellij/indexing/shared/ultimate/java/jdk/DumpJdkIndexStarter$JdkInfo;", "lifetime", "Lcom/intellij/openapi/Disposable;", "jdkHome", "Ljava/nio/file/Path;", "executeCommand", "", "args", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "parseArgs", "parser", "Lcom/intellij/indexing/shared/util/ArgsParser;", "JdkInfo", "intellij.indexing.shared.ultimate.java"})
public final class DumpJdkIndexStarter
implements DumpSharedIndexCommand<DumpJdkIndexArgs> {
    @NotNull
    private final String commandName;
    @NotNull
    private final String commandDescription;

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public String getCommandDescription() {
        return this.commandDescription;
    }

    @Override
    @NotNull
    public DumpJdkIndexArgs parseArgs(@NotNull ArgsParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return new DumpJdkIndexArgs(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand(@NotNull DumpJdkIndexArgs args, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Disposable disposable = Disposer.newDisposable((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(javaClass.name)");
        Disposable lifetime = disposable;
        try {
            this.executeCommand(lifetime, args, indicator);
        }
        finally {
            Disposer.dispose((Disposable)lifetime);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void executeCommand(Disposable lifetime, DumpJdkIndexArgs args, ProgressIndicator indicator) {
        Collection<Sdk> collection;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        Iterable $this$forEach$iv = args.getJdkHomes();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Path jdkHome = (Path)element$iv2;
            boolean bl = false;
            ConsoleLog.INSTANCE.info("Specified 'jdkHome'   = " + jdkHome);
        }
        ConsoleLog.INSTANCE.info("Specified 'outputDir' = " + args.getOutputDir());
        ConsoleLog.INSTANCE.info("Specified 'tempDir'   = " + args.getTempDir());
        Object $this$map$iv = args.getJdkHomes();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void home;
            Path path = (Path)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            JdkInfo jdkInfo = this.configureJdk(lifetime, (Path)home);
            collection2.add(jdkInfo);
        }
        List jdks = (List)destination$iv$iv;
        if (jdks.isEmpty()) {
            $this$map$iv = "No JDKs were resolved for the input";
            $i$f$map = false;
            throw (Throwable)new IllegalStateException($this$map$iv.toString());
        }
        String name2 = CollectionsKt.joinToString$default((Iterable)jdks, (CharSequence)",", null, null, (int)0, null, (Function1)executeCommand.name.1.INSTANCE, (int)30, null) + args.getNameHintInfix();
        Project project2 = ProjectUtilKt.createEmptyProject$default(args.getProjectDir(), "jdk-" + name2, false, 4, null);
        ConsoleLog.INSTANCE.info("Empty project is created in " + args.getProjectDir() + ". isOpen=" + project2.isOpen());
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(project2){
            final /* synthetic */ Project $project;

            public final void invoke() {
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable(this){
                    final /* synthetic */ executeCommand.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                        projectRootManager.setProjectSdk((Sdk)null);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.$project = project2;
                super(0);
            }
        }), (int)1, null);
        Iterable $this$map$iv2 = jdks;
        boolean $i$f$map2 = false;
        Object object2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (JdkInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Sdk sdk = it.getJavaSdk();
            collection.add(sdk);
        }
        collection = (List)destination$iv$iv2;
        String string = name2;
        List list = collection;
        JdkIndexChunk indexChunk = new JdkIndexChunk(list, string);
        JdkInfo jdkInfo = (JdkInfo)CollectionsKt.singleOrNull((List)jdks);
        IndexesExporterRequest indexesExporterRequest = null;
        object2 = null;
        String string2 = null;
        String string3 = null;
        Iterator iterator = null;
        List<String> list2 = args.getAliases();
        object = jdkInfo != null ? jdkInfo.getHash() : null;
        SharedIndexMetadataInfo addon = new SharedIndexMetadataInfo(list2, (String)object, iterator, string3, string2, (Set)object2, indexesExporterRequest, 124, null);
        indexesExporterRequest = args.createIndexesExporterRequest(indexChunk, addon, CollectionsKt.listOf((Object)IndexInfrastructureOs.getOs()));
        object2 = indicator;
        IndexesExporter.exportIndexesChunk(project2, indexesExporterRequest, (ProgressIndicator)object2);
    }

    private final JdkInfo configureJdk(Disposable lifetime, Path jdkHome) {
        JavaSdk javaSdkType = JavaSdk.getInstance();
        Object object = UtilKt.runAndCatchNotNull((String)("create SDK for " + jdkHome), (Function0)((Function0)new Function0<Sdk>(jdkHome, javaSdkType){
            final /* synthetic */ Path $jdkHome;
            final /* synthetic */ JavaSdk $javaSdkType;

            @Nullable
            public final Sdk invoke() {
                return (Sdk)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Sdk>(this){
                    final /* synthetic */ configureJdk.javaSdk.1 this$0;

                    @Nullable
                    public final Sdk invoke() {
                        return SdkConfigurationUtil.createAndAddSDK((String)((Object)this.this$0.$jdkHome.toAbsolutePath()).toString(), (SdkType)((SdkType)this.this$0.$javaSdkType));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (int)1, null);
            }
            {
                this.$jdkHome = path;
                this.$javaSdkType = javaSdk2;
                super(0);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runAndCatchNotNull(\"crea\u2026avaSdkType)\n      }\n    }");
        Sdk javaSdk2 = (Sdk)object;
        Disposer.register((Disposable)lifetime, (Disposable)new Disposable(javaSdk2){
            final /* synthetic */ Sdk $javaSdk;

            public final void dispose() {
                ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ configureJdk.1 this$0;

                    public final void invoke() {
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction(new Computable(this){
                            final /* synthetic */ configureJdk.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final T compute() {
                                boolean bl = false;
                                ProjectJdkTable.getInstance().removeJdk(this.this$0.this$0.$javaSdk);
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (int)1, null);
            }
            {
                this.$javaSdk = sdk;
            }
        });
        Object object2 = UtilKt.runAndCatchNotNull((String)("resolve JDK version from path " + jdkHome), (Function0)((Function0)new Function0<String>(javaSdkType, javaSdk2){
            final /* synthetic */ JavaSdk $javaSdkType;
            final /* synthetic */ Sdk $javaSdk;

            @Nullable
            public final String invoke() {
                String string = this.$javaSdkType.getVersionString(this.$javaSdk);
                if (string == null) {
                    String string2 = "version is <null>";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaSdkType.getVersionSt\u2026rror(\"version is <null>\")");
                String version = string;
                JavaVersion javaVersion = JavaVersion.tryParse((String)version);
                if (javaVersion == null) {
                    String string3 = "JavaVersion is null for " + version;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026on is null for $version\")");
                JavaVersion javaVersion2 = javaVersion;
                return javaVersion2.toString();
            }
            {
                this.$javaSdkType = javaSdk2;
                this.$javaSdk = sdk;
                super(0);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runAndCatchNotNull(\"reso\u2026aVersion.toString()\n    }");
        String jdkVersion2 = (String)object2;
        ConsoleLog.INSTANCE.info("Resolved JDK. Version is " + jdkVersion2 + ", home = " + javaSdk2.getHomePath());
        ConsoleLog.INSTANCE.info("Collecting file roots of the SDK " + jdkVersion2 + " (" + javaSdk2.getHomePath() + ") ...");
        Object object3 = UtilKt.runAndCatchNotNull((String)"compute JDK fingerprint", (Function0)((Function0)new Function0<String>(javaSdk2){
            final /* synthetic */ Sdk $javaSdk;

            @Nullable
            public final String invoke() {
                boolean $i$f$runReadAction = false;
                return (String)ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ configureJdk.hash.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)JdkSupport.computeJdkFingerprint((Sdk)this.this$0.$javaSdk);
                    }
                });
            }
            {
                this.$javaSdk = sdk;
                super(0);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runAndCatchNotNull(\"comp\u2026gerprint(javaSdk) }\n    }");
        String hash2 = (String)object3;
        ConsoleLog.INSTANCE.info("JDK contents hash is: " + hash2);
        StringBuilder stringBuilder = new StringBuilder().append("JDK size = ");
        File file = jdkHome.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jdkHome.toFile()");
        ConsoleLog.INSTANCE.info(stringBuilder.append(StringUtil.formatFileSize((long)UtilKt.totalSize((File)file))).toString());
        ConsoleLog.INSTANCE.info("JDK hash = " + hash2);
        ConsoleLog.INSTANCE.info("Created indexing chunk for SDK " + javaSdk2.getName() + " (" + jdkVersion2 + ")}");
        return new JdkInfo(jdkHome, javaSdk2, jdkVersion2, hash2);
    }

    public DumpJdkIndexStarter() {
        this.commandName = "jdk";
        this.commandDescription = "Generates shared index for JDK";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/ultimate/java/jdk/DumpJdkIndexStarter$JdkInfo;", "", "jdkHome", "Ljava/nio/file/Path;", "javaSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "jdkVersion", "", "hash", "(Ljava/nio/file/Path;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getJavaSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getJdkHome", "()Ljava/nio/file/Path;", "getJdkVersion", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.ultimate.java"})
    private static final class JdkInfo {
        @NotNull
        private final Path jdkHome;
        @NotNull
        private final Sdk javaSdk;
        @NotNull
        private final String jdkVersion;
        @NotNull
        private final String hash;

        @NotNull
        public final Path getJdkHome() {
            return this.jdkHome;
        }

        @NotNull
        public final Sdk getJavaSdk() {
            return this.javaSdk;
        }

        @NotNull
        public final String getJdkVersion() {
            return this.jdkVersion;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        public JdkInfo(@NotNull Path jdkHome, @NotNull Sdk javaSdk2, @NotNull String jdkVersion2, @NotNull String hash2) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            Intrinsics.checkNotNullParameter((Object)javaSdk2, (String)"javaSdk");
            Intrinsics.checkNotNullParameter((Object)jdkVersion2, (String)"jdkVersion");
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            this.jdkHome = jdkHome;
            this.javaSdk = javaSdk2;
            this.jdkVersion = jdkVersion2;
            this.hash = hash2;
        }

        @NotNull
        public final Path component1() {
            return this.jdkHome;
        }

        @NotNull
        public final Sdk component2() {
            return this.javaSdk;
        }

        @NotNull
        public final String component3() {
            return this.jdkVersion;
        }

        @NotNull
        public final String component4() {
            return this.hash;
        }

        @NotNull
        public final JdkInfo copy(@NotNull Path jdkHome, @NotNull Sdk javaSdk2, @NotNull String jdkVersion2, @NotNull String hash2) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            Intrinsics.checkNotNullParameter((Object)javaSdk2, (String)"javaSdk");
            Intrinsics.checkNotNullParameter((Object)jdkVersion2, (String)"jdkVersion");
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            return new JdkInfo(jdkHome, javaSdk2, jdkVersion2, hash2);
        }

        public static /* synthetic */ JdkInfo copy$default(JdkInfo jdkInfo, Path path, Sdk sdk, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                path = jdkInfo.jdkHome;
            }
            if ((n & 2) != 0) {
                sdk = jdkInfo.javaSdk;
            }
            if ((n & 4) != 0) {
                string = jdkInfo.jdkVersion;
            }
            if ((n & 8) != 0) {
                string2 = jdkInfo.hash;
            }
            return jdkInfo.copy(path, sdk, string, string2);
        }

        @NotNull
        public String toString() {
            return "JdkInfo(jdkHome=" + this.jdkHome + ", javaSdk=" + this.javaSdk + ", jdkVersion=" + this.jdkVersion + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            Path path = this.jdkHome;
            Sdk sdk = this.javaSdk;
            String string = this.jdkVersion;
            String string2 = this.hash;
            return (((path != null ? ((Object)path).hashCode() : 0) * 31 + (sdk != null ? sdk.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JdkInfo)) break block3;
                    JdkInfo jdkInfo = (JdkInfo)object;
                    if (!Intrinsics.areEqual((Object)this.jdkHome, (Object)jdkInfo.jdkHome) || !Intrinsics.areEqual((Object)this.javaSdk, (Object)jdkInfo.javaSdk) || !Intrinsics.areEqual((Object)this.jdkVersion, (Object)jdkInfo.jdkVersion) || !Intrinsics.areEqual((Object)this.hash, (Object)jdkInfo.hash)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

