/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapperDriver;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.GitBlobSetBuilder;
import com.intellij.indexing.shared.ultimate.git.GitHashesProjectServiceKt;
import com.intellij.indexing.shared.ultimate.git.GitHashesServiceBase;
import com.intellij.indexing.shared.ultimate.git.GitProjectRecentCommitsKt;
import com.intellij.indexing.shared.ultimate.git.ProjectGitHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000f2\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u000f0\u0018H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitHashesServiceBase;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;", "project", "Lcom/intellij/openapi/project/Project;", "gitRoot", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getGitRoot", "()Ljava/nio/file/Path;", "gitRootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGitRootFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "", "isValid", "", "resolveGitHashes", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resolveGitHashesInBackground", "callback", "Lkotlin/Function1;", "intellij.indexing.shared.ultimate.git"})
public class GitHashesServiceBase
implements Disposable,
GitHashesProjectServiceWrapperDriver {
    private final Project project;
    @Nullable
    private final Path gitRoot;

    public void dispose() {
    }

    public final boolean isValid() {
        return this.gitRoot != null && Registry.is((String)"shared.index.git.hashes") && !this.project.isDisposed() && !this.project.isDefault();
    }

    @Nullable
    public final VirtualFile getGitRootFile() {
        VirtualFile virtualFile;
        Path path = this.gitRoot;
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path2;
            boolean bl3 = false;
            virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    public void resolveGitHashesInBackground(@NotNull Function1<? super GitBlobSet, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!this.isValid()) {
            callback.invoke(null);
            return;
        }
        if (!DumbService.isDumb((Project)this.project)) {
            callback.invoke(null);
            return;
        }
        new Task.Backgroundable(this, callback, this.project, SharedIndexesBundle.message((String)"progress.title.git.hashes.resolve", (Object[])new Object[0]), true){
            final /* synthetic */ GitHashesServiceBase this$0;
            final /* synthetic */ Function1 $callback;

            public void run(@NotNull ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                resolveGitHashesInBackground.1 var3_2 = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    resolveGitHashesInBackground.1 $this$runCatching = var3_2;
                    boolean bl2 = false;
                    GitBlobSet gitBlobSet = this.this$0.resolveGitHashes(indicator);
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)gitBlobSet);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                var3_2 = object;
                bl = false;
                GitBlobSet result = (GitBlobSet)((Object)(Result.isFailure-impl((Object)((Object)var3_2)) ? null : var3_2));
                GitHashesProjectServiceKt.access$getLOG$p().info("Collected Git Blobs: " + result);
                this.$callback.invoke((Object)result);
            }
            {
                this.this$0 = this$0;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    @Nullable
    public final GitBlobSet resolveGitHashes(@NotNull ProgressIndicator indicator) {
        Set gitChanged;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!this.isValid()) {
            return null;
        }
        if (this.gitRoot == null) {
            return null;
        }
        VirtualFile virtualFile = this.getGitRootFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile gitRootFile = virtualFile;
        Future listBlobs2 = AppExecutorUtil.getAppExecutorService().submit(new Callable(this, gitRootFile, indicator){
            final /* synthetic */ GitHashesServiceBase this$0;
            final /* synthetic */ VirtualFile $gitRootFile;
            final /* synthetic */ ProgressIndicator $indicator;

            public final GitBlobSet call() {
                GitBlobSetBuilder builder = new GitBlobSetBuilder(this.$gitRootFile);
                ProjectGitHelper.INSTANCE.logGitBlobHashes(GitHashesServiceBase.access$getProject$p(this.this$0), this.this$0.getGitRoot(), this.$indicator, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this, builder){
                    final /* synthetic */ resolveGitHashes.listBlobs.1 this$0;
                    final /* synthetic */ GitBlobSetBuilder $builder;

                    public final void invoke(@NotNull String relPath, @NotNull String hash2) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)relPath, (String)"relPath");
                        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
                        GitHashesServiceBase gitHashesServiceBase = this.this$0.this$0;
                        boolean bl = false;
                        try {
                            object = Result.Companion;
                            Object $this$runCatching = gitHashesServiceBase;
                            boolean bl2 = false;
                            $this$runCatching = StringUtil.parseHexString((String)hash2);
                            bl2 = false;
                            object = Result.constructor-impl((Object)$this$runCatching);
                        }
                        catch (Throwable $this$runCatching) {
                            Result.Companion bl2 = Result.Companion;
                            boolean bl3 = false;
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                        }
                        gitHashesServiceBase = object;
                        bl = false;
                        boolean bl4 = false;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)gitHashesServiceBase);
                        if (throwable != null) {
                            Throwable it = throwable;
                            boolean bl5 = false;
                            return;
                        }
                        byte[] hashBytes = (byte[])gitHashesServiceBase;
                        Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
                        this.$builder.add(relPath, hashBytes);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$builder = gitBlobSetBuilder;
                        super(2);
                    }
                }));
                return builder.build();
            }
            {
                this.this$0 = gitHashesServiceBase;
                this.$gitRootFile = virtualFile;
                this.$indicator = progressIndicator;
            }
        });
        Future listFiles2 = AppExecutorUtil.getAppExecutorService().submit(new Callable(this){
            final /* synthetic */ GitHashesServiceBase this$0;

            public final Set<String> call() {
                return ProjectGitHelper.INSTANCE.logGitModifiedFiles(GitHashesServiceBase.access$getProject$p(this.this$0), this.this$0.getGitRoot());
            }
            {
                this.this$0 = gitHashesServiceBase;
            }
        });
        GitBlobSet gitBlobs = (GitBlobSet)ProgressIndicatorUtils.awaitWithCheckCanceled(listBlobs2);
        Set set = gitChanged = (Set)ProgressIndicatorUtils.awaitWithCheckCanceled(listFiles2);
        Intrinsics.checkNotNull((Object)set);
        return gitBlobs.withIgnoredItems-Strings(set);
    }

    @Nullable
    protected final Path getGitRoot() {
        return this.gitRoot;
    }

    public GitHashesServiceBase(@NotNull Project project2, @Nullable Path gitRoot) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.gitRoot = gitRoot;
    }

    public /* synthetic */ GitHashesServiceBase(Project project2, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = GitProjectRecentCommitsKt.resolveProjectGitRoot(project2);
        }
        this(project2, path);
    }

    public static final /* synthetic */ Project access$getProject$p(GitHashesServiceBase $this) {
        return $this.project;
    }
}

