/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.ultimate.git.GitBlobKey;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0007\u00a2\u0006\u0002\b\u001aJ\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0007\u00a2\u0006\u0002\b\u001bJ\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0007\u00a2\u0006\u0002\b\u001dR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "namesMap", "", "", "", "items", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobKey;", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Map;Ljava/util/Map;)V", "fileToKey", "file", "relName", "find", "isEmpty", "", "mapFilesToExistingKeys", "", "files", "", "removeAll", "toString", "withIgnoredItems", "relNames", "withIgnoredItems-VirtualFiles", "withIgnoredItems-Strings", "namesToRemove", "withIgnoredItems-GitBlobKey", "intellij.indexing.shared.ultimate.git"})
public final class GitBlobSet {
    private final VirtualFile root;
    private final Map<String, Integer> namesMap;
    private final Map<GitBlobKey, byte[]> items;

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    @NotNull
    public String toString() {
        return "GitBlobSet(root=" + this.root + ", items=" + this.items.size() + ')';
    }

    @JvmName(name="withIgnoredItems-VirtualFiles")
    @NotNull
    public final GitBlobSet withIgnoredItems-VirtualFiles(@NotNull Collection<? extends VirtualFile> relNames) {
        Intrinsics.checkNotNullParameter(relNames, (String)"relNames");
        if (this.isEmpty()) {
            return this;
        }
        if (relNames.isEmpty()) {
            return this;
        }
        Set<GitBlobKey> mappedFiles = this.mapFilesToExistingKeys(relNames);
        return this.withIgnoredItems-GitBlobKey(mappedFiles);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="withIgnoredItems-GitBlobKey")
    @NotNull
    public final GitBlobSet withIgnoredItems-GitBlobKey(@NotNull Set<GitBlobKey> namesToRemove) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(namesToRemove, (String)"namesToRemove");
        if (this.isEmpty()) {
            return this;
        }
        if (namesToRemove.isEmpty()) {
            return this;
        }
        Map<GitBlobKey, byte[]> map2 = this.items;
        Map destination$iv = new HashMap(this.items.size());
        boolean $i$f$filterTo = false;
        void var6_5 = $this$filterTo$iv;
        boolean bl = false;
        Iterator iterator = var6_5.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            if (!(!namesToRemove.contains(it.getKey()))) continue;
            destination$iv.put(element$iv.getKey(), element$iv.getValue());
        }
        HashMap copy = (HashMap)destination$iv;
        if (copy.isEmpty()) {
            return this.removeAll();
        }
        if (copy.size() == this.items.size()) {
            return this;
        }
        return new GitBlobSet(this.root, this.namesMap, copy);
    }

    @NotNull
    public final GitBlobSet removeAll() {
        boolean bl = false;
        bl = false;
        return new GitBlobSet(this.root, MapsKt.emptyMap(), MapsKt.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="withIgnoredItems-Strings")
    @NotNull
    public final GitBlobSet withIgnoredItems-Strings(@NotNull Collection<String> relNames) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(relNames, (String)"relNames");
        if (this.isEmpty()) {
            return this;
        }
        if (relNames.isEmpty()) {
            return this;
        }
        Iterable iterable = relNames;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitBlobKey gitBlobKey;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (this.fileToKey(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            GitBlobKey it$iv = gitBlobKey;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        HashSet mappedNames = (HashSet)destination$iv;
        return this.withIgnoredItems-GitBlobKey(mappedNames);
    }

    @Nullable
    public final byte[] find(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitBlobKey gitBlobKey = this.fileToKey(file);
        if (gitBlobKey == null) {
            return null;
        }
        return this.items.get(gitBlobKey);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GitBlobKey> mapFilesToExistingKeys(@NotNull Collection<? extends VirtualFile> files) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = files;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitBlobKey gitBlobKey;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl2 = false;
            if (this.fileToKey(it) == null) {
                gitBlobKey = null;
            } else {
                GitBlobKey key;
                Map<GitBlobKey, byte[]> map2 = this.items;
                boolean bl3 = false;
                Map<GitBlobKey, byte[]> map3 = map2;
                boolean bl4 = false;
                gitBlobKey = !map3.containsKey(key) ? null : key;
            }
            if (gitBlobKey == null) continue;
            GitBlobKey gitBlobKey2 = gitBlobKey;
            boolean bl5 = false;
            boolean bl6 = false;
            GitBlobKey it$iv = gitBlobKey2;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final GitBlobKey fileToKey(String relName) {
        List elements = StringsKt.split$default((CharSequence)relName, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        String name2 = (String)CollectionsKt.last((List)elements);
        int[] ids = new int[elements.size() - 1];
        int n = 0;
        int n2 = elements.size() - 1;
        while (n < n2) {
            void i;
            Integer n3 = this.namesMap.get(elements.get((int)i));
            if (n3 == null) {
                return null;
            }
            ids[i] = n3;
            ++i;
        }
        return new GitBlobKey(ids, name2);
    }

    private final GitBlobKey fileToKey(VirtualFile file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        String name2 = string;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        ArrayList invertedIds = new ArrayList();
        VirtualFile tmp = parent;
        while (Intrinsics.areEqual((Object)tmp, (Object)this.root) ^ true) {
            Collection collection = invertedIds;
            Integer n = this.namesMap.get(tmp.getName());
            if (n == null) {
                return null;
            }
            Integer n2 = (int)n;
            boolean bl = false;
            collection.add(n2);
            if (tmp.getParent() != null) continue;
            return null;
        }
        int[] ids = CollectionsKt.toIntArray((Collection)invertedIds);
        ArraysKt.reverse((int[])ids);
        return new GitBlobKey(ids, name2);
    }

    public GitBlobSet(@NotNull VirtualFile root, @NotNull Map<String, Integer> namesMap, @NotNull Map<GitBlobKey, byte[]> items) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(namesMap, (String)"namesMap");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.root = root;
        this.namesMap = namesMap;
        this.items = items;
    }
}

