/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator.diagnostic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatisticsDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000f\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JJ\u0010\u0018\u001a\u00020\t\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a*\u00060\u0010j\u0002`\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatisticsDumper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dumpStatistics", "", "chunkName", "", "exportStatistics", "Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;", "getPresentableStatistics", "appendIndexStatistics", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indexId", "Lcom/intellij/util/indexing/ID;", "numberOfIndexedFiles", "", "isEmptyData", "", "appendKeyValues", "V", "", "data", "", "valueToString", "Lkotlin/Function1;", "appendPerFileTypeStatistics", "appendPerIndexDirectorySizesStatistics", "appendPerIndexStatistics", "intellij.indexing.shared.generator"})
public final class IndexExportStatisticsDumper {
    private static final Logger LOG;
    private static final ObjectMapper jacksonMapper;
    @NotNull
    public static final IndexExportStatisticsDumper INSTANCE;

    public final void dumpStatistics(@NotNull String chunkName, @NotNull IndexExportStatistics exportStatistics) {
        Intrinsics.checkNotNullParameter((Object)chunkName, (String)"chunkName");
        Intrinsics.checkNotNullParameter((Object)exportStatistics, (String)"exportStatistics");
        LOG.info("Statistics for " + chunkName + '\n' + this.getPresentableStatistics(exportStatistics));
        try {
            Path path;
            Path targetPath;
            String timestamp = IndexDiagnosticDumper.Companion.getDiagnosticTimestampFormat().format(LocalDateTime.now());
            Path path2 = targetPath = IndexDiagnosticDumper.Companion.getIndexingDiagnosticDir().resolve("shared-indexes-export-stats-" + timestamp + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetPath");
            Path path3 = path2.getParent();
            if (path3 != null) {
                Path path4 = path3;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                boolean bl = false;
                Path path5 = Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                path = path5;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"Files.createDirectories(this, *attributes)");
            } else {
                path = null;
            }
            String string = jacksonMapper.writeValueAsString((Object)exportStatistics);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonMapper.writeValueAsString(exportStatistics)");
            PathsKt.writeText$default((Path)targetPath, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        catch (Exception e) {
            LOG.error("Failed to dump exporter statistics", (Throwable)e);
        }
    }

    private final String getPresentableStatistics(IndexExportStatistics exportStatistics) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string = "Shared index generation statistics";
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        stringBuilder2 = $this$buildString;
        string = "Indexing time " + StringUtil.formatDuration((long)exportStatistics.getIndexingTimeMs().get());
        bl6 = false;
        StringBuilder stringBuilder4 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        stringBuilder2 = $this$buildString;
        string = "Total time " + StringUtil.formatDuration((long)exportStatistics.getTotalTimeMs().get());
        bl6 = false;
        StringBuilder stringBuilder5 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        stringBuilder2 = $this$buildString;
        string = "Index size " + StringUtil.formatFileSize((long)exportStatistics.getIndexSizeBytes().get());
        bl6 = false;
        StringBuilder stringBuilder6 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        stringBuilder2 = $this$buildString;
        string = "Total number of indexed files: " + exportStatistics.getTotalNumberOfIndexedFiles();
        bl6 = false;
        StringBuilder stringBuilder7 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        stringBuilder2 = $this$buildString;
        string = "Total size of indexed files: " + StringUtil.formatFileSize((long)exportStatistics.getTotalSizeOfIndexedFiles().get());
        bl6 = false;
        StringBuilder stringBuilder8 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder8);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per file type statistics";
        bl6 = false;
        StringBuilder stringBuilder9 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder9);
        INSTANCE.appendPerFileTypeStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per index directories sizes statistics";
        bl6 = false;
        StringBuilder stringBuilder10 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder10);
        INSTANCE.appendPerIndexDirectorySizesStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per index data statistics";
        bl6 = false;
        StringBuilder stringBuilder11 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder11);
        INSTANCE.appendPerIndexStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendPerIndexDirectorySizesStatistics(StringBuilder $this$appendPerIndexDirectorySizesStatistics, IndexExportStatistics exportStatistics) {
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        String string;
        String string2;
        Object it;
        Map map3;
        Map.Entry entry;
        void $this$mapKeysTo$iv$iv322;
        Object $this$mapKeys$iv;
        Object object = $this$appendPerIndexDirectorySizesStatistics;
        String string3 = "Sizes of file based indexes: ";
        boolean bl2 = false;
        StringBuilder stringBuilder = ((StringBuilder)object).append(string3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        object = exportStatistics.getFbIndexToDirectorySize();
        StringBuilder stringBuilder2 = $this$appendPerIndexDirectorySizesStatistics;
        IndexExportStatisticsDumper indexExportStatisticsDumper = this;
        boolean $i$f$mapKeys22 = false;
        void var5_9 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv322.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map3 = destination$iv$iv;
            boolean bl3 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            Intrinsics.checkNotNullExpressionValue((Object)((ID)k).getName(), (String)"it.key.name");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string = string2;
            map2 = map3;
            bl = false;
            it = it$iv$iv.getValue();
            map2.put(string, it);
        }
        map3 = destination$iv$iv;
        indexExportStatisticsDumper.appendKeyValues(stringBuilder2, map3, appendPerIndexDirectorySizesStatistics.2.INSTANCE);
        StringsKt.appendln((StringBuilder)$this$appendPerIndexDirectorySizesStatistics);
        $this$mapKeys$iv = $this$appendPerIndexDirectorySizesStatistics;
        String $i$f$mapKeys22 = "Sizes of stub indexes: ";
        boolean $this$mapKeysTo$iv$iv322 = false;
        StringBuilder stringBuilder3 = ((StringBuilder)$this$mapKeys$iv).append($i$f$mapKeys22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        $this$mapKeys$iv = exportStatistics.getStubIndexToDirectorySize();
        stringBuilder2 = $this$appendPerIndexDirectorySizesStatistics;
        indexExportStatisticsDumper = this;
        boolean $i$f$mapKeys = false;
        Object $this$mapKeysTo$iv$iv322 = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv322.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map3 = destination$iv$iv;
            boolean bl4 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            Intrinsics.checkNotNullExpressionValue((Object)((ID)k).getName(), (String)"it.key.name");
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string = string2;
            map2 = map3;
            bl = false;
            entry = it$iv$iv.getValue();
            map2.put(string, entry);
        }
        map3 = destination$iv$iv;
        indexExportStatisticsDumper.appendKeyValues(stringBuilder2, map3, appendPerIndexDirectorySizesStatistics.4.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendPerFileTypeStatistics(StringBuilder $this$appendPerFileTypeStatistics, IndexExportStatistics exportStatistics) {
        Map map2;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map3 = exportStatistics.getFileTypeToNumberOfIndexedFiles();
        StringBuilder stringBuilder = $this$appendPerFileTypeStatistics;
        IndexExportStatisticsDumper indexExportStatisticsDumper = this;
        boolean $i$f$mapKeys = false;
        void var5_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            String string;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            Intrinsics.checkNotNullExpressionValue((Object)((FileType)k).getName(), (String)"it.key.name");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = string;
            Map map4 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(string2, entry);
        }
        map2 = destination$iv$iv;
        IndexExportStatisticsDumper.appendKeyValues$default(indexExportStatisticsDumper, stringBuilder, map2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final <V extends Comparable<? super V>> void appendKeyValues(StringBuilder $this$appendKeyValues, Map<String, ? extends V> data, Function1<? super V, String> valueToString) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv = data.entrySet();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void key;
            Map.Entry $dstr$key$value = (Map.Entry)element$iv;
            boolean bl2 = false;
            Object object = $dstr$key$value;
            boolean bl3 = false;
            String string = (String)object.getKey();
            object = $dstr$key$value;
            bl3 = false;
            Comparable value = (Comparable)object.getValue();
            object = $this$appendKeyValues;
            String string2 = "    " + (String)key + ": " + (String)valueToString.invoke((Object)value);
            boolean bl4 = false;
            StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
    }

    static /* synthetic */ void appendKeyValues$default(IndexExportStatisticsDumper indexExportStatisticsDumper, StringBuilder stringBuilder, Map map2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = appendKeyValues.1.INSTANCE;
        }
        indexExportStatisticsDumper.appendKeyValues(stringBuilder, map2, function1);
    }

    private final void appendPerIndexStatistics(StringBuilder $this$appendPerIndexStatistics, IndexExportStatistics exportStatistics) {
        ID indexId;
        Integer filesNumber;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$indexId$filesNumber;
        Object element$iv;
        Object $this$forEach$iv;
        StringBuilder stringBuilder = $this$appendPerIndexStatistics;
        String string = "File based indices (" + exportStatistics.getFbIndexToNumberOfIndexedFiles().size() + "): ";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Function1 $fun$isEmpty$1 = new Function1<ID<?, ?>, Boolean>(exportStatistics){
            final /* synthetic */ IndexExportStatistics $exportStatistics;

            public final boolean invoke(@NotNull ID<?, ?> indexId) {
                Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
                return this.$exportStatistics.getEmptyFbiIndexes().contains(indexId) || this.$exportStatistics.getEmptyStubIndexes().contains(indexId);
            }
            {
                this.$exportStatistics = indexExportStatistics;
                super(1);
            }
        };
        bl2 = false;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl3 = false;
        Comparator comparator = ((Comparator)new Comparator<T>((Comparator)object, $fun$isEmpty$1){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ appendPerIndexStatistics.1 $isEmpty$1$inlined;
            {
                this.$this_thenBy = comparator;
                this.$isEmpty$1$inlined = var2_2;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    Comparable comparable = this.$isEmpty$1$inlined.invoke((ID)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = this.$isEmpty$1$inlined.invoke((ID)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        }).reversed();
        Iterable iterable = exportStatistics.getFbIndexToNumberOfIndexedFiles().entrySet();
        Comparator comparator2 = comparator;
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparator");
        object = CollectionsKt.sortedWith((Iterable)iterable, comparator2);
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            $dstr$indexId$filesNumber = (Map.Entry)element$iv;
            boolean bl4 = false;
            entry = $dstr$indexId$filesNumber;
            bl = false;
            ID iD = (ID)entry.getKey();
            entry = $dstr$indexId$filesNumber;
            bl = false;
            filesNumber = (Integer)entry.getValue();
            void v3 = indexId;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"indexId");
            Integer n = filesNumber;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"filesNumber");
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, (ID<?, ?>)v3, n, $fun$isEmpty$1.invoke(indexId));
        }
        StringsKt.appendln((StringBuilder)$this$appendPerIndexStatistics);
        $this$forEach$iv = $this$appendPerIndexStatistics;
        String $i$f$forEach22 = "Stub indices (" + exportStatistics.getStubIndexToNumberOfIndexedFiles().size() + "): ";
        boolean bl5 = false;
        StringBuilder stringBuilder3 = ((StringBuilder)$this$forEach$iv).append($i$f$forEach22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)exportStatistics.getStubIndexToNumberOfIndexedFiles().entrySet(), comparator);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            $dstr$indexId$filesNumber = (Map.Entry)element$iv;
            boolean bl6 = false;
            entry = $dstr$indexId$filesNumber;
            bl = false;
            indexId = (ID)entry.getKey();
            entry = $dstr$indexId$filesNumber;
            bl = false;
            filesNumber = (Integer)entry.getValue();
            ID iD = indexId;
            Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"indexId");
            Integer n = filesNumber;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"filesNumber");
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, iD, n, $fun$isEmpty$1.invoke(indexId));
        }
        StringsKt.appendln((StringBuilder)$this$appendPerIndexStatistics);
    }

    private final void appendIndexStatistics(StringBuilder $this$appendIndexStatistics, ID<?, ?> indexId, int numberOfIndexedFiles, boolean isEmptyData) {
        $this$appendIndexStatistics.append("    ").append("Generator for ").append(indexId).append(" indexed ").append(numberOfIndexedFiles).append(" files");
        if (isEmptyData) {
            $this$appendIndexStatistics.append(" (empty indexed data)");
        }
        StringsKt.appendln((StringBuilder)$this$appendIndexStatistics);
    }

    private IndexExportStatisticsDumper() {
    }

    static {
        IndexExportStatisticsDumper indexExportStatisticsDumper;
        INSTANCE = indexExportStatisticsDumper = new IndexExportStatisticsDumper();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexExportStatisticsDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        jacksonMapper = ExtensionsKt.jacksonObjectMapper();
    }
}

