/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.indexing.shared.generator.IndexedFileContentLoader;
import com.intellij.indexing.shared.generator.IndexedFilesCollector;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterEP;
import com.intellij.indexing.shared.generator.IndexesExporterGenerators;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerateTask;
import com.intellij.indexing.shared.generator.IndexesExporterMainIndex;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.IndexesExporterTaskResult;
import com.intellij.indexing.shared.generator.IndexesExporterUtil;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexGenerationStatistics;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

class IndexesExporterTask {
    private static final Logger LOG = Logger.getInstance(IndexesExporterTask.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeSharedIndexesState myState;
    @NotNull
    private final ErrorsCollector myErrorsCollector;
    @NotNull
    private final IndexesExporterRequest myRequest;
    @NotNull
    private final IndexExportStatistics myIndexExportStatistics;

    IndexesExporterTask(@NotNull Project project2, @NotNull IdeSharedIndexesState state, @NotNull IndexesExporterRequest request, @NotNull IndexExportStatistics statistics, @NotNull ErrorsCollector errorsCollector) {
        if (project2 == null) {
            IndexesExporterTask.$$$reportNull$$$0(0);
        }
        if (state == null) {
            IndexesExporterTask.$$$reportNull$$$0(1);
        }
        if (request == null) {
            IndexesExporterTask.$$$reportNull$$$0(2);
        }
        if (statistics == null) {
            IndexesExporterTask.$$$reportNull$$$0(3);
        }
        if (errorsCollector == null) {
            IndexesExporterTask.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myState = state;
        this.myRequest = request;
        this.myIndexExportStatistics = statistics;
        this.myErrorsCollector = errorsCollector;
    }

    @NotNull
    public IndexesExporterTaskResult exportIndexesChunk(@NotNull ProgressIndicator indicator, @NotNull Path chunkRoot) throws Exception {
        if (indicator == null) {
            IndexesExporterTask.$$$reportNull$$$0(5);
        }
        if (chunkRoot == null) {
            IndexesExporterTask.$$$reportNull$$$0(6);
        }
        IndexedFileContentLoader fileContentLoader = new IndexedFileContentLoader(this.myProject, this.myErrorsCollector, this.myState.getNoSizeLimitApplicableFileTypes());
        IndexedFilesReporter reporter = null;
        Path targetForListDump = this.myRequest.getTargetIndexedFilesListDump();
        if (targetForListDump != null) {
            LOG.info("List of indexed files reports will be dumped to " + targetForListDump);
            reporter = new IndexedFilesReporter(targetForListDump);
        }
        HashedIndexedFiles filesToBeIndexedSet = new IndexedFilesCollector(this.myProject, this.myRequest, this.myErrorsCollector, reporter).collectFilesForIndexing(indicator, fileContentLoader);
        EnumeratedHashedIndexedFiles hashEnumeration = new IndexesExporterHashEnumerateTask(this.myErrorsCollector, reporter).enumerateHashes(filesToBeIndexedSet, chunkRoot, indicator);
        SharedIndexMetadataInfo additionalMetadata = IndexesExporterUtil.includeBases(this.myRequest.getAdditionalMetadata(), filesToBeIndexedSet.getUsedBases());
        this.myState.withActualHashGeneratorVersions(filesToBeIndexedSet.getUsedHashes());
        IndexesExporterTaskResult indexesExporterTaskResult = this.generateIndexes(chunkRoot, hashEnumeration, fileContentLoader, additionalMetadata, indicator);
        if (indexesExporterTaskResult == null) {
            IndexesExporterTask.$$$reportNull$$$0(7);
        }
        return indexesExporterTaskResult;
    }

    private IndexesExporterTaskResult generateIndexes(@NotNull Path chunkRoot, @NotNull EnumeratedHashedIndexedFiles files, @NotNull IndexedFileContentLoader fileContentLoader, @NotNull SharedIndexMetadataInfo additionalMetadata, @NotNull ProgressIndicator indicator) throws Exception {
        boolean isSharedIndexEmpty;
        if (chunkRoot == null) {
            IndexesExporterTask.$$$reportNull$$$0(8);
        }
        if (files == null) {
            IndexesExporterTask.$$$reportNull$$$0(9);
        }
        if (fileContentLoader == null) {
            IndexesExporterTask.$$$reportNull$$$0(10);
        }
        if (additionalMetadata == null) {
            IndexesExporterTask.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            IndexesExporterTask.$$$reportNull$$$0(12);
        }
        IndexesExporterGenerators generators = new IndexesExporterGenerators(chunkRoot, this.myState, this.myRequest, this.myIndexExportStatistics);
        try (AutoCloseable ignored = generators.openAndClose(indicator);){
            new IndexesExporterMainIndex(this.myProject, this.myErrorsCollector, fileContentLoader, this.myRequest).generateMainIndex(generators, files, indicator);
            new IndexesExporterEP(this.myProject, this.myRequest, this.myErrorsCollector, chunkRoot, this.myState).executeExtensionPoints(files, indicator);
        }
        indicator.setIndeterminate(true);
        indicator.setText(SharedIndexesBundle.message((String)"progress.text.finalizing.indexes", (Object[])new Object[0]));
        IndexChunk chunk2 = this.myRequest.getChunk();
        SharedIndexInfrastructureVersion indexVersion = this.myState.getIndexVersion();
        UnaryOperator<SharedIndexInfrastructureVersion> testIndexVersionModifier = this.myRequest.getTestOnlyIndexVersionModifier();
        if (testIndexVersionModifier != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new AssertionError((Object)"Index version can be modified only for testing purposes");
        }
        SharedIndexGenerationStatistics generationStatistics = new SharedIndexGenerationStatistics(this.myIndexExportStatistics.filedBasedIndexUsages(), this.myIndexExportStatistics.stubFileElementTypeUsages());
        byte[] metadataBytes = SharedIndexMetadata.writeIndexMetadata((SharedIndexMetadata)new SharedIndexMetadata(chunk2.getName(), chunk2.getKind(), testIndexVersionModifier == null ? indexVersion : (SharedIndexInfrastructureVersion)testIndexVersionModifier.apply(indexVersion), additionalMetadata, generationStatistics));
        Files.write(SharedIndexMetadata.getMetadataPath((Path)chunkRoot), metadataBytes, new OpenOption[0]);
        boolean bl = isSharedIndexEmpty = ContainerUtil.find(this.myIndexExportStatistics.getFileTypeToNumberOfIndexedFiles().values(), count -> count != 0) == null;
        if (isSharedIndexEmpty) {
            throw new RuntimeException("Generated shared index is empty and must not be used!");
        }
        return new IndexesExporterTaskResult(metadataBytes, indexVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statistics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsCollector";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/generator/IndexesExporterTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentLoader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/generator/IndexesExporterTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "exportIndexesChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportIndexesChunk";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateIndexes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

