/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.google.common.collect.ImmutableList;
import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.indexing.shared.generate.StubHashBasedIndexGenerator;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.SharedIndexNoStubFileTypeBean;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.impl.EmptyIndexEnumerator;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class IndexesExporterGenerators {
    @NotNull
    private final Path myChunkRoot;
    final StubHashBasedIndexGenerator stubGenerator;
    final List<HashBasedIndexGenerator<?, ?>> fileBasedGenerators;
    final List<HashBasedIndexGenerator<?, ?>> allGenerators;
    final IndexExportStatistics exportStatistics;

    IndexesExporterGenerators(@NotNull Path chunkRoot, @NotNull IdeSharedIndexesState indexers, @NotNull IndexesExporterRequest request, @NotNull IndexExportStatistics exportStatistics) {
        if (chunkRoot == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(0);
        }
        if (indexers == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(1);
        }
        if (request == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(2);
        }
        if (exportStatistics == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(3);
        }
        this.myChunkRoot = chunkRoot;
        this.exportStatistics = exportStatistics;
        this.stubGenerator = new StubHashBasedIndexGenerator(this.myChunkRoot, indexers.exportableStubIndexExtensions, ContainerUtil.map2SetNotNull((Collection)ContainerUtil.union(request.getNoStubTreeFileType(), SharedIndexNoStubFileTypeBean.getFileTypeNamesWithNoStubFromEp()), ftName -> FileTypeManager.getInstance().findFileTypeByName(ftName)));
        this.fileBasedGenerators = ContainerUtil.map((Collection)indexers.exportableFileBasedIndexExtensions, ex -> new HashBasedIndexGenerator(ex, this.myChunkRoot));
        this.allGenerators = ImmutableList.builder().addAll(this.fileBasedGenerators).add((Object)this.stubGenerator).build();
    }

    private void openGenerators() {
        for (HashBasedIndexGenerator<?, ?> generator : this.allGenerators) {
            try {
                generator.openIndex();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open " + generator.getIndexId().getName() + ". " + e.getMessage(), e);
            }
        }
    }

    private void closeGenerators() {
        for (HashBasedIndexGenerator<?, ?> generator : this.allGenerators) {
            try {
                generator.closeIndex();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close " + generator.getIndexId().getName() + ". " + e.getMessage(), e);
            }
        }
        this.deleteEmptyIndexes();
        this.exportStatistics();
    }

    @NotNull
    public AutoCloseable openAndClose(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(4);
        }
        this.openGenerators();
        return new AutoCloseable(){

            @Override
            public void close() {
                indicator.setIndeterminate(true);
                indicator.setText(SharedIndexesBundle.message((String)"progress.text.closing.indexes", (Object[])new Object[0]));
                IndexesExporterGenerators.this.closeGenerators();
            }
        };
    }

    private void deleteEmptyIndexes() {
        IndexesExporterGenerators.deleteEmptyIndices(this.fileBasedGenerators, this.myChunkRoot, false);
        IndexesExporterGenerators.deleteEmptyIndices(this.stubGenerator.getStubGenerators(), this.myChunkRoot, true);
    }

    private void exportStatistics() {
        for (HashBasedIndexGenerator<?, ?> hashBasedIndexGenerator : this.fileBasedGenerators) {
            this.exportStatistics.getFbIndexToNumberOfIndexedFiles().put(hashBasedIndexGenerator.getIndexId(), hashBasedIndexGenerator.getIndexedFilesNumber());
            if (hashBasedIndexGenerator.isEmpty()) {
                this.exportStatistics.getEmptyFbiIndexes().add(hashBasedIndexGenerator.getIndexId());
                continue;
            }
            this.exportStatistics.getFbIndexToDirectorySize().put(hashBasedIndexGenerator.getIndexId(), UtilKt.getFileOrDirectorySize((Path)hashBasedIndexGenerator.getIndexRoot()));
        }
        for (HashBasedIndexGenerator hashBasedIndexGenerator : this.stubGenerator.getStubGenerators()) {
            this.exportStatistics.getStubIndexToNumberOfIndexedFiles().put(hashBasedIndexGenerator.getIndexId(), hashBasedIndexGenerator.getIndexedFilesNumber());
            if (hashBasedIndexGenerator.isEmpty()) {
                this.exportStatistics.getEmptyStubIndexes().add(hashBasedIndexGenerator.getIndexId());
                continue;
            }
            this.exportStatistics.getStubIndexToDirectorySize().put(hashBasedIndexGenerator.getIndexId(), UtilKt.getFileOrDirectorySize((Path)hashBasedIndexGenerator.getIndexRoot()));
        }
    }

    private static void deleteEmptyIndices(@NotNull List<HashBasedIndexGenerator<?, ?>> generators, @NotNull Path chunkRoot, boolean stubs) {
        if (generators == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(5);
        }
        if (chunkRoot == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(6);
        }
        TreeSet<String> emptyIndices = new TreeSet<String>();
        for (HashBasedIndexGenerator<?, ?> generator : generators) {
            if (!generator.isEmpty()) continue;
            emptyIndices.add(generator.getIndexId().getName());
            Path indexRoot = generator.getIndexRoot();
            PathKt.delete((Path)indexRoot);
        }
        try {
            if (stubs) {
                EmptyIndexEnumerator.writeEmptyStubIndexes((Path)chunkRoot, emptyIndices);
            } else {
                EmptyIndexEnumerator.writeEmptyIndexes((Path)chunkRoot, emptyIndices);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deleteEmptyIndices. " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportStatistics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generators";
                break;
            }
        }
        objectArray2[1] = "com/intellij/indexing/shared/generator/IndexesExporterGenerators";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndClose";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteEmptyIndices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

