/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexExporterBase;
import com.intellij.indexing.shared.generator.IndexExporterBases;
import com.intellij.indexing.shared.generator.IndexedFileContentLoader;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesCollectorKt;
import com.intellij.indexing.shared.generator.IndexedFilesCollectorParameters;
import com.intellij.indexing.shared.generator.IndexedFilesHashingTask;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterBasesLoaderKt;
import com.intellij.indexing.shared.generator.SharedIndexBase;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/intellij/indexing/shared/generator/IndexedFilesCollectorParameters;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "reporter", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/IndexedFilesCollectorParameters;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;)V", "collectAllFilesForIndexing", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectFilesForIndexing", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "fileContentLoader", "Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "findBaseWithMaxIntersection", "base", "indexes", "", "Lcom/intellij/indexing/shared/generator/SharedIndexBase;", "minFactor", "", "processBaseSharedIndexes", "files", "processDuplicateHashes", "intellij.indexing.shared.generator"})
public final class IndexedFilesCollector {
    private final Project project;
    private final IndexedFilesCollectorParameters parameters;
    private final ErrorsCollector errorsCollector;
    private final IndexedFilesReporter reporter;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashedIndexedFiles collectFilesForIndexing(@NotNull ProgressIndicator indicator, @NotNull IndexedFileContentLoader fileContentLoader) {
        HashedIndexedFiles indexesFiles;
        block2: {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)fileContentLoader, (String)"fileContentLoader");
            Instant startCollecting2 = Instant.now();
            Map<IndexableFilesIterator, Set<VirtualFile>> providerToFiles = this.collectAllFilesForIndexing(indicator);
            Duration timeCollecting = Duration.between(startCollecting2, Instant.now());
            Map<IndexableFilesIterator, Set<VirtualFile>> map2 = providerToFiles;
            StringBuilder stringBuilder = new StringBuilder().append("All files for indexing (");
            Logger logger = IndexedFilesCollectorKt.access$getLOG$p();
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var11_15 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var11_15.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                Integer n = ((Set)it.getValue()).size();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            logger.info(stringBuilder.append(CollectionsKt.sumOfInt((Iterable)collection)).append(" in ").append(providerToFiles.size()).append(" providers) ").append("have been collected in ").append(StringUtil.formatDuration((Duration)timeCollecting)).toString());
            Instant startFiltering = Instant.now();
            indexesFiles = new IndexedFilesHashingTask(this.project, this.parameters, fileContentLoader, this.errorsCollector).computeFileHashes(indicator, providerToFiles);
            Duration timeFiltering = Duration.between(startFiltering, Instant.now());
            IndexedFilesCollectorKt.access$getLOG$p().info("File filtering and content hashing have been finished in " + StringUtil.formatDuration((Duration)timeFiltering));
            boolean $i$f$measureTimeMillis = false;
            bl = false;
            long start$iv = System.currentTimeMillis();
            boolean bl3 = false;
            indexesFiles = this.processDuplicateHashes(indexesFiles, indicator);
            long duplicateHashesTime = System.currentTimeMillis() - start$iv;
            IndexedFilesCollectorKt.access$getLOG$p().info("Precessing of duplicate hashes took " + StringUtil.formatDuration((long)duplicateHashesTime));
            boolean $i$f$measureTimeMillis2 = false;
            boolean bl4 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl5 = false;
            indexesFiles = this.processBaseSharedIndexes(indexesFiles, indicator);
            long basesTime = System.currentTimeMillis() - start$iv2;
            IndexedFilesCollectorKt.access$getLOG$p().info("Precessing of base shared indexes took " + StringUtil.formatDuration((long)basesTime));
            IndexedFilesReporter indexedFilesReporter = this.reporter;
            if (indexedFilesReporter != null) {
                indexedFilesReporter.dumpEmptyFiles(indexesFiles, indicator);
            }
            IndexedFilesReporter indexedFilesReporter2 = this.reporter;
            if (indexedFilesReporter2 == null) break block2;
            indexedFilesReporter2.dumpFilesForIndex(this.project, indexesFiles, indicator);
        }
        return indexesFiles;
    }

    /*
     * WARNING - void declaration
     */
    private final HashedIndexedFiles processDuplicateHashes(HashedIndexedFiles files, ProgressIndicator indicator) {
        void $this$filterKeys$iv;
        Map<VirtualFile, IndexedFileHash> $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Map hashToFiles;
        Object object;
        Object element$iv$iv$iv2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object2;
        Object object3;
        Object answer$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        if (this.reporter == null && !this.parameters.getExcludeFilesWithHashCollision()) {
            return files;
        }
        Object $this$groupBy$iv = files.getHashes().entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object4;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-IndexedFilesCollector$processDuplicateHashes$hashToFiles$32 = false;
            key$iv$iv = (IndexedFileHash)it2.getValue();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            Map.Entry $i$a$-groupBy-IndexedFilesCollector$processDuplicateHashes$hashToFiles$32 = (Map.Entry)element$iv$iv;
            object3 = list$iv$iv;
            boolean bl = false;
            object2 = (VirtualFile)it.getKey();
            object3.add(object2);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv2;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv2;
            object2 = k;
            object3 = $this$getOrPut$iv$iv$iv;
            boolean bl2 = false;
            object = CollectionsKt.toHashSet((Iterable)((Iterable)it.getValue()));
            object3.put(object2, object);
        }
        Map $this$filter$iv = hashToFiles = destination$iv$iv;
        boolean $i$f$filter22 = false;
        destination$iv$iv = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void $i$f$associateByTo22 = $this$filterTo$iv$iv;
        boolean list$iv$iv = false;
        element$iv$iv$iv2 = $i$f$associateByTo22.entrySet().iterator();
        while (element$iv$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = (Map.Entry)element$iv$iv$iv2.next();
            boolean bl = false;
            if (!(((HashSet)it.getValue()).size() >= 2)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filesToSkip = destination$iv$iv2;
        Iterable $i$f$filter22 = filesToSkip.values();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            HashSet it = (HashSet)element$iv;
            boolean bl = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet ignoredFiles = (HashSet)destination$iv;
        IndexedFilesReporter indexedFilesReporter = this.reporter;
        if (indexedFilesReporter != null) {
            indexedFilesReporter.dumpHashCollisionFiles(filesToSkip, indicator);
        }
        IndexedFilesCollectorKt.access$getLOG$p().info("Found " + ignoredFiles.size() + " files with same hashes using " + filesToSkip.size() + " unique hashes");
        if (!this.parameters.getExcludeFilesWithHashCollision()) {
            return files;
        }
        $this$flatMapTo$iv = files.getHashes();
        object = files.getByProvider();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        iterator = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : iterator.entrySet()) {
            VirtualFile it = (VirtualFile)entry$iv.getKey();
            boolean bl3 = false;
            if (!(!ignoredFiles.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map2 = result$iv;
        List<SharedIndexContentHash> list = files.getUsedHashes();
        List<SharedIndexBase> list2 = files.getUsedBases();
        Map map3 = map2;
        Object object5 = object;
        return new HashedIndexedFiles((Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>>)object5, map3, list2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final HashedIndexedFiles processBaseSharedIndexes(HashedIndexedFiles files, ProgressIndicator indicator) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$filterTo$iv$iv;
            void $this$sortedByDescending$iv;
            Iterable $this$distinctBy$iv;
            void $this$mapNotNullTo$iv$iv;
            IndexExporterBases indexExporterBases;
            boolean bl = false;
            if (this.parameters.getBases() == null) {
                HashedIndexedFiles hashedIndexedFiles = files;
                return hashedIndexedFiles;
            }
            IndexExporterBases baseIndexes = indexExporterBases;
            if (baseIndexes.getBaseIndexes().isEmpty()) {
                HashedIndexedFiles hashedIndexedFiles = files;
                return hashedIndexedFiles;
            }
            indicator.setIndeterminate(true);
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.processing.base.shared.indexes", (Object[])new Object[0]));
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"SharedIndexInfrastructureVersion.getIdeVersion()");
            SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
            Object var9_11 = null;
            Lazy allHashes2 = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends IndexedFileHash>>(this, files, indicator){
                final /* synthetic */ IndexedFilesCollector this$0;
                final /* synthetic */ HashedIndexedFiles $files$inlined;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                {
                    this.this$0 = indexedFilesCollector;
                    this.$files$inlined = hashedIndexedFiles;
                    this.$indicator$inlined = progressIndicator;
                    super(0);
                }

                @NotNull
                public final Set<IndexedFileHash> invoke() {
                    return this.$files$inlined.getAllHashes();
                }
            }));
            Iterable $this$mapNotNull$iv = baseIndexes.getBaseIndexes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SharedIndexBase sharedIndexBase;
                block27: {
                    Object object;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    IndexExporterBase it = (IndexExporterBase)element$iv$iv;
                    boolean bl3 = false;
                    try {
                        object = IndexesExporterBasesLoaderKt.loadSharedIndexAsBase(it.getPath(), ideVersion, this.parameters.getTempDir());
                    }
                    catch (Throwable t) {
                        IndexedFilesCollectorKt.access$getLOG$p().warn("Failed to load base shared index: " + it.getPath() + ". " + t.getMessage(), t);
                        sharedIndexBase = null;
                        break block27;
                    }
                    SharedIndexBase index = object;
                    object = index.getMetadata().getSharedIndexInfo().getBases();
                    boolean bl4 = false;
                    if (!object.isEmpty()) {
                        object = "The shared index (" + it.getPath() + ") with bases is not yet supported as the base";
                        bl4 = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    SharedIndexInfrastructureVersion indexMetadata = index.getMetadata().getIndexInfrastructureVersion();
                    if (Intrinsics.areEqual((Object)indexMetadata.getBaseIndexes(), (Object)ideVersion.getBaseIndexes()) ^ true) {
                        IndexedFilesCollectorKt.access$getLOG$p().warn("Incompatible base metadata from " + it.getPath() + ": Base Version differs");
                        sharedIndexBase = null;
                    } else if (!ideVersion.getFileBasedIndexVersions().entrySet().containsAll(indexMetadata.getFileBasedIndexVersions().entrySet())) {
                        IndexedFilesCollectorKt.access$getLOG$p().warn("Incompatible base metadata from " + it.getPath() + ": File based index versions differs");
                        sharedIndexBase = null;
                    } else if (!ideVersion.getStubIndexVersions().entrySet().containsAll(indexMetadata.getStubIndexVersions().entrySet())) {
                        IndexedFilesCollectorKt.access$getLOG$p().warn("Incompatible base metadata from " + it.getPath() + ": Stub index versions differs");
                        sharedIndexBase = null;
                    } else if (!ideVersion.getStubFileElementTypeVersions().entrySet().containsAll(indexMetadata.getStubFileElementTypeVersions().entrySet())) {
                        IndexedFilesCollectorKt.access$getLOG$p().warn("Incompatible base metadata from " + it.getPath() + ": Stub element versions differs");
                        sharedIndexBase = null;
                    } else {
                        Set set = ideVersion.getCompositeBinaryStubFileBuilderVersions().entrySet();
                        Set set2 = indexMetadata.getCompositeBinaryStubFileBuilderVersions().entrySet();
                        Intrinsics.checkNotNullExpressionValue(set2, (String)"indexMetadata.compositeB\u2026leBuilderVersions.entries");
                        if (!set.containsAll(set2)) {
                            IndexedFilesCollectorKt.access$getLOG$p().warn("Incompatible base metadata from " + it.getPath() + ": composite binary stub file builder versions differ");
                            sharedIndexBase = null;
                        } else {
                            IndexedFilesCollectorKt.access$getLOG$p().info("Loaded base shared index: " + index);
                            sharedIndexBase = index;
                        }
                    }
                }
                if (sharedIndexBase == null) continue;
                SharedIndexBase sharedIndexBase2 = sharedIndexBase;
                boolean bl5 = false;
                boolean bl6 = false;
                SharedIndexBase it$iv$iv = sharedIndexBase2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv22 = new HashSet<String>();
            Iterable<Object> list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                SharedIndexBase it = (SharedIndexBase)e$iv;
                boolean bl8 = false;
                String key$iv = it.getSharedIndexSha256();
                if (!set$iv22.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$sortedByDescending = false;
            boolean set$iv22 = false;
            List rawBaseIndexes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    SharedIndexBase it = (SharedIndexBase)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getSharedIndexSize());
                    it = (SharedIndexBase)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getSharedIndexSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
            if (rawBaseIndexes.isEmpty()) {
                HashedIndexedFiles hashedIndexedFiles = files;
                return hashedIndexedFiles;
            }
            IndexedFilesCollectorKt.access$getLOG$p().info("Resolved " + rawBaseIndexes.size() + " base shared indexes");
            Iterable $this$filter$iv = rawBaseIndexes;
            boolean $i$f$filter = false;
            list$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean result;
                SharedIndexBase base = (SharedIndexBase)element$iv$iv;
                boolean bl9 = false;
                Lazy bl2 = allHashes2;
                Object var22_33 = null;
                Object var23_35 = var9_11;
                boolean bl10 = false;
                double ratio = base.matchedIndexesRatio((Set)bl2.getValue());
                boolean bl11 = result = ratio >= baseIndexes.getMinimalBaseIndexHashesIntersectionRatio();
                if (!result) {
                    IndexedFilesCollectorKt.access$getLOG$p().info("Shared index " + base + " has only " + (int)(ratio * (double)100) + "% of common hashes. Ignored");
                }
                if (!result) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List baseIndexesToConsider = (List)destination$iv$iv2;
            HashedIndexedFiles nextGreedy = files;
            while (true) {
                if (this.findBaseWithMaxIntersection(nextGreedy, baseIndexesToConsider, baseIndexes.getMaximalUnknownHashesAfterIntersectionRatio()) != null) continue;
                break;
            }
            IndexedFilesCollectorKt.access$getLOG$p().info("Using " + nextGreedy.getUsedBases() + " as base");
            HashedIndexedFiles hashedIndexedFiles = nextGreedy;
            return hashedIndexedFiles;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final HashedIndexedFiles findBaseWithMaxIntersection(HashedIndexedFiles base, List<SharedIndexBase> indexes, double minFactor) {
        void nextBase;
        Object v0;
        void $this$minByOrNull$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SharedIndexBase it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<IndexedFileHash> allHashes2 = base.getAllHashes();
        Iterable iterable = indexes;
        boolean $i$f$filter = false;
        void var12_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SharedIndexBase)element$iv$iv;
            boolean bl = false;
            if (!(!base.getUsedBases().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SharedIndexBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)((double)it.keepOnlyUnknownHashes((Collection<IndexedFileHash>)allHashes2).size() / (double)allHashes2.size()));
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair $dstr$_u24__u24$intersection = (Pair)element$iv$iv;
            boolean bl = false;
            double intersection = ((Number)$dstr$_u24__u24$intersection.component2()).doubleValue();
            if (!(intersection <= minFactor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                double intersection;
                Pair $dstr$_u24__u24$intersection = (Pair)minElem$iv;
                boolean bl = false;
                double minValue$iv = intersection = ((Number)$dstr$_u24__u24$intersection.component2()).doubleValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair $dstr$_u24__u24$intersection2 = (Pair)e$iv;
                    $i$a$-minByOrNull-IndexedFilesCollector$findBaseWithMaxIntersection$4 = false;
                    double intersection2 = ((Number)$dstr$_u24__u24$intersection2.component2()).doubleValue();
                    double v$iv = intersection2;
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Pair pair = v0;
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        SharedIndexBase sharedIndexBase = (SharedIndexBase)pair2.component1();
        double score = ((Number)pair2.component2()).doubleValue();
        IndexedFilesCollectorKt.access$getLOG$p().info("Using the next base with intersection score " + (int)(score * (double)100) + "%: " + nextBase);
        return new HashedIndexedFiles(base.getByProvider(), nextBase.keepOnlyUnknownHashes(base.getHashes()), CollectionsKt.plus((Collection)base.getUsedBases(), (Object)nextBase), base.getUsedHashes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<IndexableFilesIterator, Set<VirtualFile>> collectAllFilesForIndexing(ProgressIndicator indicator) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(true);
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.collecting.files.to.index", (Object[])new Object[0]));
            boolean bl2 = false;
            HashMap providerToFiles = new HashMap();
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            Intrinsics.checkNotNullExpressionValue((Object)indexableFilesDeduplicateFilter, (String)"IndexableFilesDeduplicateFilter.create()");
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter2 = indexableFilesDeduplicateFilter;
            List<IndexableFilesIterator> roots = this.parameters.getIndexableFilesIterators();
            for (IndexableFilesIterator root : roots) {
                indicator.setText2(root.getRootsScanningProgressText());
                boolean bl3 = false;
                HashSet providerFiles = new HashSet();
                root.iterateFiles(this.project, new ContentIterator(providerFiles){
                    final /* synthetic */ HashSet $providerFiles;

                    public final boolean processFile(@NotNull VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (!file.isDirectory()) {
                            Collection collection = this.$providerFiles;
                            boolean bl = false;
                            collection.add(file);
                        }
                        return true;
                    }
                    {
                        this.$providerFiles = hashSet;
                    }
                }, (VirtualFileFilter)indexableFilesDeduplicateFilter2);
                ((Map)providerToFiles).put(root, providerFiles);
            }
            Map map2 = providerToFiles;
            return map2;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    public IndexedFilesCollector(@NotNull Project project2, @NotNull IndexedFilesCollectorParameters parameters, @NotNull ErrorsCollector errorsCollector, @Nullable IndexedFilesReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.project = project2;
        this.parameters = parameters;
        this.errorsCollector = errorsCollector;
        this.reporter = reporter;
    }
}

