/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Base64;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "", "hash", "", "generatedHashes", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "([BLjava/util/Map;)V", "cachedHashCode", "", "getHash", "()[B", "equals", "", "other", "provider", "hashCode", "toBase64String", "", "toHexString", "toString", "intellij.indexing.shared.generator"})
public final class IndexedFileHash {
    private int cachedHashCode;
    @NotNull
    private final byte[] hash;
    private final Map<SharedIndexContentHash, byte[]> generatedHashes;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedFileHash) || this.hash.length != ((IndexedFileHash)other).hash.length) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        byte[] byArray = this.hash;
        byte[] byArray2 = ((IndexedFileHash)other).hash;
        boolean bl = false;
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        int cachedHashCode = this.cachedHashCode;
        if (cachedHashCode != 0) {
            return cachedHashCode;
        }
        byte[] byArray = this.hash;
        boolean bl = false;
        int newHash = Arrays.hashCode(byArray);
        if (newHash == 0) {
            newHash = -37446935;
        }
        this.cachedHashCode = newHash;
        return newHash;
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default((byte[])this.hash, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String toHexString() {
        String string = StringUtil.toHexString((byte[])this.hash);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toHexString(hash)");
        return string;
    }

    @NotNull
    public final String toBase64String() {
        String string = Base64.encode((byte[])this.hash);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encode(hash)");
        return string;
    }

    @Nullable
    public final byte[] hash(@NotNull SharedIndexContentHash provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return this.generatedHashes.get(provider);
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    public IndexedFileHash(@NotNull byte[] hash2, @NotNull Map<SharedIndexContentHash, byte[]> generatedHashes) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter(generatedHashes, (String)"generatedHashes");
        this.hash = hash2;
        this.generatedHashes = generatedHashes;
    }

    public /* synthetic */ IndexedFileHash(byte[] byArray, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        this(byArray, map2);
    }
}

