/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSBranchInstruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UnreachableCodeJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unreachable.code.error.string", new Object[0]);
        if (string == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isUnreachableInstruction(@NotNull Instruction instruction) {
        Collection instructions;
        if (instruction == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(1);
        }
        if ((instructions = instruction.allPred()).isEmpty()) {
            return true;
        }
        if (instruction instanceof JSBranchInstruction) {
            return false;
        }
        return instructions.stream().allMatch(el -> el instanceof JSBranchInstruction && !((JSBranchInstruction)el).isReachable());
    }

    private static boolean isFirstInstruction(Instruction instruction) {
        return instruction.num() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFile(JSFile file2) {
            this.visitExecutionScope(file2);
            super.visitJSFile(file2);
        }

        @Override
        public void visitJSElement(JSElement node) {
            if (node instanceof JSExecutionScope) {
                this.visitExecutionScope((JSExecutionScope)node);
            }
            super.visitJSElement(node);
        }

        private void visitExecutionScope(@NotNull JSExecutionScope node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            JSControlFlowService.JSControlFlow flow = JSControlFlowService.getService(node.getProject()).getControlFlow(node);
            Instruction[] instructions = flow.getInstructions();
            ArrayList unreachable = new ArrayList();
            ArrayList unreachableVariables = new ArrayList();
            if (instructions.length > 0) {
                ControlFlowUtil.iteratePrev((int)(instructions.length - 1), (Instruction[])instructions, instruction -> {
                    if (!UnreachableCodeJSInspection.isFirstInstruction(instruction) && UnreachableCodeJSInspection.isUnreachableInstruction(instruction)) {
                        PsiElement element = instruction.getElement();
                        if (element instanceof JSSourceElement && !(element instanceof JSFunction)) {
                            unreachable.add((JSSourceElement)element);
                        } else if (element instanceof JSVariable && !(element instanceof JSParameter) && !(element instanceof JSField)) {
                            unreachableVariables.add((JSVariable)element);
                        }
                    }
                    return ControlFlowUtil.Operation.NEXT;
                });
            }
            unreachable.forEach(el -> {
                if (el instanceof JSBlockStatement) {
                    JSSourceElement[] statements = ((JSBlockStatement)el).getStatementListItems();
                    for (int i2 = statements.length - 1; i2 >= 0; --i2) {
                        JSSourceElement statement = statements[i2];
                        if (statement instanceof JSFunction) continue;
                        this.registerStatementError(statements[0], new Object[0]);
                        return;
                    }
                }
                if (el.getTextLength() == 0) {
                    return;
                }
                this.registerStatementError((JSSourceElement)el, new Object[0]);
            });
            unreachableVariables.forEach(el -> {
                for (JSSourceElement element : unreachable) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)el, (boolean)true)) continue;
                    return;
                }
                ASTNode eq = el.getNode().findChildByType(JSTokenTypes.EQ);
                if (eq != null) {
                    this.registerError(eq.getPsi());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection$Visitor", "visitExecutionScope"));
        }
    }
}

