/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class FunctionWithMultipleReturnPointsJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        int returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function2);
        if (FunctionWithMultipleReturnPointsJSInspection.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("function.contains.multiple.return.points.error.string", returnPointCount);
            if (string == null) {
                FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.contains.multiple.return.points.error.string", returnPointCount);
        if (string == null) {
            FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static int countReturnPoints(JSFunction function2) {
        PsiElement lastChild = function2.getLastChild();
        if (!(lastChild instanceof JSBlockStatement)) {
            return 0;
        }
        boolean hasFallthroughReturn = false;
        if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            hasFallthroughReturn = true;
        }
        ReturnCountVisitor visitor = new ReturnCountVisitor();
        lastChild.accept((PsiElementVisitor)visitor);
        int returnCount = visitor.getReturnCount();
        if (hasFallthroughReturn) {
            return returnCount + 1;
        }
        return returnCount;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection", "buildErrorString"));
    }

    private static class ReturnCountVisitor
    extends JSRecursiveElementVisitor {
        private int returnCount = 0;

        private ReturnCountVisitor() {
        }

        @Override
        public void visitJSElement(JSElement jsElement) {
            int oldCount = 0;
            if (jsElement instanceof JSFunction) {
                oldCount = this.returnCount;
            }
            super.visitJSElement(jsElement);
            if (jsElement instanceof JSFunction) {
                this.returnCount = oldCount;
            }
        }

        @Override
        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            ++this.returnCount;
        }

        public int getReturnCount() {
            return this.returnCount;
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            int returnPointCount;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function2)) <= 1) {
                return;
            }
            this.registerFunctionError(function2);
        }

        @Override
        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

