/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ExceptionCaughtLocallyJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("exception.caught.locally.error.string", new Object[0]);
        if (string == null) {
            ExceptionCaughtLocallyJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean isCaughtLocally(@NotNull JSElement throwStatement) {
        if (throwStatement == null) {
            ExceptionCaughtLocallyJSInspection.$$$reportNull$$$0(1);
        }
        JSElement currentElement = throwStatement;
        JSSourceElement element;
        while (!((element = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, (Class[])new Class[]{JSTryStatement.class, JSFunction.class})) instanceof JSFunction)) {
            JSStatement tryBlock;
            JSTryStatement tryStatement = (JSTryStatement)element;
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getCatchBlock() != null && (tryBlock = tryStatement.getStatement()) != null && PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCaughtLocally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSThrowStatement(@NotNull JSThrowStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSThrowStatement(statement);
            if (!ExceptionCaughtLocallyJSInspection.isCaughtLocally(statement)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        @Override
        public void visitJSThrowExpression(JSThrowExpression node) {
            super.visitJSThrowExpression(node);
            if (!ExceptionCaughtLocallyJSInspection.isCaughtLocally(node)) {
                return;
            }
            this.registerError((PsiElement)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection$Visitor", "visitJSThrowStatement"));
        }
    }
}

