/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ConfusingPlusesOrMinusesJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("confusing.pluses.or.minuses.error.string", new Object[0]);
        if (string == null) {
            ConfusingPlusesOrMinusesJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/ConfusingPlusesOrMinusesJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSBinaryExpression(JSBinaryExpression jsBinaryExpression) {
            JSExpressionWithOperationNode postfixExpression;
            IElementType innerSign;
            super.visitJSBinaryExpression(jsBinaryExpression);
            IElementType sign = jsBinaryExpression.getOperationSign();
            if (!JSTokenTypes.PLUS.equals(sign) && !JSTokenTypes.MINUS.equals(sign)) {
                return;
            }
            JSExpression rhs = jsBinaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            JSExpression lhs = jsBinaryExpression.getLOperand();
            if (lhs == null) {
                return;
            }
            if (lhs instanceof JSPostfixExpression && Visitor.matches(sign, innerSign = (postfixExpression = (JSPostfixExpression)lhs).getOperationSign())) {
                this.registerError((PsiElement)jsBinaryExpression);
                return;
            }
            if (rhs instanceof JSPrefixExpression && Visitor.matches(sign, innerSign = (postfixExpression = (JSPrefixExpression)rhs).getOperationSign())) {
                this.registerError((PsiElement)jsBinaryExpression);
            }
        }

        private static boolean matches(IElementType sign, IElementType innerSign) {
            if (JSTokenTypes.PLUS.equals(sign)) {
                return JSTokenTypes.PLUSPLUS.equals(innerSign);
            }
            return JSTokenTypes.MINUSMINUS.equals(innerSign);
        }
    }
}

