/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.JSConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigServiceImpl
implements TypeScriptConfigService,
JSConfigService {
    public static final VirtualFile NO_CONFIG = new StubVirtualFile();
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<List<VirtualFile>> myTypeScriptConfigs;
    @NotNull
    private final CachedValue<ConcurrentIntObjectMap<ConcurrentIntObjectMap<Boolean>>> myFilesMappings;
    private final SimpleModificationTracker myVirtualConfigFilesTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    @NotNull
    private final TypeScriptConfigGraphCache myConfigGraphCache;
    private final Collection<TypeScriptConfigsChangedListener> myListeners;
    @NotNull
    private final PsiManager myManager;
    private final TypeScriptLibraryProvider myLibraryProvider;
    private final CachedValue<ConcurrentIntObjectMap<VirtualFile>> myFileToConfig;

    public TypeScriptConfigServiceImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(0);
        }
        this.myVirtualConfigFilesTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = (TypeScriptConfigLibraryUpdater)project.getService(TypeScriptConfigLibraryUpdater.class);
        this.myConfigGraphCache = TypeScriptConfigGraphCache.getService(project);
        this.myManager = PsiManager.getInstance((Project)project);
        this.myLibraryProvider = TypeScriptLibraryProvider.getService(project);
        this.myTypeScriptConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new TypeScriptCachedConfigsProvider(), false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.getInstance()}), false);
        this.myFileToConfig = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.getInstance()}), false);
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope, @NotNull VirtualFile referenced) {
        int refId;
        Boolean value;
        ConcurrentIntObjectMap prevValue;
        int scopeId;
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(1);
        }
        if (referenced == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        if (!(scope instanceof VirtualFileWithId) || !(referenced instanceof VirtualFileWithId)) {
            return this.isAccessibleImpl(scope, referenced);
        }
        ConcurrentIntObjectMap filesRefsMap = (ConcurrentIntObjectMap)this.myFilesMappings.getValue();
        ConcurrentIntObjectMap scopeFileMap = (ConcurrentIntObjectMap)filesRefsMap.get(scopeId = ((VirtualFileWithId)scope).getId());
        if (scopeFileMap == null && (prevValue = (ConcurrentIntObjectMap)filesRefsMap.putIfAbsent(scopeId, (Object)(scopeFileMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap()))) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(refId = ((VirtualFileWithId)referenced).getId())) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(refId, (Object)value);
        }
        return value;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(4);
            }
            return condition;
        }
        TypeScriptConfigService.IntPredicate filterId = this.getFilterId(scope);
        Condition condition = candidate -> filterId.contains(TypeScriptImportGraph.getFileId(candidate));
        if (condition == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @Override
    @NotNull
    public TypeScriptConfigService.IntPredicate getFilterId(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> false;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(7);
            }
            return intPredicate;
        }
        int currentFileId = TypeScriptImportGraph.getFileId(scope);
        IntSet ids = this.myLibraryProvider.getLibrariesIds(true);
        if (ids.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((IntSet)ids).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(8);
            }
            return intPredicate;
        }
        IntSet customIds = this.myLibraryProvider.getLibrariesIds(false);
        if (customIds.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((IntSet)customIds).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(9);
            }
            return intPredicate;
        }
        IntSet libraries = this.myLibraryProvider.getEffectiveLibrariesIds();
        TypeScriptImportGraph preferableGraph = this.getPreferableIncludeParentGraph(scope);
        if (preferableGraph == null) {
            TypeScriptConfigService.IntPredicate typingsScope = TypeScriptExternalDefinitionsRegistry.Companion.getTypingsScope(scope);
            if (typingsScope != null) {
                TypeScriptConfigService.IntPredicate intPredicate = typingsScope;
                if (intPredicate == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(10);
                }
                return intPredicate;
            }
            if (NodeModuleUtil.hasNodeModulesDirInPath(scope, null) || ProjectScope.getLibrariesScope((Project)this.myProject).accept(scope)) {
                TypeScriptConfigService.IntPredicate intPredicate = el -> true;
                if (intPredicate == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(11);
                }
                return intPredicate;
            }
            preferableGraph = this.myConfigGraphCache.getGraph(scope);
        }
        TypeScriptImportGraph graph = preferableGraph;
        graph.initialize();
        TypeScriptConfigService.IntPredicate intPredicate = id -> libraries.contains(id) || graph.containsId(id);
        if (intPredicate == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(12);
        }
        return intPredicate;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(14);
        }
        return this.getAccessScope(scope).value((Object)file2);
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableConfig(@Nullable VirtualFile scopeFile) {
        int id;
        if (scopeFile == null || !scopeFile.isValid()) {
            return null;
        }
        ConcurrentIntObjectMap map = (ConcurrentIntObjectMap)this.myFileToConfig.getValue();
        VirtualFile file2 = (VirtualFile)map.get(id = TypeScriptImportGraph.getFileId(scopeFile));
        if (file2 != null) {
            return file2 == NO_CONFIG ? null : this.parseConfigFile(file2);
        }
        TypeScriptConfig impl = this.getPreferableConfigImpl(scopeFile);
        map.put(id, (Object)(impl == null ? NO_CONFIG : impl.getConfigFile()));
        return impl;
    }

    @Nullable
    private TypeScriptConfig getPreferableConfigImpl(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(15);
        }
        Collection<? extends VirtualFile> preferableConfigs = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false);
        while (!preferableConfigs.isEmpty()) {
            ProgressManager.checkCanceled();
            for (VirtualFile virtualFile : preferableConfigs) {
                TypeScriptConfig el = this.parseConfigFile(virtualFile);
                if (el == null || !this.configGraphIncludesFile(scopeFile, el)) continue;
                return el;
            }
            VirtualFile anyConfig = (VirtualFile)ContainerUtil.getFirstItem(preferableConfigs);
            preferableConfigs = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(anyConfig.getParent(), false);
        }
        return null;
    }

    @Override
    public boolean configGraphIncludesFile(@NotNull VirtualFile file2, @NotNull TypeScriptConfig tsConfig) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(16);
        }
        if (tsConfig == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(17);
        }
        return this.myConfigGraphCache.isConfigInclude(file2, tsConfig);
    }

    @Nullable
    private TypeScriptImportGraph getPreferableIncludeParentGraph(@NotNull VirtualFile scopeFile) {
        TypeScriptConfig config2;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(18);
        }
        return (config2 = this.getPreferableConfig(scopeFile)) != null ? this.getIncludeGraph(scopeFile, config2) : null;
    }

    @Nullable
    private TypeScriptImportGraph getIncludeGraph(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config2) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(19);
        }
        if (config2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(20);
        }
        TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(config2);
        graph.initialize(true);
        return TypeScriptConfigServiceImpl.isGraphIncludeFile(graph, scopeFile) ? graph : null;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableJSConfig(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptConfig tsConfig = this.getPreferableConfig(scopeFile);
        if (tsConfig != null) {
            return tsConfig;
        }
        VirtualFile parent = TypeScriptConfigUtil.getParentConfigWithName(scopeFile, "jsconfig.json");
        TypeScriptConfig config2 = this.parseConfigFile(parent);
        if (config2 == null) {
            return null;
        }
        TypeScriptFileImports structure = config2.getConfigImportResolveStructure();
        return structure.includesInPattern(scopeFile) ? config2 : null;
    }

    private static boolean isGraphIncludeFile(@NotNull TypeScriptImportGraph el, @NotNull VirtualFile scopeFile) {
        if (el == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(22);
        }
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(23);
        }
        return el.containsFile(scopeFile);
    }

    @Override
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener listener2) {
        if (listener2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(24);
        }
        this.myListeners.add(listener2);
    }

    @Override
    @Nullable
    public TypeScriptConfig parseConfigFile(@Nullable VirtualFile file2) {
        return TypeScriptConfigBase.parseAndCacheConfig(file2, this.myManager);
    }

    @Override
    @NotNull
    public ModificationTracker getConfigTracker(@Nullable VirtualFile file2) {
        if (file2 == null) {
            SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
            if (simpleModificationTracker == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(25);
            }
            return simpleModificationTracker;
        }
        TypeScriptConfig config2 = this.getPreferableConfig(file2);
        if (config2 == null) {
            SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
            if (simpleModificationTracker == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(26);
            }
            return simpleModificationTracker;
        }
        Collection<VirtualFile> dependencies = config2.getDependencies();
        ModificationTracker modificationTracker = () -> {
            long result2 = this.myVirtualConfigFilesTracker.getModificationCount();
            for (VirtualFile dependency : dependencies) {
                result2 += dependency.getModificationCount();
            }
            return result2;
        };
        if (modificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(27);
        }
        return modificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
        if (simpleModificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(28);
        }
        return simpleModificationTracker;
    }

    @Override
    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull VirtualFile topDirectory) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(30);
        }
        if (topDirectory == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(31);
        }
        if (NodeModuleUtil.isTypesDir(topDirectory)) {
            return true;
        }
        PsiFile psiFile = this.myManager.findFile(file2);
        if (!(psiFile instanceof JSFile) || ((JSFile)psiFile).isCommonJSModule()) {
            return true;
        }
        VirtualFile result2 = JSExactFileReference.resolveForNpmPackages(topDirectory, (NodeModuleDirectorySearchProcessor)TypeScriptNodeReference.TS_PROCESSOR);
        return file2.equals(result2);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(32);
        }
        TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(file2);
        Collection collection = graph.getNodes();
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<VirtualFile> getConfigFiles() {
        List list2 = (List)this.myTypeScriptConfigs.getValue();
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableOrParentConfig(@Nullable VirtualFile scopeFile) {
        if (scopeFile == null) {
            return null;
        }
        TypeScriptConfig configForFile = this.getPreferableConfig(scopeFile);
        if (configForFile == null) {
            return this.parseConfigFile((VirtualFile)ContainerUtil.getFirstItem(TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false)));
        }
        return configForFile;
    }

    @Override
    @Nullable
    public TypeScriptConfig getDirectIncludePreferableConfig(@Nullable VirtualFile scopeFile) {
        if (scopeFile == null) {
            return null;
        }
        Collection<? extends VirtualFile> configFiles = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false);
        for (VirtualFile virtualFile : configFiles) {
            TypeScriptConfig config2 = this.parseConfigFile(virtualFile);
            if (config2 == null || !config2.getInclude().accept(scopeFile)) continue;
            return config2;
        }
        return null;
    }

    @Override
    @NotNull
    public List<VirtualFile> getRootConfigFiles() {
        List<VirtualFile> list2 = Arrays.stream(ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).map(el -> TypeScriptConfigServiceImpl.getNearestParentTsConfigs(el, true)).flatMap(el -> el.stream()).collect(Collectors.toUnmodifiableList());
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @Override
    @NotNull
    public GlobalSearchScope createConfigScope(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(36);
        }
        final TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(config2);
        GlobalSearchScope scope = new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return graph.containsId(TypeScriptImportGraph.getFileId(file2));
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new GlobalSearchScopeWithIdFilter(scope, graph::containsId);
    }

    @NotNull
    public static Collection<? extends VirtualFile> getNearestParentTsConfigs(@Nullable VirtualFile fileOrDirectory, boolean checkCurrentDirectoryOnly) {
        if (fileOrDirectory == null || !fileOrDirectory.isValid()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(37);
            }
            return list2;
        }
        VirtualFile dirToCheck = !checkCurrentDirectoryOnly ? fileOrDirectory.getParent() : fileOrDirectory;
        Collection result2 = null;
        List matchers = FileTypeManagerEx.getInstanceEx().getAssociations((FileType)TypeScriptConfigFileType.INSTANCE);
        ArrayList<String> exactNames = new ArrayList<String>();
        ArrayList<FileNameMatcher> other = new ArrayList<FileNameMatcher>();
        for (FileNameMatcher matcher : matchers) {
            if (matcher instanceof ExactFileNameMatcher) {
                exactNames.add(((ExactFileNameMatcher)matcher).getFileName());
                continue;
            }
            other.add(matcher);
        }
        while (dirToCheck != null) {
            ProgressManager.checkCanceled();
            for (String name : exactNames) {
                VirtualFile candidate = dirToCheck.findChild(name);
                if (candidate == null) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(candidate);
            }
            if (!other.isEmpty()) {
                for (VirtualFile candidate : dirToCheck.getChildren()) {
                    if (candidate.isDirectory()) continue;
                    for (FileNameMatcher matcher : other) {
                        if (!matcher.acceptsCharSequence((CharSequence)candidate.getName())) continue;
                        if (result2 == null) {
                            result2 = new SmartList();
                        }
                        result2.add(candidate);
                    }
                }
            }
            if (result2 != null) {
                return TypeScriptConfigServiceImpl.sortAndGetConfigFiles(result2);
            }
            if (checkCurrentDirectoryOnly) {
                List list3 = Collections.emptyList();
                if (list3 == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(38);
                }
                return list3;
            }
            dirToCheck = dirToCheck.getParent();
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(39);
        }
        return list4;
    }

    public void afterUpdate(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(40);
        }
        this.myVirtualConfigFilesTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
        for (TypeScriptConfigsChangedListener listener2 : this.myListeners) {
            listener2.afterUpdate(configs);
        }
    }

    @NotNull
    private static List<VirtualFile> sortAndGetConfigFiles(@NotNull Collection<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(41);
        }
        List list2 = ((StreamEx)StreamEx.of(virtualFiles).sorted(Comparator.comparing(VirtualFile::getPath))).toList();
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(42);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 14: 
            case 16: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfig";
                break;
            }
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDirectory";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterId";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigTracker";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootConfigFiles";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestParentTsConfigs";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndGetConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessScope";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilterId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableConfigImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableIncludeParentGraph";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeGraph";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableJSConfig";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isGraphIncludeFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitIncludedNodeModulesFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createConfigScope";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdate";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sortAndGetConfigFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class CachedConfigsProvider
    implements CachedValueProvider<List<VirtualFile>> {
        private CachedConfigsProvider() {
        }

        @NotNull
        public final CachedValueProvider.Result<List<VirtualFile>> compute() {
            CachedValueProvider.Result result2 = (CachedValueProvider.Result)ReadAction.compute(() -> this.computeInReadAction());
            if (result2 == null) {
                CachedConfigsProvider.$$$reportNull$$$0(0);
            }
            return result2;
        }

        @NotNull
        protected CachedValueProvider.Result<List<VirtualFile>> computeInReadAction() {
            Collection<VirtualFile> virtualFiles = this.getFiles();
            HashSet<Object> depends = new HashSet<Object>(virtualFiles.size() + 2);
            depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            depends.add(ProjectRootModificationTracker.getInstance((Project)TypeScriptConfigServiceImpl.this.myProject));
            depends.addAll(virtualFiles);
            List<VirtualFile> files = TypeScriptConfigServiceImpl.sortAndGetConfigFiles(virtualFiles);
            if (DumbService.isDumb((Project)TypeScriptConfigServiceImpl.this.myProject)) {
                depends.add(ModificationTracker.EVER_CHANGED);
            }
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create(files, depends);
            if (result2 == null) {
                CachedConfigsProvider.$$$reportNull$$$0(1);
            }
            return result2;
        }

        @NotNull
        protected abstract Collection<VirtualFile> getFiles();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$CachedConfigsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInReadAction";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class TypeScriptCachedConfigsProvider
    extends CachedConfigsProvider {
        private TypeScriptCachedConfigsProvider() {
        }

        @Override
        @NotNull
        protected Collection<VirtualFile> getFiles() {
            Collection collection = FileTypeIndex.getFiles((FileType)TypeScriptConfigFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)TypeScriptConfigServiceImpl.this.myProject));
            if (collection == null) {
                TypeScriptCachedConfigsProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Override
        @NotNull
        protected CachedValueProvider.Result<List<VirtualFile>> computeInReadAction() {
            CachedValueProvider.Result<List<VirtualFile>> compute = super.computeInReadAction();
            TypeScriptConfigServiceImpl.this.afterUpdate((Collection)compute.getValue());
            CachedValueProvider.Result<List<VirtualFile>> result2 = compute;
            if (result2 == null) {
                TypeScriptCachedConfigsProvider.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$TypeScriptCachedConfigsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInReadAction";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

