/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAugmentationUtil {
    public static final Key<CachedValue<Map<PsiElement, Collection<PsiElement>>>> KEY = Key.create((String)"module.aug.non.filtered");

    @NotNull
    public static Collection<PsiElement> getModuleAugmentations(@NotNull PsiElement context, @NotNull PsiElement module) {
        PsiElement scopeElement;
        if (context == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(1);
        }
        if ((scopeElement = TypeScriptAugmentationUtil.calculateScopeElement(context)) == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Map value = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, KEY, () -> {
            Map<PsiElement, Collection<PsiElement>> map = TypeScriptAugmentationUtil.getModuleAugmentationsImpl(scopeElement);
            return CachedValueProvider.Result.create(map, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.getInstance()});
        });
        Collection collection = value.getOrDefault(module, Collections.emptyList());
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    private static PsiElement calculateScopeElement(@NotNull PsiElement context) {
        PsiFile file2;
        PsiFile file3;
        TypeScriptConfig candidate;
        if (context == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(4);
        }
        if ((candidate = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile(), true)) != null && (file3 = context.getManager().findFile(candidate.getConfigFile())) != null) {
            return file3;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        if (virtualFile == null) {
            return null;
        }
        if (DialectDetector.isTypeScript(context) && !JSLibraryUtil.hasDirectoryInPath(virtualFile, "node_modules", null)) {
            return context.getContainingFile();
        }
        VirtualFile packageJson = TypeScriptUtil.getPackageJsonOutsideNodeModules(virtualFile);
        if (packageJson != null && (file2 = context.getManager().findFile(packageJson)) != null) {
            return file2;
        }
        return context.getContainingFile();
    }

    @NotNull
    private static Map<PsiElement, Collection<PsiElement>> getModuleAugmentationsImpl(@NotNull PsiElement scopeElement) {
        Project project;
        Collection<TypeScriptModule> augmentationModules;
        if (scopeElement == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(5);
        }
        if ((augmentationModules = TypeScriptUtil.getAllAugmentationModules(project = scopeElement.getProject(), scopeElement)).isEmpty()) {
            Map<PsiElement, Collection<PsiElement>> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(6);
            }
            return map;
        }
        MultiMap result2 = MultiMap.create();
        for (TypeScriptModule augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation((PsiElement)augmentation);
            for (PsiElement resolvedModule : elements) {
                ProgressManager.checkCanceled();
                result2.putValue((Object)resolvedModule, (Object)augmentation);
            }
        }
        Map map = result2.freezeValues();
        if (map == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public static Collection<PsiElement> getAugmentations(@NotNull PsiElement context, @NotNull Collection<? extends PsiElement> modules2) {
        if (context == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(8);
        }
        if (modules2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(9);
        }
        if (modules2.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List augmentationModules = StreamEx.of(modules2).flatMap(el -> TypeScriptAugmentationUtil.getModuleAugmentations(context, el).stream()).toList();
        if (augmentationModules.isEmpty()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(11);
            }
            return list3;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            VirtualFile moduleFile = TypeScriptAugmentationUtil.getVirtualFile(augmentation);
            if (moduleFile == null) continue;
            result2.add(augmentation);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(13);
        }
        PsiFile file2 = element.getContainingFile();
        PsiFile originalFile = file2.getOriginalFile();
        return originalFile.getVirtualFile();
    }

    @NotNull
    public static Collection<PsiElement> resolveAugmentation(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(14);
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(module.getProject()).resolveDirectModules(module);
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public static boolean isExternalModuleAugmentation(@NotNull PsiElement candidate) {
        if (candidate == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(16);
        }
        if (!(candidate instanceof TypeScriptModule)) {
            return false;
        }
        TypeScriptModule module = (TypeScriptModule)candidate;
        if (!TypeScriptPsiUtil.isAmbientModule(module)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)module);
        if (container instanceof JSFile) {
            return ((JSFile)container).isCommonJSModule();
        }
        if (container instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
            JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
            return secondLevelParent != null && !ES6PsiUtil.isExternalModule((PsiElement)secondLevelParent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentationsImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugmentations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAugmentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentations";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateScopeElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentationsImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveAugmentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModuleAugmentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

