/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddAugmentationImportFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    @NotNull
    private final String myModuleName;

    public TypeScriptAddAugmentationImportFix(@NotNull PsiElement context, @NotNull @NlsSafe String moduleName) {
        if (context == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(1);
        }
        super(context);
        this.myModuleName = moduleName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        return TypeScriptAddAugmentationImportFix.getFixText(this.myModuleName);
    }

    @NotNull
    @IntentionName
    public static String getFixText(@NlsSafe String moduleName) {
        String string = JavaScriptBundle.message("intention.name.import.augmentation", moduleName);
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiFile externalModule;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(7);
        }
        if ((externalModule = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return;
        }
        PsiFile placePsiFile = startElement.getContainingFile();
        if (placePsiFile == null) {
            return;
        }
        String unquotedModuleName = TypeScriptAddAugmentationImportFix.getUnquotedModuleName(project, startElement, placePsiFile, externalModule);
        if (unquotedModuleName == null) {
            return;
        }
        JSAddImportExecutor executor = JSHandlersFactory.forElement(startElement).createAddImportExecutor(null, startElement);
        JSModuleDescriptor.SimpleModuleDescriptor module = new JSModuleDescriptor.SimpleModuleDescriptor((PsiElement)externalModule, unquotedModuleName);
        JSImportDescriptor descriptor2 = executor.createDescriptor(externalModule.getName(), null, module, ES6ImportPsiUtil.ImportExportType.BARE, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        executor.createImportOrUseExisting(descriptor2);
    }

    @Nullable
    private static String getUnquotedModuleName(@NotNull Project project, @NotNull PsiElement context, @NotNull PsiFile placePsiFile, @NotNull PsiFile augmentationModule) {
        String path2;
        VirtualFile moduleDirectory;
        VirtualFile directoryToCalcModuleName;
        VirtualFile dstFile;
        Pair<VirtualFile, VirtualFile> libraryDirectory;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(8);
        }
        if (context == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(9);
        }
        if (placePsiFile == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(10);
        }
        if (augmentationModule == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(11);
        }
        if ((libraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, dstFile = augmentationModule.getVirtualFile(), NodeModuleUtil.NODE_MODULES_ARRAY)) != null && (directoryToCalcModuleName = NodeModuleUtil.getDirectoryToCalcModuleNameInNodeModules(moduleDirectory = (VirtualFile)libraryDirectory.first)) != null && (path2 = VfsUtilCore.findRelativePath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/')) != null) {
            JSModuleNameInfoImpl info = new JSModuleNameInfoImpl(path2, dstFile, context);
            return info.getModuleName();
        }
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExactExternalFileModuleName((PsiElement)placePsiFile, dstFile);
        return moduleInfo == null ? null : moduleInfo.getModuleName();
    }

    public static String getImportedModuleName(@NotNull PsiElement startElement) {
        PsiFile module;
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(12);
        }
        if ((module = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return null;
        }
        String unquotedModuleName = TypeScriptAddAugmentationImportFix.getUnquotedModuleName(startElement.getProject(), startElement, startElement.getContainingFile(), module);
        if (unquotedModuleName == null) {
            return null;
        }
        PsiElement placeModule = ES6CreateImportUtil.getScopeToAdd(startElement, true);
        if (placeModule == null || module.getContainingFile().equals(placeModule)) {
            return null;
        }
        JSSimpleImportDescriptor descriptor2 = new JSSimpleImportDescriptor((PsiElement)module, unquotedModuleName, ES6ImportPsiUtil.BARE_INFO);
        if (ES6ImportPsiUtil.findExistingES6Import(placeModule, descriptor2) != null) {
            return null;
        }
        return JSCodeStyleSettings.wrapWithQuotes(startElement, unquotedModuleName);
    }

    @Nullable
    public static PsiFile getAugmentationModule(@NotNull PsiElement startElement) {
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(13);
        }
        if (!(startElement instanceof JSReferenceExpression)) {
            return null;
        }
        List<PsiElement> elements = JSResolveResult.toElements(((JSReferenceExpression)startElement).multiResolve(false));
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            PsiElement module = ES6PsiUtil.findExternalModule(item);
            if (!(module instanceof TypeScriptModule) || !((TypeScriptModule)module).isAugmentation()) {
                return null;
            }
            return module.getContainingFile();
        }
        if (elements.size() == 0) {
            String name = ((JSReferenceExpression)startElement).getReferenceName();
            if (name == null) {
                return null;
            }
            JSExpression qualifier = ((JSReferenceExpression)startElement).getQualifier();
            if (!TypeScriptUtil.isStrictResolveQualifier(qualifier)) {
                return null;
            }
            JSType type = JSResolveUtil.getExpressionJSType(qualifier);
            if (!(type instanceof JSTypeImpl)) {
                return null;
            }
            JSQualifiedName qualifiedName = ((JSTypeImpl)type).getQualifiedName();
            Collection<PsiElement> declarations = ((JSTypeImpl)type).getDeclarations();
            HashSet modules2 = new HashSet();
            for (PsiElement declaration : declarations) {
                ContainerUtil.addIfNotNull(modules2, (Object)ES6PsiUtil.findExternalModule(declaration));
            }
            if (modules2.isEmpty()) {
                return null;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)startElement);
            if (file2 == null) {
                return null;
            }
            final Condition<VirtualFile> scope = TypeScriptConfigService.Provider.get(startElement.getProject()).getAccessScope(file2);
            SmartList candidates = new SmartList();
            GlobalSearchScope preScope = TypeScriptUtil.createScopeWithFilterByNodeModules(startElement, startElement);
            DelegatingGlobalSearchScope searchScope = new DelegatingGlobalSearchScope(preScope){

                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!super.contains(file2)) {
                        return false;
                    }
                    return !scope.value((Object)file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix$1", "contains"));
                }
            };
            JSClassResolver.processElementsByNameIncludingImplicit(name, (GlobalSearchScope)searchScope, false, JSNonGlobalSymbolIndex.KEY, (Processor<? super JSPsiElementBase>)((Processor)arg_0 -> TypeScriptAddAugmentationImportFix.lambda$getAugmentationModule$0(qualifiedName, (Collection)candidates, arg_0)));
            for (JSPsiElementBase candidate : candidates) {
                Collection<PsiElement> resolvedElements;
                PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)candidate);
                if (!(module instanceof TypeScriptModule) || !((TypeScriptModule)module).isAugmentation() || !modules2.containsAll(resolvedElements = TypeScriptAugmentationUtil.resolveAugmentation(module))) continue;
                return candidate.getContainingFile();
            }
        }
        return null;
    }

    private static boolean isPrefixOfAugmentation(@NotNull JSQualifiedName parent, @Nullable JSQualifiedName element) {
        if (parent == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(14);
        }
        if (element == null) {
            return false;
        }
        while (parent != null) {
            if (!Objects.equals(parent.getName(), element.getName())) {
                return false;
            }
            parent = parent.getParent();
            if ((element = element.getParent()) != null || parent == null) continue;
            return false;
        }
        return element != null && element.getParent() == null;
    }

    private static /* synthetic */ boolean lambda$getAugmentationModule$0(JSQualifiedName qualifiedName, Collection candidates, JSPsiElementBase el) {
        if (TypeScriptAddAugmentationImportFix.isPrefixOfAugmentation(qualifiedName, el.getNamespace())) {
            candidates.add(el);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placePsiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "augmentationModule";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedModuleName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImportedModuleName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentationModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixOfAugmentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

