/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.lang.typescript.inspection.TypescriptRemoveTypeDeclarationQuickFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExplicitMemberTypeInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public static final String SHORT_NAME = "TypeScriptExplicitMemberType";

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(TypeScriptExplicitMemberTypeInspection.createSettingsLink());
        return panel2;
    }

    private static JComponent createSettingsLink() {
        final HyperlinkLabel settingsLink = new HyperlinkLabel(JavaScriptBundle.message("js.generated.types.settings.link", new Object[0]));
        settingsLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)settingsLink);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                Settings settings = (Settings)Settings.KEY.getData(dataContext);
                if (settings == null) {
                    return;
                }
                Configurable colorSchemeConfigurable = settings.find(CodeStyleConfigurableWrapper.getConfigurableId((String)JavaScriptBundle.message("typescript.code.style.tab.name", new Object[0])));
                if (colorSchemeConfigurable instanceof CodeStyleConfigurableWrapper) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        settings.select(colorSchemeConfigurable);
                        ((CodeStyleConfigurableWrapper)colorSchemeConfigurable).selectTab(ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]));
                    });
                }
            }
        });
        return settingsLink;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(1);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)holder.getFile());
        final TypeScriptCodeStyleSettings tsSettings = (TypeScriptCodeStyleSettings)settings.getCustomSettings(TypeScriptCodeStyleSettings.class);
        return new JSElementVisitor(){

            @Override
            public void visitJSDestructuringElement(JSDestructuringElement destructuringElement) {
                this.visitNode(destructuringElement, (PsiElement)destructuringElement.getTarget(), tsSettings.PREFER_EXPLICIT_TYPES_VARS_FIELDS);
            }

            @Override
            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node instanceof TypeScriptEnumField || !(node instanceof TypeScriptVariable) && !(node instanceof TypeScriptField) && !(node instanceof TypeScriptParameter)) {
                    return;
                }
                this.visitNode(node, node.getNameIdentifier(), tsSettings.PREFER_EXPLICIT_TYPES_VARS_FIELDS);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(node instanceof TypeScriptFunction)) {
                    return;
                }
                this.visitNode(node, node.getNameIdentifier(), tsSettings.PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS);
            }

            @Override
            public void visitJSFunctionExpression(JSFunctionExpression node) {
                if (!(node instanceof TypeScriptFunction)) {
                    return;
                }
                PsiElement toHighlight = node.getNameIdentifier();
                if (toHighlight == null || !PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)toHighlight, (boolean)true)) {
                    ASTNode keyword;
                    ASTNode arrowNode = JSPsiImplUtils.getFunctionArrowNode(node);
                    toHighlight = arrowNode != null ? arrowNode.getPsi() : ((keyword = node.getNode().findChildByType(JSTokenTypes.FUNCTION_KEYWORD)) == null ? null : keyword.getPsi());
                }
                this.visitNode(node, toHighlight, tsSettings.PREFER_EXPLICIT_TYPES_FUNCTION_EXPRESSION_RETURNS);
            }

            private void visitNode(@NotNull JSElement node, PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!TypeScriptExplicitMemberTypeInspection.isSupportedDialect(node)) {
                    return;
                }
                if (PsiUtilCore.hasErrorElementChild((PsiElement)node)) {
                    return;
                }
                this.inspectForRedundantTypeDeclaration(node, preferExplicitTypes);
                this.inspectForMissingDeclaration(node, elementToHighlight, preferExplicitTypes);
            }

            private void inspectForMissingDeclaration(@NotNull JSElement node, @Nullable PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (elementToHighlight == null) {
                    return;
                }
                if (TypeScriptPsiUtil.returnTypeAnnotationForbidden(node)) {
                    return;
                }
                if (!TypeScriptSpecifyTypeExplicitlyQuickFix.isAvailable((PsiElement)node)) {
                    return;
                }
                if (TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(node) == null) {
                    ProblemHighlightType highlightType;
                    JSType inferredType = TypeScriptExplicitMemberTypeInspection.getInferredType((PsiElement)node);
                    if (inferredType == null || inferredType instanceof JSUniqueSymbolTypeImpl) {
                        return;
                    }
                    ProblemHighlightType problemHighlightType = highlightType = preferExplicitTypes ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                    if (holder.isOnTheFly() || preferExplicitTypes) {
                        LocalQuickFix[] allFixes = new LocalQuickFix[]{new TypeScriptSpecifyTypeExplicitlyQuickFix()};
                        if (node instanceof JSParameter && TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.shouldSuggestMultiParamFix((JSParameter)node)) {
                            allFixes = new LocalQuickFix[]{new TypeScriptSpecifyTypeExplicitlyQuickFix(), new TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix()};
                        }
                        holder.registerProblem(elementToHighlight, JavaScriptBundle.message("typescript.specify.type.explicitly", new Object[0]), highlightType, allFixes);
                    }
                }
            }

            private void inspectForRedundantTypeDeclaration(@NotNull JSElement declarationOwner, boolean preferExplicitTypes) {
                ProblemHighlightType highlightType;
                boolean isRedundant;
                JSElement declarationElement;
                if (declarationOwner == null) {
                    2.$$$reportNull$$$0(4);
                }
                if ((declarationElement = TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(declarationOwner)) == null) {
                    return;
                }
                boolean bl = isRedundant = !preferExplicitTypes && TypeScriptExplicitMemberTypeInspection.isRedundantDeclaration(declarationOwner);
                if (!isRedundant) {
                    return;
                }
                LocalQuickFix[] quickFixes = new LocalQuickFix[]{new TypescriptRemoveTypeDeclarationQuickFix()};
                String message = JavaScriptBundle.message(isRedundant ? "typescript.redundant.declaration" : "typescript.remove.type.declaration", new Object[0]);
                ProblemHighlightType problemHighlightType = highlightType = isRedundant ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                if (isRedundant || holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)declarationElement, message, highlightType, quickFixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationOwner";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptExplicitMemberTypeInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForMissingDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForRedundantTypeDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isSupportedDialect(@NotNull JSElement node) {
        DialectOptionHolder dialect;
        if (node == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(2);
        }
        return (dialect = DialectDetector.dialectOfElement((PsiElement)node)) != null && dialect.isTypeScript;
    }

    private static boolean isRedundantDeclaration(@NotNull JSElement declarationOwner) {
        JSType typeFromDeclaration;
        if (declarationOwner == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(3);
        }
        if ((typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(declarationOwner)) instanceof JSUniqueSymbolTypeImpl) {
            return false;
        }
        return TypeScriptExplicitMemberTypeInspection.isRedundantDeclaration(TypeScriptExplicitMemberTypeInspection.getInferredType((PsiElement)declarationOwner), typeFromDeclaration);
    }

    private static boolean isRedundantDeclaration(@Nullable JSType inferredType, @Nullable JSType declaredType) {
        inferredType = JSTypeUtils.getValuableType(inferredType);
        return (declaredType = JSTypeUtils.getValuableType(declaredType)) != null && inferredType != null && !JSTypeCastUtil.isAlwaysAssignableType(declaredType, null) && !JSTypeCastUtil.isAlwaysAssignableType(inferredType, null) && TypeScriptExplicitMemberTypeInspection.isEquivalent(inferredType, declaredType);
    }

    private static boolean isEquivalent(@NotNull JSType inferredType, @NotNull JSType declaredType) {
        if (inferredType == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(4);
        }
        if (declaredType == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(5);
        }
        if (declaredType instanceof JSExoticStringLiteralType) {
            declaredType = ((JSExoticStringLiteralType)((Object)declaredType)).asSimpleLiteralType();
        }
        ProcessingContext context = new ProcessingContext();
        context.put(JSTypeBaseImpl.EQ_EVALUATED, (Object)Boolean.TRUE);
        return inferredType.isEquivalentTo(declaredType, context);
    }

    @Nullable
    public static JSElement getTypeDeclarationElement(@NotNull JSElement element) {
        if (element == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(6);
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return (JSElement)((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return (JSElement)((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Nullable
    public static JSType getInferredType(@NotNull PsiElement element) {
        JSType typeFromUsage;
        if (element == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(7);
        }
        if ((typeFromUsage = TypeFromUsageDetector.detectTypeFromUsage(element)) != null) {
            return typeFromUsage;
        }
        if (!(element instanceof JSFieldVariable) || ((JSFieldVariable)element).getTypeElement() != null || JSDestructuringUtil.isDestructuring(element.getParent())) {
            return null;
        }
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSType(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOwner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptExplicitMemberTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantDeclaration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquivalent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeDeclarationElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getInferredType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

