/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.google.gson.Gson;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.QuickInfoCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptQuickNavigateBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptServiceQuickInfoParser {
    private static final Set<String> KEYWORDS = ContainerUtil.immutableSet((Object[])new String[]{"var", "let", "const", "class", "enum", "function", "module", "namespace", "export", "private", "public", "protected", "type", "interface", "static", "readonly", "async"});

    @Nullable
    static @Nullable Future<@Nullable String> requestServiceQuickInfo(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        ASTNode name;
        if (element == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(element.getProject());
        if (!settings.useService() || !settings.isUseServiceQuickNavigate()) {
            return null;
        }
        if (!DialectDetector.isTypeScript(originalElement)) {
            return null;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(element.getProject(), file2);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        if (originalElement instanceof PsiNameIdentifierOwner) {
            PsiElement identifier = ((PsiNameIdentifierOwner)originalElement).getNameIdentifier();
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)identifier, (Object)originalElement);
        } else if (originalElement instanceof JSReferenceExpression) {
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement).getReferenceNameElement(), (Object)originalElement);
        } else if (originalElement instanceof XmlTag && (name = XmlChildRole.START_TAG_NAME_FINDER.findChild(originalElement.getNode())) != null) {
            originalElement = name.getPsi();
        }
        TextRange range = originalElement.getTextRange();
        int offset = range.getStartOffset();
        TypeScriptFileLocationRequestArgs location = new TypeScriptFileLocationRequestArgs();
        Document document2 = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(originalElement.getContainingFile());
        if (document2 == null) {
            return null;
        }
        TypeScriptLanguageServiceUtil.fillFilePosition(location, file2, document2, offset);
        QuickInfoCommand command = new QuickInfoCommand(location);
        return service.sendCommand(command, (serviceObject, answer) -> {
            Gson gson = JSLanguageServiceUtil.getGson(service);
            TypeScriptQuickInfoResponse response = TypeScriptLanguageServiceUtil.deserialize(gson, answer, TypeScriptQuickInfoResponse.class);
            return response == null ? null : response.displayString;
        });
    }

    static int findGenericsEnd(@NotNull String rest) {
        if (rest == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(2);
        }
        int count = 1;
        char[] array = rest.toCharArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 == 0) continue;
            char c = array[i2];
            if (c == '<') {
                ++count;
            }
            if (c == '>') {
                --count;
            }
            if (count != 0) continue;
            return i2 + 1;
        }
        return -1;
    }

    public static String parseServiceText(@NotNull PsiElement resolvedElement, @NotNull String originalText) {
        ParsedInfo info;
        if (resolvedElement == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(3);
        }
        if (originalText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(4);
        }
        if ((info = TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(originalText)) == null) {
            return StringUtil.escapeXmlEntities((String)originalText);
        }
        return TypeScriptServiceQuickInfoParser.getQuickNavigate(resolvedElement, info);
    }

    @Nullable
    public static ParsedInfo parseServiceTextAsInfo(@NotNull String originalText) {
        if (originalText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(5);
        }
        try {
            int close;
            String processText = originalText;
            String kind = "";
            if (processText.startsWith("(") && (close = processText.indexOf(") ")) > 0) {
                kind = processText.substring(0, close + 2);
                processText = processText.substring(close + 2);
            }
            int space = processText.indexOf(" ");
            int lastKeywordStartOffset = 0;
            while (space >= 0 && KEYWORDS.contains(processText.substring(lastKeywordStartOffset, space))) {
                lastKeywordStartOffset = space;
                space = processText.indexOf(" ", lastKeywordStartOffset);
            }
            String keywords = "";
            if (lastKeywordStartOffset > 0) {
                keywords = processText.substring(0, lastKeywordStartOffset + 1);
                processText = processText.substring(lastKeywordStartOffset + 1);
            }
            if (processText.isEmpty()) {
                return null;
            }
            int qNameIndex = TypeScriptServiceQuickInfoParser.readQNameWithGenerics(processText);
            if (qNameIndex == 0) {
                return null;
            }
            String restPart = processText.substring(qNameIndex);
            String postfix = "";
            int indexOfOverloads = restPart.indexOf("(+");
            if (indexOfOverloads > 0) {
                postfix = restPart.substring(indexOfOverloads);
                restPart = restPart.substring(0, indexOfOverloads);
            }
            String qName = processText.substring(0, qNameIndex);
            return new ParsedInfo(keywords, restPart, qName, kind, postfix);
        }
        catch (RuntimeException e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).warn("Cannot parse service text: " + originalText, (Throwable)e);
            return null;
        }
    }

    private static int readQNameWithGenerics(@NotNull String processText) {
        if (processText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(6);
        }
        if (processText.length() == 0) {
            return 0;
        }
        int qNameIndex = 0;
        char ch = processText.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            while (processText.length() > qNameIndex && (Character.isJavaIdentifierStart(processText.charAt(qNameIndex)) || processText.charAt(qNameIndex) == '<')) {
                int before = qNameIndex;
                if (processText.charAt(qNameIndex) == '<') {
                    int end = TypeScriptServiceQuickInfoParser.findGenericsEnd(processText.substring(qNameIndex));
                    if (end <= 0 || processText.length() <= qNameIndex + end) break;
                    if (processText.charAt(qNameIndex += end) == '.') {
                        ++qNameIndex;
                    }
                } else {
                    qNameIndex = TypeScriptServiceQuickInfoParser.readQualifiedName(processText, qNameIndex);
                }
                if (before != qNameIndex) continue;
                break;
            }
        }
        return qNameIndex;
    }

    private static int readQualifiedName(String processText, int qNameIndex) {
        ++qNameIndex;
        while (processText.length() > qNameIndex && (Character.isJavaIdentifierPart(processText.charAt(qNameIndex)) || '.' == processText.charAt(qNameIndex))) {
            ++qNameIndex;
        }
        return qNameIndex;
    }

    private static String getQuickNavigate(@NotNull PsiElement element, @NotNull ParsedInfo info) {
        String htmlText;
        if (element == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(7);
        }
        if (info == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(8);
        }
        String name = StringUtil.escapeXmlEntities((String)info.myQName);
        if (info.myKeywords.length() > 0) {
            return info.myKindPrefix + TypeScriptServiceQuickInfoParser.getQuickNavigateByKeyword(element, info.myRestPart, info.myKeywords, name) + info.myOverloadInfo;
        }
        switch (info.getObjectKind()) {
            case FUNCTION: 
            case METHOD: {
                htmlText = JSQuickNavigateBuilder.buildHtmlForFunction(element, "", name, false, info.myRestPart);
                break;
            }
            default: {
                htmlText = JSQuickNavigateBuilder.buildHtmlForVariableOrField(element, "", name, false, info.myRestPart);
            }
        }
        return info.myKindPrefix + htmlText + info.myOverloadInfo;
    }

    private static JSQuickNavigateBuilder.ObjectKind toObjectKind(@NotNull String kindPrefix) {
        if (kindPrefix == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(9);
        }
        for (JSQuickNavigateBuilder.ObjectKind value : JSQuickNavigateBuilder.ObjectKind.values()) {
            if (!value.toPrefix().equals(kindPrefix)) continue;
            return value;
        }
        return JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
    }

    @NotNull
    private static String getQuickNavigateByKeyword(@NotNull PsiElement element, @NotNull String restPart, @NotNull String keywords, @NotNull String qName) {
        if (element == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(10);
        }
        if (restPart == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(11);
        }
        if (keywords == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(12);
        }
        if (qName == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(13);
        }
        String finalText = keywords + "$$Name$$" + restPart;
        TextRange nameRange = new TextRange(keywords.length(), keywords.length() + "$$Name$$".length());
        String string = JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(element, qName, "", finalText, nameRange);
        if (string == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindPrefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restPart";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickNavigateByKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestServiceQuickInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGenericsEnd";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceTextAsInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readQNameWithGenerics";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toObjectKind";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateByKeyword";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParsedInfo {
        public static final String PREFIX = "...";
        public final String myKeywords;
        public final String myRestPart;
        public final String myRestPartWithPlaceHolders;
        public final List<JSHtmlHighlightingUtil.TextPlaceholder> myPlaceholders;
        public final String myQName;
        public final String myKindPrefix;
        public final String myOverloadInfo;

        ParsedInfo(@NotNull String keywords, @NotNull String restPart, @NotNull String qName, @NotNull String kindPrefix, @NotNull String overloadInfo) {
            if (keywords == null) {
                ParsedInfo.$$$reportNull$$$0(0);
            }
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(1);
            }
            if (qName == null) {
                ParsedInfo.$$$reportNull$$$0(2);
            }
            if (kindPrefix == null) {
                ParsedInfo.$$$reportNull$$$0(3);
            }
            if (overloadInfo == null) {
                ParsedInfo.$$$reportNull$$$0(4);
            }
            this.myPlaceholders = new ArrayList<JSHtmlHighlightingUtil.TextPlaceholder>();
            this.myKeywords = keywords;
            this.myRestPart = restPart;
            this.myQName = qName;
            this.myKindPrefix = kindPrefix;
            this.myOverloadInfo = overloadInfo;
            this.myRestPartWithPlaceHolders = this.cropImportPart(this.parseRestPart());
        }

        @NotNull
        public JSQuickNavigateBuilder.ObjectKind getObjectKind() {
            JSQuickNavigateBuilder.ObjectKind objectKind = TypeScriptServiceQuickInfoParser.toObjectKind(this.myKindPrefix);
            if (objectKind == null) {
                ParsedInfo.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @NotNull
        private String cropImportPart(@NotNull String restPart) {
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(6);
            }
            if (!this.myKindPrefix.contains("alias")) {
                String string = restPart;
                if (string == null) {
                    ParsedInfo.$$$reportNull$$$0(7);
                }
                return string;
            }
            String import_prefix = "\nimport ";
            int import_ = restPart.lastIndexOf(import_prefix);
            if (import_ > 0) {
                String string = restPart.substring(0, import_);
                if (string == null) {
                    ParsedInfo.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = restPart;
            if (string == null) {
                ParsedInfo.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private String parseRestPart() {
            String currentString = this.myRestPart;
            int threeDots = currentString.indexOf(PREFIX);
            StringBuilder newRest = new StringBuilder();
            int counter = 0;
            while (threeDots > 0 && threeDots + PREFIX.length() < currentString.length()) {
                ProgressManager.checkCanceled();
                int afterPrefixIndex = threeDots + PREFIX.length();
                char afterPrefix = currentString.charAt(afterPrefixIndex);
                if (Character.isWhitespace(afterPrefix) && afterPrefixIndex + 1 < currentString.length()) {
                    char nextChar = currentString.charAt(afterPrefixIndex + 1);
                    if (nextChar == '|' || nextChar == '&') {
                        this.addHolderForPrefix(currentString, newRest, threeDots, ++counter);
                        currentString = currentString.substring(threeDots + PREFIX.length());
                        threeDots = currentString.indexOf(PREFIX);
                        continue;
                    }
                    if (!Character.isDigit(nextChar)) {
                        threeDots = currentString.indexOf(PREFIX, threeDots + PREFIX.length());
                        continue;
                    }
                    newRest.append(currentString, 0, threeDots);
                    int skipped = ParsedInfo.skipMessageAndDigits(currentString, afterPrefixIndex + 1);
                    if (skipped <= 0) {
                        this.myPlaceholders.clear();
                        String string = this.myRestPart;
                        if (string == null) {
                            ParsedInfo.$$$reportNull$$$0(10);
                        }
                        return string;
                    }
                    String toReplace = currentString.substring(threeDots, skipped);
                    String holderText = "$$Type$$Srv" + ++counter + "_" + this.hashCode();
                    JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(toReplace, holderText);
                    newRest.append(holderText);
                    this.myPlaceholders.add(holder);
                    currentString = currentString.substring(skipped);
                    threeDots = currentString.indexOf(PREFIX);
                    continue;
                }
                int before = threeDots - 1;
                int after = threeDots + PREFIX.length();
                if (before > 0 && after < currentString.length() && currentString.charAt(before) == '<' && currentString.charAt(after) == '>') {
                    this.addHolderForPrefix(currentString, newRest, threeDots, ++counter);
                    currentString = currentString.substring(after);
                    threeDots = currentString.indexOf(PREFIX);
                    continue;
                }
                threeDots = currentString.indexOf(PREFIX, threeDots + PREFIX.length());
            }
            newRest.append(currentString);
            String string = newRest.toString();
            if (string == null) {
                ParsedInfo.$$$reportNull$$$0(11);
            }
            return string;
        }

        private void addHolderForPrefix(@NotNull String currentString, @NotNull StringBuilder newRest, int offset, int counter) {
            if (currentString == null) {
                ParsedInfo.$$$reportNull$$$0(12);
            }
            if (newRest == null) {
                ParsedInfo.$$$reportNull$$$0(13);
            }
            String holderText = "$$Type$$Srv" + counter + "_" + this.hashCode();
            String toReplace = currentString.substring(offset, offset + PREFIX.length());
            JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(toReplace, holderText);
            newRest.append(currentString, 0, offset);
            newRest.append(holder.getHolderText());
            this.myPlaceholders.add(holder);
        }

        private static int skipMessageAndDigits(@NotNull String restPart, int index) {
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(14);
            }
            while (restPart.length() > index && Character.isDigit(restPart.charAt(index))) {
                ++index;
            }
            if (restPart.length() <= index) {
                return -1;
            }
            char space = restPart.charAt(index);
            if (!Character.isWhitespace(space)) {
                return -1;
            }
            ++index;
            while (restPart.length() > index && Character.isLetter(restPart.charAt(index))) {
                ++index;
            }
            if (restPart.length() <= index) {
                return -1;
            }
            String next = restPart.substring(index);
            if (next.startsWith(" ...")) {
                return " ...".length() + index;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keywords";
                    break;
                }
                case 1: 
                case 6: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "restPart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindPrefix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overloadInfo";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentString";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectKind";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cropImportPart";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRestPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "cropImportPart";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addHolderForPrefix";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "skipMessageAndDigits";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

