/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TypeScriptLanguageServiceCache
extends JSLanguageServiceDefaultCacheData {
    protected final Project myProject;
    protected final Map<VirtualFile, LastUpdateInfo> myUpdateFiles = new ConcurrentHashMap<VirtualFile, LastUpdateInfo>();
    protected final Set<VirtualFile> myOpenedFilesByEvent = ContainerUtil.newConcurrentSet();
    private final Set<VirtualFile> myExternalConfigs = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Set<VirtualFile> myVfsChangedFiles;

    public TypeScriptLanguageServiceCache(Project project) {
        this.myProject = project;
        this.myVfsChangedFiles = ContainerUtil.newConcurrentSet();
    }

    @Override
    @Nullable
    public final JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(0);
        }
        if (input instanceof TypeScriptLanguageServiceUpdateCommand) {
            return this.computeInNonBlockingReadAction(() -> this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)input));
        }
        if (input instanceof TypeScriptCompositeCommand) {
            JSLanguageServiceCommand[] commands = ((TypeScriptCompositeCommand)input).getNestedCommands();
            ArrayList<JSLanguageServiceRequest> results = new ArrayList<JSLanguageServiceRequest>(commands.length);
            for (JSLanguageServiceCommand command : commands) {
                JSLanguageServiceObject serviceObject = this.updateCacheAndGetServiceObject(command);
                if (serviceObject == null) continue;
                if (serviceObject instanceof TypeScriptCommandSetRequest) {
                    ((TypeScriptCommandSetRequest)serviceObject).nestedRequests.forEach((nestedServiceObject, nestedCommand) -> {
                        JSLanguageServiceRequest request = new JSLanguageServiceRequest((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedServiceObject, -1L, -1);
                        results.add(request);
                    });
                    continue;
                }
                JSLanguageServiceRequest request = new JSLanguageServiceRequest(command, serviceObject, -1L, -1);
                results.add(request);
            }
            if (results.size() == 0) {
                return null;
            }
            return new TypeScriptCompositeRequest(results);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            VirtualFile file2;
            if (input instanceof TypeScriptOpenEditorCommand) {
                return this.computeInNonBlockingReadAction(() -> this.refreshAndGetOpenEditorCommand((JSLanguageServiceSimpleCommand)input));
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                return this.computeInNonBlockingReadAction(() -> this.refreshAndGetCloseEditorCommand((JSLanguageServiceSimpleCommand)input));
            }
            if (input instanceof TypeScriptReloadFileCommand && (this.myOpenedFilesByEvent.contains(file2 = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file2))) {
                return null;
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @RequiresReadLock
    public ServiceObjectWithCacheUpdate refreshAndGetCloseEditorCommand(@NotNull JSLanguageServiceSimpleCommand jSLanguageServiceSimpleCommand) {
        VirtualFile configFile;
        String name;
        void input;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(1);
        }
        TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
        VirtualFile fileToClose = command.getFile();
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        cacheUpdates.add(() -> this.myOpenedFilesByEvent.remove(fileToClose));
        if (!this.myUpdateFiles.containsKey(fileToClose)) {
            return new ServiceObjectWithCacheUpdate(null, cacheUpdates);
        }
        cacheUpdates.add(() -> this.myUpdateFiles.remove(fileToClose));
        TypeScriptConfig config2 = this.getConfigForFile(fileToClose);
        if (TypeScriptConfigUtil.isNonStandardName(config2) && this.myExternalConfigs.contains(config2.getConfigFile()) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null) {
            HashSet<VirtualFile> openOrUpdatedFiles = new HashSet<VirtualFile>();
            openOrUpdatedFiles.addAll(this.myUpdateFiles.keySet());
            openOrUpdatedFiles.addAll(this.myOpenedFilesByEvent);
            openOrUpdatedFiles.remove(fileToClose);
            Set<VirtualFile> configs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
            if (!configs.contains(configFile)) {
                cacheUpdates.add(() -> this.myExternalConfigs.remove(configFile));
                TypeScriptCommandSetRequest object = new TypeScriptCommandSetRequest(ContainerUtil.newArrayList((Object[])new JSLanguageServiceSimpleCommand[]{new TypeScriptCloseExternalProjectRequest(name), input}));
                return new ServiceObjectWithCacheUpdate(object, cacheUpdates);
            }
        }
        return new ServiceObjectWithCacheUpdate(input.toSerializableObject(), cacheUpdates);
    }

    @Nullable
    protected TypeScriptConfig getConfigForFile(VirtualFile virtualFile) {
        return TypeScriptConfigUtil.getConfigForFile(this.myProject, virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @RequiresReadLock
    public ServiceObjectWithCacheUpdate refreshAndGetOpenEditorCommand(@NotNull JSLanguageServiceSimpleCommand jSLanguageServiceSimpleCommand) {
        VirtualFile configFile;
        String name;
        void input;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(2);
        }
        TypeScriptOpenEditorCommand command = (TypeScriptOpenEditorCommand)input;
        VirtualFile file2 = command.getFile();
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        cacheUpdates.add(() -> this.myOpenedFilesByEvent.add(file2));
        if (this.myUpdateFiles.containsKey(file2)) {
            return new ServiceObjectWithCacheUpdate(null, cacheUpdates);
        }
        String path2 = JSLanguageServiceUtil.normalizeNameAndPath(file2);
        LastUpdateInfo info = new LastUpdateInfo(path2, command.getTimestamp(), command.getContentLength(), command.getLineCount(), command.getLastLineStartOffset());
        cacheUpdates.add(() -> this.myUpdateFiles.put(file2, info));
        TypeScriptConfig config2 = this.getConfigForFile(file2);
        SmartList commands = new SmartList();
        if (this.myVfsChangedFiles.contains(file2) || command.getContentLength() == 0L && System.currentTimeMillis() - file2.getTimeStamp() < 2500L) {
            commands.add(TypeScriptLanguageServiceCache.createReloadCommand(config2));
            cacheUpdates.add(() -> this.myVfsChangedFiles.remove(file2));
        }
        if (TypeScriptConfigUtil.isNonStandardName(config2) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null) {
            ((TypeScriptFileWithConfigArgs)command.arguments).projectFileName = LocalFilePath.create(name);
            if (!this.myExternalConfigs.contains(config2.getConfigFile())) {
                cacheUpdates.add(() -> this.myExternalConfigs.add(configFile));
                commands.add(new TypeScriptOpenExternalProjectRequest(name));
            }
        }
        commands.add(input);
        return new ServiceObjectWithCacheUpdate(TypeScriptCommandSetRequest.createSet((List<? extends JSLanguageServiceSimpleCommand>)commands), cacheUpdates);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @RequiresReadLock
    private ServiceObjectWithCacheUpdate getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateCommand typeScriptLanguageServiceUpdateCommand) {
        void command;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (command == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(3);
        }
        Map<VirtualFile, Long> currentChangedFiles = command.myChangedFilesToTimeStamp;
        Map<VirtualFile, Document> unsavedContents = command.myUnsavedFilesContent;
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentChangedFiles);
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = new HashMap();
        List toOpen = ((StreamEx)StreamEx.of(filesToOpen).filter(el -> !filesToClose.contains(el) && unsavedContents.containsKey(el))).map(el -> {
            Document document2 = (Document)unsavedContents.get(el);
            Long timestampObject = (Long)currentChangedFiles.get(el);
            CharSequence text = this.getPreprocessedDocumentText((VirtualFile)el, document2);
            long timestamp = timestampObject == null ? -1L : timestampObject;
            LastUpdateInfo value = TypeScriptLanguageServiceCache.createLastUpdateInfo(el, text, timestamp);
            toUpdateCache.put(el, value);
            String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, el);
            return this.createOpenCommand((VirtualFile)el, value, text, projectFileName, timestamp);
        }).toList();
        List toChange = ((StreamEx)StreamEx.of(changedFiles).filter(el -> !filesToClose.contains(el))).map(el -> {
            LastUpdateInfo info = this.myUpdateFiles.get(el);
            Document document2 = (Document)unsavedContents.get(el);
            CharSequence text = this.getPreprocessedDocumentText((VirtualFile)el, document2);
            long newTimestamp = (Long)currentChangedFiles.get(el);
            LastUpdateInfo value = TypeScriptLanguageServiceCache.createLastUpdateInfo(el, text, newTimestamp);
            toUpdateCache.put(el, value);
            TypeScriptChangeRequestArgs req = TypeScriptChangeRequestArgs.build(el, text, info.myContentLength, info.myLineCount, info.myLastLineStartOffset);
            return new TypeScriptChangeCommand(req);
        }).toList();
        ArrayList toCloseByRename = new ArrayList();
        ArrayList toOpenByRename = new ArrayList();
        HashSet filesToCloseByRename = new HashSet();
        HashSet<TypeScriptConfig> configsToReload = new HashSet<TypeScriptConfig>();
        this.myUpdateFiles.forEach((file2, storedInfo) -> {
            String newPath = JSLanguageServiceUtil.normalizeNameAndPath(file2);
            String oldPath = storedInfo.myLastPath;
            if (newPath != null && !Objects.equals(newPath, oldPath)) {
                toCloseByRename.add(TypeScriptLanguageServiceCache.createCloseCommand(file2, oldPath));
                filesToCloseByRename.add(file2);
                if (!filesToOpen.contains(file2) && !filesToClose.contains(file2)) {
                    LastUpdateInfo updateInfo = (LastUpdateInfo)toUpdateCache.get(file2);
                    LastUpdateInfo info = new LastUpdateInfo(updateInfo == null ? storedInfo : updateInfo, newPath);
                    Document document2 = (Document)unsavedContents.get(file2);
                    CharSequence text = document2 == null ? null : this.getPreprocessedDocumentText((VirtualFile)file2, document2);
                    TypeScriptConfig config2 = this.getConfigForFile((VirtualFile)file2);
                    String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(config2);
                    toOpenByRename.add(this.createOpenCommand((VirtualFile)file2, info, text, projectFileName, info.myTimestamp));
                    toUpdateCache.put(file2, info);
                    if (config2 != null) {
                        configsToReload.add(config2);
                    }
                }
            }
        });
        Collection toClose = filesToClose.stream().filter(el -> !filesToCloseByRename.contains(el)).map(el -> TypeScriptLanguageServiceCache.createCloseCommand(el, JSLanguageServiceUtil.normalizeNameAndPath(el))).collect(Collectors.toList());
        HashMap<VirtualFile, LastUpdateInfo> newUpdateFiles = new HashMap<VirtualFile, LastUpdateInfo>(this.myUpdateFiles);
        filesToClose.forEach(el -> newUpdateFiles.remove(el));
        newUpdateFiles.putAll(toUpdateCache);
        cacheUpdates.add(() -> {
            this.myUpdateFiles.clear();
            this.myUpdateFiles.putAll(newUpdateFiles);
        });
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty() && toCloseByRename.isEmpty() && toOpenByRename.isEmpty()) {
            return new ServiceObjectWithCacheUpdate(null, cacheUpdates);
        }
        HashSet<VirtualFile> openOrUpdatedFiles = new HashSet<VirtualFile>(this.myOpenedFilesByEvent);
        openOrUpdatedFiles.addAll(newUpdateFiles.keySet());
        Set<VirtualFile> actualExternalConfigs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
        Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> openAndCloseExternals = this.getAndUpdateExternalConfigsCommand(actualExternalConfigs);
        cacheUpdates.add(() -> {
            this.myExternalConfigs.clear();
            this.myExternalConfigs.addAll(actualExternalConfigs);
        });
        Collection openExternal = (Collection)openAndCloseExternals.getFirst();
        Collection closeExternal = (Collection)openAndCloseExternals.getSecond();
        ArrayList<TypeScriptCommandWithArguments> result2 = new ArrayList<TypeScriptCommandWithArguments>();
        configsToReload.addAll(this.getConfigsForReload(filesToOpen));
        cacheUpdates.add(() -> this.myVfsChangedFiles.removeAll(ContainerUtil.intersection((Collection)filesToOpen, this.myVfsChangedFiles)));
        TypeScriptLanguageServiceCache.addReloadCommands(configsToReload, result2);
        result2.addAll(openExternal);
        result2.addAll(toCloseByRename);
        result2.addAll(toOpen);
        result2.addAll(toOpenByRename);
        result2.addAll(toChange);
        result2.addAll(toClose);
        result2.addAll(closeExternal);
        return new ServiceObjectWithCacheUpdate(new TypeScriptCommandSetRequest(result2), cacheUpdates);
    }

    @Nullable
    private JSLanguageServiceObject computeInNonBlockingReadAction(@NotNull @NotNull Callable<@NotNull ServiceObjectWithCacheUpdate> action) {
        if (action == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(4);
        }
        try {
            ServiceObjectWithCacheUpdate update2 = (ServiceObjectWithCacheUpdate)ReadAction.nonBlocking(action).expireWith((Disposable)this).executeSynchronously();
            return update2.executeUpdates();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    @NotNull
    private Collection<TypeScriptConfig> getConfigsForReload(@NotNull Collection<VirtualFile> filesToOpen) {
        if (filesToOpen == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> vfsFiles = new HashSet<VirtualFile>(this.myVfsChangedFiles);
        ArrayList<TypeScriptConfig> objects = new ArrayList<TypeScriptConfig>();
        for (VirtualFile file2 : filesToOpen) {
            if (!vfsFiles.contains(file2)) continue;
            TypeScriptConfig config2 = this.getConfigForFile(file2);
            objects.add(config2);
        }
        ArrayList<TypeScriptConfig> arrayList = objects;
        if (arrayList == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void addReloadCommands(@NotNull Collection<TypeScriptConfig> configsToReload, @NotNull List<TypeScriptCommandWithArguments> result2) {
        if (configsToReload == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(8);
        }
        for (TypeScriptConfig config2 : configsToReload) {
            result2.add(TypeScriptLanguageServiceCache.createReloadCommand(config2));
        }
    }

    @NotNull
    private static TypeScriptReloadProjectsCommand createReloadCommand(@Nullable TypeScriptConfig config2) {
        TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
        args.projectFileName = config2 != null ? LocalFilePath.create(TypeScriptConfigUtil.getConfigProjectFileName(config2)) : null;
        return new TypeScriptReloadProjectsCommand(args);
    }

    @Nullable
    protected TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file2, @NotNull LastUpdateInfo info, @Nullable CharSequence text, @Nullable String projectFileName, long timestamp) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(9);
        }
        if (info == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(10);
        }
        return new TypeScriptOpenEditorCommand(file2, timestamp, info.myContentLength, info.myLineCount, info.myLastLineStartOffset, text, projectFileName);
    }

    @NotNull
    private static LastUpdateInfo createLastUpdateInfo(@NotNull VirtualFile el, @NotNull CharSequence text, long newTimestamp) {
        if (el == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(11);
        }
        if (text == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(12);
        }
        int lineCount = TypeScriptServerServiceImpl.getLineCountForText(text);
        int lastLineStartOffset = TypeScriptServerServiceImpl.getLastLineStartOffsetFromText(text, lineCount);
        int newContentLength = text.length();
        String path2 = JSLanguageServiceUtil.normalizeNameAndPath(el);
        return new LastUpdateInfo(path2, newTimestamp, newContentLength, lineCount, lastLineStartOffset);
    }

    @NotNull
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(13);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(14);
        }
        CharSequence text = this.getDocumentText(file2, document2);
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text, file2);
        if (charSequence == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    @NotNull
    protected CharSequence getDocumentText(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(16);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(17);
        }
        CharSequence charSequence = document2.getImmutableCharSequence();
        if (charSequence == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(18);
        }
        return charSequence;
    }

    @NotNull
    private Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> getAndUpdateExternalConfigsCommand(@NotNull Set<VirtualFile> actualExternalConfigs) {
        if (actualExternalConfigs == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(19);
        }
        HashSet<VirtualFile> toClose = new HashSet<VirtualFile>(this.myExternalConfigs);
        toClose.removeAll(actualExternalConfigs);
        HashSet<VirtualFile> toOpen = new HashSet<VirtualFile>(actualExternalConfigs);
        toOpen.removeAll(this.myExternalConfigs);
        Pair pair = Pair.create(TypeScriptLanguageServiceCache.convertToCommands(toOpen, (Function<? super String, ? extends TypeScriptCommandWithArguments>)((Function)TypeScriptOpenExternalProjectRequest::new)), TypeScriptLanguageServiceCache.convertToCommands(toClose, (Function<? super String, ? extends TypeScriptCommandWithArguments>)((Function)TypeScriptCloseExternalProjectRequest::new)));
        if (pair == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(20);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    private Set<VirtualFile> getNonStandardConfigsForFiles(@NotNull Collection<VirtualFile> collection) {
        void files;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (files == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(21);
        }
        Set set = ((StreamEx)StreamEx.of((Collection)files).map(file2 -> this.getConfigForFile((VirtualFile)file2)).nonNull().filter(el -> TypeScriptConfigUtil.isNonStandardName(el))).map(el -> el.getConfigFile()).toSet();
        if (set == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(22);
        }
        return set;
    }

    public void removeVfsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(23);
        }
        this.myVfsChangedFiles.remove(file2);
    }

    public void addVfsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(24);
        }
        this.myVfsChangedFiles.add(file2);
    }

    @NotNull
    private static Set<TypeScriptCommandWithArguments> convertToCommands(@NotNull Set<? extends VirtualFile> toOpen, @NotNull Function<? super String, ? extends TypeScriptCommandWithArguments> factory) {
        if (toOpen == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(25);
        }
        if (factory == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(26);
        }
        Set<TypeScriptCommandWithArguments> set = toOpen.stream().map(el -> JSLanguageServiceUtil.normalizeNameAndPath(el)).filter(el -> el != null).map(el -> (TypeScriptCommandWithArguments)factory.fun(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    private static TypeScriptCloseEditorCommand createCloseCommand(@NotNull VirtualFile el, @Nullable String path2) {
        if (el == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(28);
        }
        TypeScriptFileObject object = new TypeScriptFileObject();
        object.file = LocalFilePath.create(path2);
        return new TypeScriptCloseEditorCommand(object, el);
    }

    private Collection<VirtualFile> getFilesToOpen(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(29);
        }
        return ContainerUtil.filter(currentChangedFiles.keySet(), el -> !this.myUpdateFiles.containsKey(el));
    }

    private Collection<VirtualFile> getFilesToChange(@NotNull Map<VirtualFile, Long> currentChangedFiles, @NotNull Collection<VirtualFile> filesToOpen) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(30);
        }
        if (filesToOpen == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(31);
        }
        ArrayList<VirtualFile> realChangedFiles = new ArrayList<VirtualFile>();
        currentChangedFiles.forEach((file2, modified) -> {
            if (filesToOpen.contains(file2)) {
                return;
            }
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file2);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.LOGGER.error("Incorrect cache");
                return;
            }
            long timeStamp = lastUpdateInfo.myTimestamp;
            if (modified < 0L || timeStamp == -1L || modified != timeStamp) {
                realChangedFiles.add((VirtualFile)file2);
            }
        });
        return realChangedFiles;
    }

    @NotNull
    protected Set<VirtualFile> getFilesToClose(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(32);
        }
        HashSet<VirtualFile> toClose = new HashSet<VirtualFile>();
        for (VirtualFile file2 : this.myUpdateFiles.keySet()) {
            if (currentChangedFiles.containsKey(file2) || this.myOpenedFilesByEvent.contains(file2)) continue;
            toClose.add(file2);
        }
        HashSet<VirtualFile> hashSet = toClose;
        if (hashSet == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        this.clear();
        this.myExternalConfigs.clear();
        this.myOpenedFilesByEvent.clear();
        this.myUpdateFiles.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpen";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configsToReload";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualExternalConfigs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOpen";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigsForReload";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessedDocumentText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndUpdateExternalConfigsCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStandardConfigsForFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommands";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCacheAndGetServiceObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetCloseEditorCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetOpenEditorCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesServiceObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonBlockingReadAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigsForReload";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 33: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addReloadCommands";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createOpenCommand";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLastUpdateInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedDocumentText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAndUpdateExternalConfigsCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNonStandardConfigsForFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeVfsFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addVfsFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommands";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createCloseCommand";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToOpen";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToChange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToClose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LastUpdateInfo {
        public final long myTimestamp;
        public final long myContentLength;
        public final int myLineCount;
        public final int myLastLineStartOffset;
        public final String myLastPath;

        LastUpdateInfo(@NotNull LastUpdateInfo toCopy, @NotNull String newPath) {
            if (toCopy == null) {
                LastUpdateInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                LastUpdateInfo.$$$reportNull$$$0(1);
            }
            this.myTimestamp = toCopy.myTimestamp;
            this.myContentLength = toCopy.myContentLength;
            this.myLineCount = toCopy.myLineCount;
            this.myLastLineStartOffset = toCopy.myLastLineStartOffset;
            this.myLastPath = newPath;
        }

        LastUpdateInfo(String path2, long timestamp, long contentLength, int lineCount, int lastLineStartOffset) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
            this.myLastPath = path2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ServiceObjectWithCacheUpdate {
        private final JSLanguageServiceObject myObject;
        private final List<Runnable> myUpdates;

        private ServiceObjectWithCacheUpdate(@Nullable JSLanguageServiceObject object, @NotNull List<Runnable> updates) {
            if (updates == null) {
                ServiceObjectWithCacheUpdate.$$$reportNull$$$0(0);
            }
            this.myObject = object;
            this.myUpdates = updates;
        }

        @Nullable
        public JSLanguageServiceObject executeUpdates() {
            for (Runnable update2 : this.myUpdates) {
                update2.run();
            }
            return this.myObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$ServiceObjectWithCacheUpdate", "<init>"));
        }
    }
}

