/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptServiceRelatedAction;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFix
implements IntentionAction,
Iconable,
LowPriorityAction,
TypeScriptServiceRelatedAction {
    static final State LOADING = new State(null){

        @Override
        String getName() {
            return JavaScriptBundle.message("intention.name.loading.service.fixes", new Object[0]);
        }
    };
    private static final Comparator<Edit> CODE_EDIT_COMPARATOR = Comparator.comparingInt(value -> value.range.getEndOffset()).thenComparingInt(value -> value.range.getStartOffset());
    @NotNull
    private final Runnable myRefreshCallback;
    private final int myIndex;
    @Nullable
    private final List<TextRange> myLimitedRanges;
    @Nullable
    private volatile State myState;
    private final boolean myShouldReformat;

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    public TypeScriptLanguageServiceFix(@NotNull Runnable refresh2, int index, @Nullable List<TextRange> limitedRanges, boolean shouldReformat) {
        if (refresh2 == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(0);
        }
        this.myRefreshCallback = refresh2;
        this.myIndex = index;
        this.myLimitedRanges = limitedRanges;
        this.myShouldReformat = shouldReformat;
    }

    @IntentionName
    @NotNull
    public String getText() {
        this.myRefreshCallback.run();
        State state2 = this.myState;
        String string = state2 == null ? "" : StringUtil.notNullize((String)state2.getName());
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(3);
        }
        this.myRefreshCallback.run();
        State state2 = this.myState;
        return state2 != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        State state2;
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(4);
        }
        if ((state2 = this.myState) == null) {
            return;
        }
        TypeScriptCodeActionInfo fix = state2.fix;
        if (fix == null) {
            return;
        }
        for (TypeScriptCodeActionInfo.FileCodeEdits change : fix.changes) {
            TypeScriptCodeActionInfo.CodeEdit[] changes;
            String name = LocalFilePath.getPath(change.fileName);
            if (StringUtil.isEmpty((String)name) || (changes = change.textChanges) == null || changes.length == 0) continue;
            String filePath = FileUtil.toSystemIndependentName((String)name);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (virtualFile == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("dialog.message.cannot.find.file", filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)ContainerUtil.createMaybeSingletonList((Object)virtualFile))) break;
            Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document2 == null) continue;
            Ref newLineSeparator = new Ref();
            String originalLineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, project);
            List<Edit> edits = TypeScriptLanguageServiceFix.convertCodeEdits(changes, document2, this.myLimitedRanges, originalLineSeparator, (Ref<LineSeparator>)newLineSeparator);
            if (edits.isEmpty()) continue;
            TextRange affectedRange = new TextRange(edits.get((int)(edits.size() - 1)).range.getStartOffset(), edits.get((int)0).range.getEndOffset());
            RangeMarker affectedRangeMarker = document2.createRangeMarker(affectedRange);
            PsiFile currentPsiFile = file2.getManager().findFile(virtualFile);
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
                for (Edit edit : edits) {
                    TypeScriptLanguageServiceFix.replaceText(document2, edit.text, edit.range);
                }
                if (this.myShouldReformat && currentPsiFile != null && affectedRangeMarker.isValid()) {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                    CodeStyleManager.getInstance((Project)project).reformatText(currentPsiFile, affectedRangeMarker.getStartOffset(), affectedRangeMarker.getEndOffset());
                }
                if (newLineSeparator.get() != null && !StringUtil.equals((CharSequence)((LineSeparator)newLineSeparator.get()).getSeparatorString(), (CharSequence)originalLineSeparator)) {
                    AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)virtualFile, (String)((LineSeparator)newLineSeparator.get()).getSeparatorString());
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    @NotNull
    private static List<Edit> convertCodeEdits(TypeScriptCodeActionInfo.CodeEdit[] changes, @NotNull Document document2, @Nullable List<TextRange> limitedRanges, @NotNull String lineSeparator, @NotNull Ref<LineSeparator> newLineSeparator) {
        if (document2 == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(5);
        }
        if (lineSeparator == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(6);
        }
        if (newLineSeparator == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(7);
        }
        ArrayList<Edit> result2 = new ArrayList<Edit>(changes.length);
        for (TypeScriptCodeActionInfo.CodeEdit change : changes) {
            TextRange range;
            JSLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(null, document2, change.start, change.end);
            TextRange textRange = range = info == null ? null : info.getRange();
            if (range == null || limitedRanges != null && ContainerUtil.find(limitedRanges, lr -> lr.contains(range)) == null) continue;
            if (range.getStartOffset() < document2.getTextLength() && document2.getImmutableCharSequence().charAt(range.getStartOffset()) == '\n' && range.isEmpty()) {
                if (StringUtil.equals((CharSequence)lineSeparator, (CharSequence)"\n") && StringUtil.equals((CharSequence)change.newText, (CharSequence)"\r")) {
                    newLineSeparator.set((Object)LineSeparator.CRLF);
                    continue;
                }
                if (StringUtil.equals((CharSequence)lineSeparator, (CharSequence)"\r\n") && StringUtil.isEmpty((String)change.newText)) {
                    newLineSeparator.set((Object)LineSeparator.LF);
                    continue;
                }
            }
            result2.add(new Edit(range, StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)change.newText))));
        }
        result2.sort(CODE_EDIT_COMPARATOR);
        List list2 = ContainerUtil.reverse(result2);
        if (list2 == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static void replaceText(@NotNull Document document2, @NotNull String text, @NotNull TextRange range) {
        if (document2 == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(9);
        }
        if (text == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(10);
        }
        if (range == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(11);
        }
        if (range.getLength() == 0) {
            document2.insertString(range.getStartOffset(), (CharSequence)text);
        } else {
            document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
        }
    }

    public void update(@Nullable State state2) {
        this.myState = state2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresh";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLineSeparator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCodeEdits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertCodeEdits";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Edit {
        @NotNull
        final TextRange range;
        @NotNull
        final String text;

        Edit(@NotNull TextRange range, @NotNull String text) {
            if (range == null) {
                Edit.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Edit.$$$reportNull$$$0(1);
            }
            this.range = range;
            this.text = text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix$Edit";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @Nullable
        private final TypeScriptCodeActionInfo fix;

        public State(@Nullable TypeScriptCodeActionInfo fix) {
            this.fix = fix;
        }

        @IntentionName
        @Nullable
        String getName() {
            return this.fix == null ? null : this.fix.description;
        }
    }
}

