/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PlatformUtils;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="TypeScriptCompiler", storages={@Storage(value="compiler.xml")})
public final class TypeScriptCompilerSettings
implements PersistentStateComponent<TypeScriptCompilerSettingsState>,
ModificationTracker {
    public static final String[] CONFIG_PARAMS = new String[]{"-p", "--p", "--project", "-project"};
    private final Project myProject;
    public static final String[] TYPESCRIPT_SERVICE_FILES = new String[]{"tsserver.js", "tsserverlibrary.js"};
    private TypeScriptCompilerSettingsState myState = new TypeScriptCompilerSettingsState();

    public long getModificationCount() {
        return this.myState.getModificationCount();
    }

    public static TypeScriptCompilerSettings getSettings(Project project) {
        return (TypeScriptCompilerSettings)project.getService(TypeScriptCompilerSettings.class);
    }

    public TypeScriptCompilerSettings(Project project) {
        this.myProject = project;
    }

    @Nullable
    public TypeScriptCompilerSettingsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull TypeScriptCompilerSettingsState state2) {
        if (state2 == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(0);
        }
        this.myState = state2;
    }

    public boolean isUseServiceParameterInfo() {
        return this.myState.getUseServiceParameterInfo();
    }

    public boolean isUseServiceCompletion() {
        return this.myState.getUseServiceCompletion();
    }

    public boolean isUseServiceQuickNavigate() {
        return this.myState.getUseServiceQuickNavigate();
    }

    public boolean isUseSingleInferredProject() {
        return this.myState.getUseSingleInferredProject();
    }

    public String getDefaultServiceOptions() {
        return this.myState.getTypeScriptCompilerParams();
    }

    public void setDefaultServiceOptions(@Nullable String typeScriptCompilerParams) {
        this.myState.setTypeScriptCompilerParams(StringUtil.nullize((String)typeScriptCompilerParams, (boolean)true));
    }

    public void setTypeScriptServiceDirectory(@Nullable String path2) {
        this.myState.setTypeScriptServiceDirectory(PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(StringUtil.nullize((String)path2, (boolean)true)));
    }

    public boolean isShowAllProjectErrors() {
        return this.myState.getShowAllErrors();
    }

    public void setShowAllProjectErrors(boolean value) {
        this.myState.setShowAllErrors(value);
    }

    public boolean useDeprecatedSettings() {
        if (this.myState.isCompilerEnabled()) {
            return !this.myState.getUseConfig();
        }
        return this.myState.getUseDeprecatedSettings();
    }

    @Nullable
    public String getTypeScriptServiceDirectory() {
        return PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(this.myState.getTypeScriptServiceDirectory());
    }

    public TypeScriptCompilerVersionType getVersionType() {
        return this.myState.getVersionType();
    }

    public void setVersionType(TypeScriptCompilerVersionType type) {
        this.myState.setVersionType(type);
    }

    @Nullable
    public String getNodeInterpreterRefName() {
        return this.myState.getNodeInterpreterTextField();
    }

    public void setNodeInterpreterRefName(@Nullable String nodeInterpreterRefName) {
        this.myState.setNodeInterpreterTextField(StringUtil.nullize((String)nodeInterpreterRefName, (boolean)true));
    }

    @NotNull
    public String getScopeName() {
        String scopeName = this.myState.getScopeName();
        String string = scopeName == null ? this.getDefaultScopeName() : scopeName;
        if (string == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultScopeName() {
        String string = ProjectScope.getProjectFilesScopeName();
        if (string == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setScopeName(@NotNull String scopeName) {
        if (scopeName == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(3);
        }
        this.myState.setScopeName(scopeName);
    }

    @NotNull
    public String getDefaultTypeScriptServiceDirectory() {
        String string = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile().getAbsolutePath(), "external").getAbsolutePath();
        if (string == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public boolean useServiceForProjectsWithoutConfig() {
        if (this.myState.isCompilerEnabled()) {
            return true;
        }
        return this.myState.getEnableServiceForProjectsWithoutConfig();
    }

    public boolean isRecompileOnChanges() {
        if (this.myState.isCompilerEnabled() && this.myState.getTrackFileSystemChanges()) {
            return true;
        }
        return this.myState.getRecompileOnChanges();
    }

    public boolean useService() {
        if (this.myState.isCompilerEnabled()) {
            return true;
        }
        return this.myState.getUseService();
    }

    public void setRecompileOnChanges(boolean result2) {
        this.myState.setRecompileOnChanges(result2);
        if (this.myState.isCompilerEnabled()) {
            this.myState.setEnableServiceForProjectsWithoutConfig(true);
            this.myState.setUseDeprecatedSettings(!this.myState.getUseConfig());
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void setUseServiceForProjectsWithoutConfig(boolean result2) {
        this.myState.setEnableServiceForProjectsWithoutConfig(result2);
        if (this.myState.isCompilerEnabled()) {
            this.myState.setRecompileOnChanges(this.myState.getTrackFileSystemChanges());
            this.myState.setUseDeprecatedSettings(!this.myState.getUseConfig());
            this.myState.setUseService(this.myState.getUseService() || this.myState.getEnableServiceForProjectsWithoutConfig());
            this.resetDeprecatedSettingsToDefault();
        }
    }

    @TestOnly
    public void setUseConfig(boolean value) {
        this.myState.setUseConfig(value);
    }

    public void setUseDeprecatedSettings(boolean result2) {
        this.myState.setUseDeprecatedSettings(result2);
        if (this.myState.isCompilerEnabled()) {
            this.myState.setEnableServiceForProjectsWithoutConfig(true);
            this.myState.setRecompileOnChanges(this.myState.getTrackFileSystemChanges());
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void setUseService(boolean useService) {
        this.myState.setUseService(useService);
        if (this.myState.isCompilerEnabled()) {
            this.myState.setEnableServiceForProjectsWithoutConfig(true);
            this.myState.setRecompileOnChanges(this.myState.getTrackFileSystemChanges());
            this.myState.setUseDeprecatedSettings(!this.myState.getUseConfig());
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void resetDeprecatedSettingsToDefault() {
        this.myState.setCompilerEnabled(false);
        this.myState.setUseConfig(false);
        this.myState.setTrackFileSystemChanges(true);
    }

    public static String getOSDependTypeScriptServicesPathByDirectory(String path2) {
        String normalizePath = StringUtil.trimEnd((String)FileUtil.normalize((String)path2), (String)"/");
        return FileUtil.toSystemDependentName((String)normalizePath);
    }

    public static boolean acceptFileType(FileType type) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
    }

    @Deprecated
    public boolean isGenerateSourceMap() {
        return this.myState.getGenerateSourceMap();
    }

    @Deprecated
    public void setGenerateSourceMap(boolean generateSourceMap) {
        this.myState.setGenerateSourceMap(generateSourceMap);
    }

    @Deprecated
    public boolean isHasOutDirectory() {
        return this.myState.getHasOutDirectory();
    }

    @Deprecated
    public void setHasOutDirectory(boolean pHasOutPath) {
        this.myState.setHasOutDirectory(pHasOutPath);
    }

    @Deprecated
    public String getOutDirectory() {
        return this.myState.getOutDirectory();
    }

    @Deprecated
    public void setOutDirectory(String outDirectory) {
        this.myState.setOutDirectory(StringUtil.nullize((String)outDirectory, (boolean)true));
    }

    @Deprecated
    @Nullable
    public String getMainFilePath() {
        return this.myState.getMainFilePath();
    }

    @Deprecated
    public void setMainFilePath(String mainFilePath) {
        this.myState.setMainFilePath(StringUtil.nullize((String)mainFilePath, (boolean)true));
    }

    @Deprecated
    public boolean isUseMainFile() {
        return this.myState.getUseMainFile();
    }

    @Deprecated
    public void setUseMainFile(boolean useMainFile) {
        this.myState.setUseMainFile(useMainFile);
    }

    public boolean useMainFile() {
        return this.useDeprecatedSettings() && this.isUseMainFile();
    }

    public static boolean isTypeScriptToolWindowEnable() {
        return PlatformUtils.isRider() || Registry.is((String)"ts.tool.window.show");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScopeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeScriptServiceDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScopeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeScriptCompilerVersionType {
        EMBEDDED_OR_DETECTED,
        EMBEDDED,
        SERVICE_DIRECTORY;

    }
}

