/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNavigateToAlreadyDeclaredVariableFix
extends IntentionAndQuickFixAction {
    @NotNull
    private final SmartPsiElementPointer<JSElement> myVariable;
    @Nullable
    private final String myName;

    @Contract(pure=true)
    public JSNavigateToAlreadyDeclaredVariableFix(@NotNull JSElement variable) {
        if (variable == null) {
            JSNavigateToAlreadyDeclaredVariableFix.$$$reportNull$$$0(0);
        }
        this.myName = variable.getName();
        this.myVariable = SmartPointerManager.getInstance((Project)variable.getProject()).createSmartPsiElementPointer((PsiElement)variable);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myName == null ? JavaScriptBundle.message("javascript.validation.message.duplicate.declaration.fix.text.no.name", new Object[0]) : JavaScriptBundle.message("javascript.validation.message.duplicate.declaration.fix.text", this.myName);
        if (string == null) {
            JSNavigateToAlreadyDeclaredVariableFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.validation.message.duplicate.declaration.fix.text.no.name", new Object[0]);
        if (string == null) {
            JSNavigateToAlreadyDeclaredVariableFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file2, @Nullable Editor editor) {
        JSElement element;
        if (project == null) {
            JSNavigateToAlreadyDeclaredVariableFix.$$$reportNull$$$0(3);
        }
        if ((element = (JSElement)this.myVariable.getElement()) != null) {
            element.navigate(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSNavigateToAlreadyDeclaredVariableFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSNavigateToAlreadyDeclaredVariableFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

