/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

final class FlowJSConfigurationPanel {
    private final JPanel myPanel;
    private final TextFieldWithHistoryWithBrowseButton myFlowExecutable;
    private final JCheckBox myTypeChecking;
    private final JCheckBox myOtherServices;
    private final JCheckBox myAutosaveCheckBox;
    private final Project myProject;
    private final NotNullLazyValue<FlowJSExecutables> myFlowExecutables;

    FlowJSConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFlowExecutables = NotNullLazyValue.lazy(() -> new FlowJSExecutables(FlowJSServerService.calcPossibleFlowExecutableFiles(this.myProject)));
        this.myFlowExecutable = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JavaScriptBundle.message("js.flow.settings.executable.dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), () -> ((FlowJSExecutables)this.myFlowExecutables.getValue()).getPaths());
        ((TextFieldWithHistory)this.myFlowExecutable.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlowJSConfigurationPanel.this.updateEnabled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel$1", "textChanged"));
            }
        });
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(project).getState();
        this.myTypeChecking = new JBCheckBox(JavaScriptBundle.message("js.flow.enable.type.checking", new Object[0]), settings.isTypeCheckingEnabled());
        this.myTypeChecking.addChangeListener(e -> this.updateEnabled());
        this.myOtherServices = new JBCheckBox(JavaScriptBundle.message("js.flow.enable.other.services", new Object[0]), settings.isOtherServicesEnabled());
        this.myAutosaveCheckBox = new JBCheckBox(JavaScriptBundle.message("js.flow.settings.auto.save", new Object[0]), settings.isAutoSaveEnabled());
        ComponentPanelBuilder builder = new ComponentPanelBuilder((JComponent)this.myAutosaveCheckBox).withComment(JavaScriptBundle.message(FlowJSServerManager.preferLsp() ? "js.flow.settings.auto.save.warning.lsp" : "js.flow.settings.auto.save.warning", new Object[0]));
        this.myPanel = FormBuilder.createFormBuilder().setVerticalGap(8).addSeparator().addLabeledComponent(JavaScriptBundle.message("js.flow.settings.executable.label", new Object[0]), (JComponent)this.myFlowExecutable).addComponent((JComponent)new JBLabel(JavaScriptBundle.message("js.flow.services.label", new Object[0]))).addComponent((JComponent)this.myTypeChecking).addComponent((JComponent)this.myOtherServices).addSeparator().addComponent((JComponent)builder.createPanel()).getPanel();
        this.myPanel.setVisible(false);
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public FlowJSSettings getFlowSettings() {
        FlowJSSettings settings = new FlowJSSettings();
        settings.setFlowPath(this.myFlowExecutable.getText());
        settings.setTypeCheckingEnabled(this.myTypeChecking.isSelected());
        settings.setOtherServicesEnabled(this.myOtherServices.isSelected());
        settings.setAutoSaveEnabled(this.myAutosaveCheckBox.isSelected());
        FlowJSSettings flowJSSettings = settings;
        if (flowJSSettings == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(1);
        }
        return flowJSSettings;
    }

    public void setFlowSettings(@NotNull FlowJSSettings settings) {
        if (settings == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(2);
        }
        String path2 = settings.getFlowExecutablePath();
        this.myFlowExecutable.setTextAndAddToHistory(FileUtil.toSystemIndependentName((String)path2));
        if (!path2.isEmpty()) {
            this.myTypeChecking.setSelected(settings.isTypeCheckingEnabled());
            this.myOtherServices.setSelected(settings.isOtherServicesEnabled());
            this.myAutosaveCheckBox.setSelected(settings.isAutoSaveEnabled());
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                List<String> executables;
                if (StringUtil.isEmpty((String)FlowJSConfigurationPanel.this.myFlowExecutable.getText()) && !(executables = ((FlowJSExecutables)FlowJSConfigurationPanel.this.myFlowExecutables.getValue()).getPaths()).isEmpty()) {
                    FlowJSConfigurationPanel.this.myFlowExecutable.setText(executables.get(0));
                    FlowJSConfigurationPanel.this.myTypeChecking.setSelected(false);
                }
            }
        });
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean pathIsEmpty = this.myFlowExecutable.getText().isEmpty();
        boolean typeCheckSelected = this.myTypeChecking.isSelected();
        this.myTypeChecking.setEnabled(!pathIsEmpty);
        this.myOtherServices.setEnabled(!pathIsEmpty && typeCheckSelected);
        this.myAutosaveCheckBox.setEnabled(!pathIsEmpty && typeCheckSelected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFlowSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlowJSExecutables {
        @NotNull
        private final List<? extends FlowJSSettings.FlowJSExecutable> myExecutables;

        FlowJSExecutables(@NotNull List<? extends FlowJSSettings.FlowJSExecutable> executables) {
            if (executables == null) {
                FlowJSExecutables.$$$reportNull$$$0(0);
            }
            this.myExecutables = executables;
        }

        public List<String> getPaths() {
            return ContainerUtil.map(this.myExecutables, FlowJSSettings.FlowJSExecutable::getPackageOrExePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executables", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel$FlowJSExecutables", "<init>"));
        }
    }
}

