/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.JSCodeFragment;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSExtractFunctionUtil {
    JSExtractFunctionUtil() {
    }

    @Nullable
    static JSCodeFragment getCodeFragment(@Nullable PsiElement statement, @Nullable PsiElement statement2, int start, int end) {
        Pair expressionDescriptor;
        PsiElement atEnd;
        if (statement == null) {
            return null;
        }
        PsiFile file2 = statement.getContainingFile();
        if (file2 == null) {
            return null;
        }
        if (statement2 != null && (atEnd = file2.findElementAt(end)) != null && atEnd.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
            end += atEnd.getTextLength();
        }
        TextRange possibleRange = new TextRange(start, end);
        PsiElement psiElement = statement2 = statement2 instanceof PsiWhiteSpace ? PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement2) : statement2;
        if (statement == statement2 && !JSExtractFunctionUtil.containsElement(possibleRange, statement) && (expressionDescriptor = (Pair)ContainerUtil.getLastItem(JSIntroducedExpressionUtil.findExpressionsInRange(file2, start, end))) != null) {
            return new JSCodeFragment(ContainerUtil.emptyList(), (Pair<JSExpression, TextRange>)expressionDescriptor);
        }
        ArrayList<PsiElement> statementsToExtract = new ArrayList<PsiElement>();
        while (statement != null) {
            TextRange textRange = statement.getTextRange();
            if (!possibleRange.contains(textRange)) {
                boolean nonws;
                boolean intersects = textRange.intersectsStrict(possibleRange);
                boolean bl = nonws = !(statement instanceof PsiWhiteSpace);
                if (nonws || !intersects) {
                    if (!nonws || !intersects || textRange.contains(possibleRange)) break;
                    return null;
                }
            }
            if (!JSExtractFunctionUtil.isAcceptableStatementLevelElement(statement)) {
                return null;
            }
            statementsToExtract.add(statement);
            if (statement == statement2) break;
            statement = statement.getNextSibling();
        }
        return new JSCodeFragment(statementsToExtract, null);
    }

    static boolean isAcceptableStatementLevelElement(PsiElement n) {
        if (n instanceof PsiComment || n instanceof PsiWhiteSpace) {
            PsiElement parent = n.getParent();
            return (parent instanceof JSBlockStatement || parent instanceof JSExecutionScope || parent instanceof JSCaseClause) && !(parent instanceof JSExpression);
        }
        if (n instanceof JSStatement) {
            return !(n instanceof JSPackageStatement || n instanceof JSImportStatement || n instanceof JSBlockStatement && n.getParent() instanceof JSFunction || n.getParent() instanceof JSClass && JSClassUtils.isES6ClassImplementation(n));
        }
        if (n instanceof JSFunction) {
            return !(n instanceof JSFunctionExpression);
        }
        return false;
    }

    @Nullable
    @NlsContexts.DialogMessage
    static String checkControlFlow(@NotNull JSCodeFragment codeFragment, @NotNull TextRange range, @NotNull Set<JSReturnStatement> returnStatements, @NotNull Set<JSYieldExpression> yieldExpressions, @NotNull Set<JSContinueStatement> continueStatementsToReplaceWithReturn) {
        if (codeFragment == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(1);
        }
        if (returnStatements == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(2);
        }
        if (yieldExpressions == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(3);
        }
        if (continueStatementsToReplaceWithReturn == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(4);
        }
        if (codeFragment.getExpression() != null) {
            return null;
        }
        PsiElement contextElement = codeFragment.getStatementElements().get(0);
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getContextOfType((PsiElement)contextElement, (Class[])new Class[]{JSExecutionScope.class});
        if (scope == null) {
            return null;
        }
        JSLoopStatement loopWithCompletelyExtractedBody = JSExtractFunctionUtil.getStatementWithCompletelyExtractedBody(codeFragment);
        THashSet outerInstructions = new THashSet();
        JSControlFlowService.JSControlFlow flow = JSControlFlowService.getService(contextElement.getProject()).getControlFlow(scope);
        Object[] instructions = flow.getInstructions();
        Instruction exitInstruction = (Instruction)ArrayUtil.getLastElement((Object[])instructions);
        for (Object instruction : instructions) {
            JSStatement statementToBreak;
            PsiElement element;
            if (instruction instanceof JSEntryPointInstruction || (element = instruction.getElement()) instanceof JSParameter || element instanceof JSParameterList || !JSExtractFunctionUtil.containsElement(range, element)) continue;
            if (element instanceof JSBreakStatement && !JSExtractFunctionUtil.containsElement(range, (PsiElement)(statementToBreak = ((JSBreakStatement)element).getStatementToBreak()))) {
                return statementToBreak instanceof JSSwitchStatement ? JavaScriptBundle.message("javascript.refactoring.extract.function.no.switch.for.break", new Object[0]) : JavaScriptBundle.message("javascript.refactoring.extract.function.no.loop.for.break", new Object[0]);
            }
            if (element instanceof JSContinueStatement) {
                JSStatement statementToContinue = ((JSContinueStatement)element).getStatementToContinue();
                if (loopWithCompletelyExtractedBody != null && loopWithCompletelyExtractedBody == statementToContinue) {
                    continueStatementsToReplaceWithReturn.add((JSContinueStatement)element);
                } else if (!JSExtractFunctionUtil.containsElement(range, (PsiElement)statementToContinue)) {
                    return JavaScriptBundle.message("javascript.refactoring.extract.function.no.loop.for.continue", new Object[0]);
                }
            }
            if (element instanceof JSReturnStatement) {
                returnStatements.add((JSReturnStatement)element);
            }
            if (element instanceof JSYieldExpression) {
                yieldExpressions.add((JSYieldExpression)element);
            }
            for (Instruction next : JSExtractFunctionUtil.getNextInstructions((Instruction)instruction)) {
                JSFunctionExitPoint throwStatement;
                PsiElement nextElement = next.getElement();
                if (next == exitInstruction && JSExtractFunctionUtil.containsElement(range, (PsiElement)(throwStatement = (JSFunctionExitPoint)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSThrowStatement.class, JSThrowExpression.class}))) || next != exitInstruction && JSExtractFunctionUtil.containsElement(range, nextElement)) continue;
                outerInstructions.add(next);
            }
        }
        if (outerInstructions.size() > 1) {
            return JavaScriptBundle.message("javascript.refactoring.extract.function.multiple.exit.points", new Object[0]);
        }
        if (returnStatements.size() > 0 && yieldExpressions.size() > 0) {
            return JavaScriptBundle.message("javascript.refactoring.extract.function.yield.and.return", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static Set<Instruction> getNextInstructions(@NotNull Instruction instruction) {
        if (instruction == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(5);
        }
        HashSet<Instruction> result2 = new HashSet<Instruction>();
        HashSet<Instruction> processed = new HashSet<Instruction>();
        ArrayDeque<Instruction> toProcess = new ArrayDeque<Instruction>();
        processed.add(instruction);
        toProcess.add(instruction);
        while (!toProcess.isEmpty()) {
            for (Instruction next : ((Instruction)toProcess.poll()).allSucc()) {
                if (next.getElement() != null || next.allSucc().isEmpty()) {
                    result2.add(next);
                    continue;
                }
                if (!processed.add(next)) continue;
                toProcess.offer(next);
            }
        }
        HashSet<Instruction> hashSet = result2;
        if (hashSet == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Nullable
    private static JSLoopStatement getStatementWithCompletelyExtractedBody(@NotNull JSCodeFragment fragment) {
        if (fragment == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(7);
        }
        if (fragment.getExpression() != null) {
            return null;
        }
        PsiElement first = (PsiElement)ContainerUtil.getFirstItem(fragment.getStatementElements());
        PsiElement last = (PsiElement)ContainerUtil.getLastItem(fragment.getStatementElements());
        PsiElement beforeFirst = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)first);
        PsiElement afterLast = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)last);
        JSLoopStatement loop = (JSLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)first, JSLoopStatement.class);
        if (beforeFirst != null && beforeFirst.getNode().getElementType() == JSTokenTypes.LBRACE && afterLast != null && afterLast.getNode().getElementType() == JSTokenTypes.RBRACE && loop == PsiTreeUtil.getParentOfType((PsiElement)last, JSLoopStatement.class)) {
            return loop;
        }
        return null;
    }

    @Contract(value="_, null -> false")
    private static boolean containsElement(@NotNull TextRange range, @Nullable PsiElement element) {
        if (range == null) {
            JSExtractFunctionUtil.$$$reportNull$$$0(8);
        }
        if (element == null) {
            return false;
        }
        TextRange elementTextRange = element.getTextRange();
        return elementTextRange != null && range.contains(elementTextRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yieldExpressions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueStatementsToReplaceWithReturn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkControlFlow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextInstructions";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStatementWithCompletelyExtractedBody";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

