/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isConstantExpression(JSExpression expression, boolean includeVars) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor(includeVars);
        expression.accept(visitor);
        return visitor.isConstant;
    }

    public static boolean isIncrementDecrementExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ExpressionUtil.$$$reportNull$$$0(0);
        }
        if (expression instanceof JSPostfixExpression) {
            IElementType operator = ((JSPostfixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        if (expression instanceof JSPrefixExpression) {
            IElementType operator = ((JSPrefixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        return false;
    }

    public static int computeIncrementDecrementAmount(@Nullable PsiElement expression) {
        if (expression == null) {
            return 0;
        }
        if (expression instanceof JSPostfixExpression || expression instanceof JSPrefixExpression) {
            return ExpressionUtil.computeIncrementDecrementAmount((JSExpressionWithOperationNode)expression);
        }
        return 0;
    }

    private static int computeIncrementDecrementAmount(@NotNull JSExpressionWithOperationNode expression) {
        IElementType operator;
        if (expression == null) {
            ExpressionUtil.$$$reportNull$$$0(1);
        }
        if (JSTokenTypes.PLUSPLUS == (operator = expression.getOperationSign())) {
            return 1;
        }
        if (JSTokenTypes.MINUSMINUS == operator) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        return ExpressionUtil.computeConstantExpression(expression, new JSComputeConstantExpressionVisitor(expression.getParent()));
    }

    public static Object computeConstantExpression(@Nullable JSExpression expression, Map<String, Object> computedEnumFields) {
        if (expression == null) {
            return null;
        }
        return ExpressionUtil.computeConstantExpression(expression, new JSComputeConstantExpressionVisitor(expression.getParent(), computedEnumFields));
    }

    private static Object computeConstantExpression(@Nullable JSExpression expression, JSComputeConstantExpressionVisitor visitor) {
        if (expression == null) {
            return null;
        }
        expression.accept(visitor);
        return visitor.getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncrementDecrementExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIncrementDecrementAmount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JSComputeConstantExpressionVisitor
    extends JSElementVisitor {
        private final Stack<Object> myStack = new Stack();
        private final PsiElement myParent;
        private final Map<String, Object> myComputedEnumFields;

        private JSComputeConstantExpressionVisitor(PsiElement parent) {
            this.myParent = parent;
            this.myComputedEnumFields = new HashMap<String, Object>();
        }

        private JSComputeConstantExpressionVisitor(PsiElement parent, Map<String, Object> computedEnumFields) {
            this.myParent = parent;
            this.myComputedEnumFields = computedEnumFields;
        }

        @Nullable
        private Object getResult() {
            if (this.myStack.isEmpty()) {
                return null;
            }
            Object res = this.myStack.pop();
            if (res == null) {
                this.myStack.clear();
            }
            return res;
        }

        @Override
        public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
            JSExpression innerExpression = node.getInnerExpression();
            if (innerExpression != null) {
                innerExpression.accept(this);
            }
        }

        @Override
        public void visitJSLiteralExpression(JSLiteralExpression node) {
            Object value = null;
            String text = node.getText();
            if (node.isNumericLiteral()) {
                value = node.getValue();
            } else if (node.isQuotedLiteral()) {
                value = node instanceof JSStringTemplateExpression ? String.valueOf(node.getStringValue()) : StringUtil.unquoteString((String)text);
            } else {
                boolean equalsWithTrue = "true".equals(text);
                if (equalsWithTrue || "false".equals(text)) {
                    value = equalsWithTrue;
                }
            }
            this.pushValue(value);
        }

        private void pushValue(Object value) {
            int intValue;
            if (value instanceof Double) {
                intValue = (int)((Double)value).doubleValue();
                if (Double.valueOf(intValue).equals(value)) {
                    value = intValue;
                } else {
                    long rounded = (long)((Double)value).doubleValue();
                    if (Double.valueOf(rounded).equals(value)) {
                        value = rounded;
                    }
                }
            }
            if (value instanceof Long && Long.valueOf(intValue = (int)((Long)value).longValue()).equals(value)) {
                value = intValue;
            }
            this.myStack.push(value);
        }

        @Override
        public void visitJSConditionalExpression(JSConditionalExpression node) {
            JSExpression expression;
            Object value;
            JSExpression condition = node.getCondition();
            if (condition != null) {
                condition.accept(this);
            }
            if ((value = this.getResult()) == null) {
                return;
            }
            JSExpression jSExpression = expression = JSComputeConstantExpressionVisitor.toBoolean(value) != false ? node.getThen() : node.getElse();
            if (expression == null) {
                return;
            }
            expression.accept(this);
        }

        @Override
        public void visitJSPrefixExpression(JSPrefixExpression node) {
            JSExpression expression = node.getExpression();
            if (expression == null) {
                return;
            }
            expression.accept(this);
            Object value = this.getResult();
            if (value == null) {
                return;
            }
            IElementType operationSign = node.getOperationSign();
            Number number = JSComputeConstantExpressionVisitor.toNumber(value);
            if (operationSign == JSTokenTypes.MINUS) {
                value = -number.doubleValue();
            } else if (operationSign == JSTokenTypes.TILDE) {
                value = number.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (operationSign == JSTokenTypes.EXCL) {
                value = JSComputeConstantExpressionVisitor.toBoolean(value) == false;
            } else if (operationSign == JSTokenTypes.PLUS) {
                value = number;
            }
            this.pushValue(value);
        }

        @Override
        public void visitJSReferenceExpression(JSReferenceExpression node) {
            JSExpression qualifier = node.getQualifier();
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return;
            }
            if (!(this.myParent instanceof TypeScriptEnumField)) {
                return;
            }
            String name = ((TypeScriptEnumField)this.myParent).getName();
            if (this.myComputedEnumFields.containsKey(name)) {
                this.pushValue(this.myComputedEnumFields.get(name));
                return;
            }
            TypeScriptEnum owner = ((TypeScriptEnumField)this.myParent).getOwner();
            if (owner == null) {
                return;
            }
            if (qualifier != null && !Objects.equals(owner.getName(), ((JSReferenceExpression)qualifier).getReferenceName())) {
                return;
            }
            JSField[] fields = owner.getFields();
            int prevIntValue = -1;
            for (JSField field : fields) {
                if (field == this.myParent || field.getTextOffset() >= this.myParent.getTextOffset()) break;
                JSExpression fieldInitializer = field.getInitializer();
                if (fieldInitializer == null) {
                    ++prevIntValue;
                    if (!(field instanceof TypeScriptEnumField) || !Objects.equals(field.getName(), node.getReferenceName())) continue;
                    this.pushValue(prevIntValue);
                    this.myComputedEnumFields.put(field.getName(), prevIntValue);
                    return;
                }
                Object constantValue = ExpressionUtil.computeConstantExpression(fieldInitializer, new JSComputeConstantExpressionVisitor(fieldInitializer.getParent(), this.myComputedEnumFields));
                if (constantValue == null) continue;
                if (field instanceof TypeScriptEnumField && Objects.equals(field.getName(), node.getReferenceName())) {
                    this.pushValue(constantValue);
                    this.myComputedEnumFields.put(field.getName(), constantValue);
                    return;
                }
                if (!(constantValue instanceof Number)) break;
                prevIntValue = ((Number)constantValue).intValue();
            }
        }

        @Override
        public void visitJSPostfixExpression(JSPostfixExpression node) {
            JSExpression expression = node.getExpression();
            if (expression == null) {
                return;
            }
            expression.accept(this);
            Object result2 = this.getResult();
            if (result2 == null) {
                return;
            }
            Number number = JSComputeConstantExpressionVisitor.toNumber(result2);
            Number value = JSComputeConstantExpressionVisitor.computeIncrementDecrementExpression(number, node.getOperationSign());
            this.pushValue(value);
        }

        @Override
        public void visitJSBinaryExpression(JSBinaryExpression node) {
            JSExpression lOperand = node.getLOperand();
            if (lOperand == null) {
                return;
            }
            lOperand.accept(this);
            Object leftValue = this.getResult();
            if (leftValue == null) {
                return;
            }
            JSExpression rOperand = node.getROperand();
            if (rOperand == null) {
                return;
            }
            rOperand.accept(this);
            Object rightValue = this.getResult();
            if (rightValue == null) {
                return;
            }
            Object value = null;
            IElementType operationSign = node.getOperationSign();
            if (operationSign == JSTokenTypes.EQEQEQ || operationSign == JSTokenTypes.NEQEQ) {
                boolean eq = leftValue.equals(rightValue);
                value = operationSign == JSTokenTypes.EQEQEQ == eq;
            }
            if (operationSign == JSTokenTypes.EQEQ) {
                value = JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
            } else if (operationSign == JSTokenTypes.NE) {
                value = !JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
            } else if (operationSign == JSTokenTypes.ANDAND) {
                Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                value = leftBoolean == false ? leftValue : rightValue;
            } else if (operationSign == JSTokenTypes.OROR) {
                Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                value = leftBoolean != false ? leftValue : rightValue;
            } else if (operationSign == JSTokenTypes.PLUS && (leftValue instanceof String || rightValue instanceof String)) {
                value = leftValue.toString() + rightValue.toString();
            } else if (leftValue instanceof BigInteger && rightValue instanceof BigInteger) {
                BigInteger leftNumber = (BigInteger)leftValue;
                BigInteger rightNumber = (BigInteger)rightValue;
                if (operationSign == JSTokenTypes.PLUS) {
                    value = leftNumber.add(rightNumber);
                } else if (operationSign == JSTokenTypes.MINUS) {
                    value = leftNumber.subtract(rightNumber);
                } else if (operationSign == JSTokenTypes.MULT) {
                    value = leftNumber.multiply(rightNumber);
                } else if (operationSign == JSTokenTypes.MULTMULT) {
                    value = leftNumber.pow(rightNumber.intValue());
                } else if (operationSign == JSTokenTypes.DIV && !BigInteger.ZERO.equals(rightNumber)) {
                    value = leftNumber.divide(rightNumber);
                } else if (operationSign == JSTokenTypes.PERC) {
                    value = leftNumber.remainder(rightNumber);
                } else if (operationSign == JSTokenTypes.LTLT) {
                    value = leftNumber.shiftLeft(rightNumber.intValue());
                } else if (operationSign == JSTokenTypes.GTGT) {
                    value = leftNumber.shiftRight(rightNumber.intValue());
                } else if (operationSign == JSTokenTypes.LT) {
                    value = leftNumber.compareTo(rightNumber) < 0;
                } else if (operationSign == JSTokenTypes.GT) {
                    value = leftNumber.compareTo(rightNumber) > 0;
                } else if (operationSign == JSTokenTypes.LE) {
                    value = leftNumber.compareTo(rightNumber) <= 0;
                } else if (operationSign == JSTokenTypes.GE) {
                    value = leftNumber.compareTo(rightNumber) >= 0;
                } else if (operationSign == JSTokenTypes.AND) {
                    value = leftNumber.and(rightNumber);
                } else if (operationSign == JSTokenTypes.OR) {
                    value = leftNumber.or(rightNumber);
                } else if (operationSign == JSTokenTypes.XOR) {
                    value = leftNumber.xor(rightNumber);
                }
            } else {
                Number leftNumber = JSComputeConstantExpressionVisitor.toNumber(leftValue);
                Number rightNumber = JSComputeConstantExpressionVisitor.toNumber(rightValue);
                if (operationSign == JSTokenTypes.PLUS) {
                    value = leftNumber.doubleValue() + rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MINUS) {
                    value = leftNumber.doubleValue() - rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MULT) {
                    value = leftNumber.doubleValue() * rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MULTMULT) {
                    value = Math.pow(leftNumber.doubleValue(), rightNumber.doubleValue());
                } else if (operationSign == JSTokenTypes.DIV) {
                    value = leftNumber.doubleValue() / rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.PERC) {
                    value = leftNumber.doubleValue() % rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LTLT) {
                    value = leftNumber.longValue() << (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGT) {
                    value = leftNumber.longValue() >> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGTGT) {
                    value = leftNumber.longValue() >>> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.LT) {
                    value = leftNumber.doubleValue() < rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GT) {
                    value = leftNumber.doubleValue() > rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LE) {
                    value = leftNumber.doubleValue() <= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GE) {
                    value = leftNumber.doubleValue() >= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.AND) {
                    value = leftNumber.longValue() & rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.OR) {
                    value = leftNumber.longValue() | rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.XOR) {
                    value = leftNumber.longValue() ^ rightNumber.longValue();
                }
            }
            this.pushValue(value);
        }

        @NotNull
        private static Number toNumber(Object value) {
            Number number = value instanceof String ? (Number)JSComputeConstantExpressionVisitor.getNumericValue((String)value) : (Number)(value instanceof Boolean ? (Number)((Boolean)value != false ? 1L : 0L) : (Number)((Number)value));
            Number number2 = number;
            if (number2 == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(0);
            }
            return number2;
        }

        @NotNull
        private static Number getNumericValue(String text) {
            Double numeric;
            BigInteger bigInteger = JSNumberParser.tryParseBigInt(text);
            if (bigInteger != null) {
                BigInteger bigInteger2 = bigInteger;
                if (bigInteger2 == null) {
                    JSComputeConstantExpressionVisitor.$$$reportNull$$$0(1);
                }
                return bigInteger2;
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'+')) {
                text = text.substring(1);
            }
            Double d = (numeric = JSNumberParser.tryParseNumericValue(text, false)) == null ? Double.valueOf(Double.NaN) : numeric;
            if (d == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(2);
            }
            return d;
        }

        @NotNull
        private static Boolean toBoolean(Object value) {
            double doubleValue;
            Boolean v = value instanceof String ? Boolean.valueOf(((String)value).length() > 0) : (value instanceof Number ? Boolean.valueOf((doubleValue = ((Number)value).doubleValue()) != 0.0 && !Double.isNaN(doubleValue)) : (Boolean)value);
            Boolean bl = v;
            if (bl == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(3);
            }
            return bl;
        }

        private static boolean computeEquality(Object leftValue, Object rightValue) {
            if (leftValue instanceof BigInteger && rightValue instanceof BigInteger) {
                return leftValue.equals(rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            if (leftValue.getClass() == rightValue.getClass()) {
                return leftValue.equals(rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof String) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            if (leftValue instanceof String && rightValue instanceof Number) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (leftValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (rightValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            return false;
        }

        @Nullable
        private static Number computeIncrementDecrementExpression(@NotNull Number value, IElementType operationSign) {
            if (value == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(4);
            }
            Number v = null;
            if (operationSign == JSTokenTypes.PLUSPLUS) {
                v = value instanceof BigInteger ? ((BigInteger)value).add(BigInteger.ONE) : Long.valueOf(value.longValue() + 1L);
            } else if (operationSign == JSTokenTypes.MINUSMINUS) {
                v = value instanceof BigInteger ? ((BigInteger)value).subtract(BigInteger.ONE) : Long.valueOf(value.longValue() - 1L);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/ExpressionUtil$JSComputeConstantExpressionVisitor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toNumber";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNumericValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBoolean";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/ExpressionUtil$JSComputeConstantExpressionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeIncrementDecrementExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IsConstantExpressionVisitor
    extends JSElementVisitor {
        private final boolean myIncludeVars;
        protected boolean isConstant;
        private final Map<JSConstStatusOwner, Boolean> isVariableConstant = new HashMap<JSConstStatusOwner, Boolean>();
        private static final int MAX_WALK_DEPTH = JavaScriptParserBase.MAX_TREE_DEPTH;
        private int myWalkDepth = 0;

        IsConstantExpressionVisitor(boolean includeVars) {
            this.myIncludeVars = includeVars;
        }

        @Override
        public void visitJSExpression(JSExpression expression) {
            this.isConstant = false;
        }

        @Override
        public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
            this.isConstant = stringTemplateExpression.getArguments().length == 0;
        }

        @Override
        public void visitJSLiteralExpression(JSLiteralExpression expression) {
            this.isConstant = true;
        }

        @Override
        public void visitJSParenthesizedExpression(JSParenthesizedExpression expression) {
            JSExpression expr = expression.getInnerExpression();
            if (expr != null) {
                expr.accept(this);
            }
        }

        @Override
        public void visitJSPrefixExpression(JSPrefixExpression expression) {
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        @Override
        public void visitJSPostfixExpression(JSPostfixExpression expression) {
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        public void visitJSPrefixOrPostfixExpression(@Nullable JSExpression operand, IElementType sign) {
            if (operand == null) {
                this.isConstant = false;
                return;
            }
            operand.accept(this);
            if (!this.isConstant) {
                return;
            }
            if (sign == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.TILDE || sign == JSTokenTypes.EXCL) {
                return;
            }
            this.isConstant = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitJSBinaryExpression(JSBinaryExpression expression) {
            if (this.myWalkDepth > MAX_WALK_DEPTH) {
                this.isConstant = false;
                return;
            }
            try {
                ++this.myWalkDepth;
                JSExpression lOperand = expression.getLOperand();
                if (lOperand == null) {
                    return;
                }
                lOperand.accept(this);
                if (!this.isConstant) {
                    return;
                }
                JSExpression rOperand = expression.getROperand();
                if (rOperand != null) {
                    rOperand.accept(this);
                }
            }
            finally {
                --this.myWalkDepth;
            }
        }

        @Override
        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            JSExpression thenExpr = expression.getThen();
            JSExpression elseExpr = expression.getElse();
            if (thenExpr == null || elseExpr == null) {
                this.isConstant = false;
                return;
            }
            JSExpression condition = expression.getCondition();
            if (condition != null) {
                condition.accept(this);
            }
            if (!this.isConstant) {
                return;
            }
            thenExpr.accept(this);
            if (!this.isConstant) {
                return;
            }
            elseExpr.accept(this);
        }

        @Override
        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            if (!this.myIncludeVars) {
                return;
            }
            PsiElement resolve = expression.resolve();
            if (!(resolve instanceof JSElement)) {
                return;
            }
            JSElement refElement = (JSElement)resolve;
            if (!(refElement instanceof JSConstStatusOwner)) {
                this.isConstant = false;
                return;
            }
            JSConstStatusOwner variable = (JSConstStatusOwner)((Object)refElement);
            Boolean isConst = this.isVariableConstant.get(variable);
            if (isConst != null) {
                this.isConstant &= isConst.booleanValue();
                return;
            }
            boolean variableIsConst = variable.isConst();
            this.isVariableConstant.put(variable, variableIsConst);
            this.isConstant = variableIsConst;
        }
    }
}

