/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.recordImpl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertySignatureCommonImpl
extends JSRecordType.PropertySignature {
    @Override
    @NotNull
    default public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (childTransform == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(0);
        }
        JSType oldType = this.getJSType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        JSRecordType.MemberSource oldMemberSource = this.getMemberSource();
        JSRecordType.MemberSource memberSource = JSRecordTypeImpl.getUpdatedTypeMemberSource(oldMemberSource, childTransform);
        if (oldType == type && memberSource == oldMemberSource) {
            PropertySignatureCommonImpl propertySignatureCommonImpl = this;
            if (propertySignatureCommonImpl == null) {
                PropertySignatureCommonImpl.$$$reportNull$$$0(1);
            }
            return propertySignatureCommonImpl;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(this.getMemberName(), type, this.isOptional(), this.isConst(), memberSource);
    }

    @Override
    default public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, @NotNull String typeSeparator, char quote) {
        if (format == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(3);
        }
        if (typeSeparator == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(4);
        }
        PropertySignatureCommonImpl.appendPresentation(this, format, builder, typeSeparator, quote, this.getMemberName());
    }

    public static void appendPresentation(@NotNull JSRecordType.PropertySignature signature, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, @NotNull String typeSeparator, char quote, @NotNull String name) {
        JSType propertyType;
        if (signature == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(5);
        }
        if (format == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(7);
        }
        if (typeSeparator == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(9);
        }
        if (signature.isConst()) {
            builder.append("readonly ");
        }
        String fixedName = JSSymbolUtil.handleSpecialPropertyNames(name, quote);
        builder.append(fixedName);
        if (signature.isOptional()) {
            builder.append("?");
        }
        if ((propertyType = signature.getJSType()) != null) {
            if (PropertySignatureCommonImpl.isFunctionMember(signature, propertyType)) {
                ((JSFunctionTypeImpl)propertyType).buildTypeTextImpl(format, builder, false);
            } else {
                boolean appendBrackets = propertyType.isJavaScript() && JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                builder.append(typeSeparator);
                if (appendBrackets) {
                    builder.append("(");
                }
                propertyType.buildTypeText(format, builder);
                if (appendBrackets) {
                    builder.append(")");
                }
            }
        }
    }

    @Override
    default public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        JSType type;
        if (visitor == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(10);
        }
        if ((type = this.getJSType()) != null) {
            type.accept(visitor);
        }
    }

    public static boolean isFunctionMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable JSType propertyType) {
        if (typeMember == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(11);
        }
        return propertyType instanceof JSFunctionTypeImpl && (typeMember instanceof JSRecordType.FunctionMember || typeMember.getMemberSource().getSingleElement() instanceof JSFunction);
    }

    @Override
    default public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context, boolean allowResolve) {
        return PropertySignatureCommonImpl.arePropertySignaturesEqual(this, other, context, allowResolve);
    }

    public static boolean arePropertySignaturesEqual(@NotNull JSRecordType.PropertySignature first, @Nullable JSRecordType.TypeMember otherRaw, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (first == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(12);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof JSRecordType.PropertySignature)) {
            return false;
        }
        JSRecordType.PropertySignature other = (JSRecordType.PropertySignature)otherRaw;
        return first.getMemberName().equals(other.getMemberName()) && (first.getJSType() != null ? first.getJSType().isEquivalentTo(other.getJSType(), processingContext, allowResolve) : other.getJSType() == null) && first.isOptional() == other.isOptional();
    }

    @Override
    default public int getMemberHashCode() {
        return Objects.hash(this.getClass(), this.getMemberName(), this.getJSType(), this.isOptional());
    }

    @Override
    @Nullable
    default public JSType getJSTypeWithOptionality() {
        JSType type = JSRecordType.PropertySignature.super.getJSTypeWithOptionality();
        if (this.isOptional() && type != null) {
            return TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSeparator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendMemberPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "arePropertySignaturesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

