/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTemplateLiteralJSTypeImpl
extends JSTypeBaseImpl
implements JSTemplateLiteralType,
JSType.CompositeStructure,
JSEvaluableType {
    private static final Logger LOG = Logger.getInstance(TypeScriptTemplateLiteralJSTypeImpl.class);
    public static final List<String> EMPTY_TEXTS = ContainerUtil.immutableList((Object[])new String[]{"", ""});
    @NotNull
    private final List<String> myTexts;
    @NotNull
    private final List<JSType> myTypes;
    private final boolean myAllowWidening;

    @NotNull
    public static JSType createType(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source2) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(2);
        }
        return TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types2, allowWidening, source2, false);
    }

    @NotNull
    private static JSType createType(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source2, boolean strict) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(5);
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("createType", texts, types2, source2);
        }
        boolean couldBeEffectivelyInlined = false;
        for (JSType type : types2) {
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                return new TypeScriptNeverJSTypeImpl(source2);
            }
            if (!(type instanceof JSPrimitiveLiteralType) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSTemplateLiteralType)) continue;
            couldBeEffectivelyInlined = true;
        }
        JSType type = TypeScriptTemplateLiteralJSTypeImpl.replaceWithPrimitiveIfPossible(texts, types2);
        if (type != null) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (couldBeEffectivelyInlined) {
            return TypeScriptTemplateLiteralJSTypeImpl.createInlinedTemplateLiteral(texts, types2, allowWidening, source2, strict);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(texts, types2, allowWidening, source2);
    }

    private static void traceTemplateTypeOperation(@NotNull String op, @NotNull List<String> texts, @NotNull List<JSType> types2, @NotNull JSTypeSource source2) {
        if (op == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(7);
        }
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(8);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(9);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(10);
        }
        if (!LOG.isTraceEnabled()) {
            return;
        }
        PsiElement element = source2.getSourceElement();
        if (element != null && element.isValid()) {
            String sourceText = element.getText();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            String path2 = file2 != null ? file2.getPath() : "null";
            String textsString = StringUtil.join(texts, t -> StringUtil.wrapWithDoubleQuote((String)t), (String)", ");
            LOG.trace(String.format("%s: texts=[%s], types=%s, sourceElement=%s, path=%s", op, textsString, types2, sourceText, path2));
        }
    }

    @Nullable
    private static JSType replaceWithPrimitiveIfPossible(@NotNull List<String> texts, @NotNull List<JSType> types2) {
        JSType type;
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(11);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (texts.size() == 2 && ContainerUtil.all(texts, text -> text.isEmpty()) && types2.size() == 1 && (type = types2.get(0)) instanceof JSStringType && !(type instanceof JSPrimitiveLiteralType)) {
            return type;
        }
        return null;
    }

    private TypeScriptTemplateLiteralJSTypeImpl(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source2) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(14);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(15);
        }
        super(source2);
        this.myTexts = texts;
        this.myTypes = types2;
        this.myAllowWidening = allowWidening;
    }

    TypeScriptTemplateLiteralJSTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (inputStream == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(17);
        }
        super(source2);
        this.myTexts = JSTypeSerializer.STRING_LIST.read(source2, inputStream);
        this.myTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source2, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(18);
        }
        super.serialize(outputStream);
        JSTypeSerializer.STRING_LIST.write(this.myTexts, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myTypes, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public JSType widen(boolean allowResolve) {
        JSTypeBaseImpl jSTypeBaseImpl = this.allowWidening() ? new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE) : this;
        if (jSTypeBaseImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(19);
        }
        return jSTypeBaseImpl;
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSType copyWithAllowWidening(boolean allowWidening) {
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public List<String> getTexts() {
        List<String> list2 = this.myTexts;
        if (list2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list2 = this.myTypes;
        if (list2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        List types2;
        if (childTransform == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (newSource == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(23);
        }
        return ContainerUtil.equalsIdentity(this.myTypes, (List)(types2 = ContainerUtil.map(this.myTypes, type -> JSTypeUtils.transformTypeHierarchySafe(type, childTransform)))) ? this : TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, types2, this.myAllowWidening, newSource);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(24);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, this.myAllowWidening, source2);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(25);
        }
        TypeScriptTemplateLiteralJSTypeImpl literalType = (TypeScriptTemplateLiteralJSTypeImpl)type;
        if (this.myTypes.size() != literalType.getTypes().size() || this.myTexts.size() != literalType.getTexts().size()) {
            return false;
        }
        if (!JSTypeCastUtil.areListsEquivalent(this.myTypes, literalType.getTypes(), context, allowResolve)) {
            return false;
        }
        return this.myTexts.equals(literalType.getTexts());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(26);
        }
        if (builder == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(27);
        }
        builder.append("`");
        builder.append((String)ContainerUtil.getFirstItem(this.myTexts, (Object)""));
        for (int i2 = 0; i2 < this.myTypes.size(); ++i2) {
            builder.append("${");
            JSType type = this.myTypes.get(i2);
            builder.append(type, format);
            builder.append("}");
            String text = this.myTexts.get(i2 + 1);
            builder.append(text);
        }
        builder.append("`");
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType substitute;
        if (context == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(28);
        }
        if (ContainerUtil.all(this.myTypes, TypeScriptTemplateLiteralJSTypeImpl::isPlaceholderOrGenericParameterType)) {
            return this;
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("substitute", this.myTexts, this.myTypes, this.getSource());
        }
        return (substitute = this.substituteConstituentTypes(context)) instanceof JSTemplateLiteralType ? TypeScriptTemplateLiteralJSTypeImpl.distributeTemplateLiteralType((JSTemplateLiteralType)substitute) : substitute;
    }

    private static boolean isPlaceholderOrGenericParameterType(@NotNull JSType t) {
        if (t == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(29);
        }
        return TypeScriptTypeRelations.isPatternLiteralPlaceholderType(t) || t instanceof JSGenericParameterType;
    }

    @NotNull
    private JSType substituteConstituentTypes(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(30);
        }
        ArrayList<JSType> substitutedTypes = null;
        boolean substituted = false;
        Iterator<JSType> iterator = this.myTypes.iterator();
        while (iterator.hasNext()) {
            JSType type;
            JSType newType = type = iterator.next();
            if (!(type instanceof JSPrimitiveType)) {
                newType = context.substituteNested(newType);
            }
            if (newType == null) {
                JSAnyType jSAnyType = JSAnyType.get(this.getSource());
                if (jSAnyType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(31);
                }
                return jSAnyType;
            }
            if (newType instanceof TypeScriptNeverJSTypeImpl) {
                JSType jSType = newType;
                if (jSType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(32);
                }
                return jSType;
            }
            if (type != (newType = TypeScriptTemplateLiteralJSTypeImpl.substituteConstituentType(newType))) {
                substituted = true;
            }
            if (substitutedTypes == null) {
                substitutedTypes = new ArrayList<JSType>();
            }
            substitutedTypes.add(newType);
        }
        JSType jSType = substituted ? TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, substitutedTypes, this.myAllowWidening, this.getSource(), true) : this;
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(33);
        }
        return jSType;
    }

    @NotNull
    private static JSType substituteConstituentType(@NotNull JSType newType) {
        if (newType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(34);
        }
        return TypeScriptTemplateLiteralJSTypeImpl.booleanTypeAsUnion(newType);
    }

    @NotNull
    public static JSType booleanTypeAsUnion(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(35);
        }
        if (type instanceof JSBooleanType && !(type instanceof JSPrimitiveLiteralType)) {
            type = TypeScriptTypeRelations.getAsUnionIfBooleanOrEnum(type);
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    private static JSType createInlinedTemplateLiteral(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source2, boolean strict) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(37);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(38);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(39);
        }
        SmartList newTexts = new SmartList();
        SmartList newTypes = new SmartList();
        StringBuilder text = new StringBuilder();
        text.append(texts.get(0));
        if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(texts, types2, (List<String>)newTexts, (List<JSType>)newTypes, text, strict)) {
            return new JSStringType(true, source2, JSTypeContext.INSTANCE);
        }
        if (newTypes.isEmpty()) {
            return new JSStringLiteralTypeImpl(text.toString(), allowWidening, source2);
        }
        newTexts.add(text.toString());
        return new TypeScriptTemplateLiteralJSTypeImpl((List<String>)newTexts, (List<JSType>)newTypes, allowWidening, source2);
    }

    @NotNull
    private static JSType distributeTemplateLiteralType(@NotNull JSTemplateLiteralType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(40);
        }
        List<JSType> types2 = type.getTypes();
        JSTypeSource source2 = type.getSource();
        if (!TypeScriptTypeRelations.checkCrossProductUnion(types2)) {
            JSAnyType jSAnyType = JSAnyType.get(source2);
            if (jSAnyType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSAnyType;
        }
        boolean distribute = false;
        for (JSType constituent : types2) {
            if (constituent instanceof JSUnionType) {
                distribute = true;
                continue;
            }
            if (!(constituent instanceof TypeScriptNeverJSTypeImpl)) continue;
            JSType jSType = constituent;
            if (jSType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(42);
            }
            return jSType;
        }
        if (!distribute) {
            JSTemplateLiteralType jSTemplateLiteralType = type;
            if (jSTemplateLiteralType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(43);
            }
            return jSTemplateLiteralType;
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("distribute", type.getTexts(), types2, source2);
        }
        SmartList constituents = new SmartList();
        TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents((Collection<JSType>)constituents, new ArrayDeque<JSType>(types2.size()), 0, type.getTexts(), types2, type.allowWidening(), source2);
        JSType jSType = JSCompositeTypeFactory.createUnionType(source2, (Collection<? extends JSType>)constituents);
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    private static void distributeTypeLiteralConstituents(@NotNull Collection<JSType> constituents, @NotNull Deque<JSType> current, int idx, @NotNull List<String> sourceTexts, @NotNull List<JSType> sourceTypes, boolean allowWidening, @NotNull JSTypeSource source2) {
        if (constituents == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(45);
        }
        if (current == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(46);
        }
        if (sourceTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(47);
        }
        if (sourceTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(48);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(49);
        }
        ProgressManager.checkCanceled();
        if (idx == sourceTypes.size()) {
            constituents.add(TypeScriptTemplateLiteralJSTypeImpl.createType(sourceTexts, new ArrayList<JSType>(current), allowWidening, source2));
            return;
        }
        JSType type = sourceTypes.get(idx);
        if (type instanceof JSUnionType) {
            List<JSType> childConstituents = ((JSUnionType)type).getTypes();
            for (JSType constituent : childConstituents) {
                current.addLast(constituent);
                TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents(constituents, current, idx + 1, sourceTexts, sourceTypes, allowWidening, source2);
                current.removeLast();
            }
        } else {
            current.addLast(type);
            TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents(constituents, current, idx + 1, sourceTexts, sourceTypes, allowWidening, source2);
            current.removeLast();
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myTexts, this.myTypes);
    }

    private static boolean addSpans(@NotNull List<String> texts, @NotNull List<JSType> types2, @NotNull List<String> newTexts, @NotNull List<JSType> newTypes, @NotNull StringBuilder text, boolean strict) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(50);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(51);
        }
        if (newTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(52);
        }
        if (newTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(53);
        }
        if (text == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(54);
        }
        for (int i2 = 0; i2 < types2.size(); ++i2) {
            JSType type = types2.get(i2);
            if (type instanceof JSPrimitiveLiteralType || type instanceof JSNullType || type instanceof JSUndefinedType) {
                text.append(TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(type));
                text.append(texts.get(i2 + 1));
                continue;
            }
            if (type instanceof JSTemplateLiteralType) {
                JSTemplateLiteralType literalType = (JSTemplateLiteralType)type;
                text.append(literalType.getTexts().get(0));
                if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(literalType.getTexts(), literalType.getTypes(), newTexts, newTypes, text, strict)) {
                    return false;
                }
                text.append(texts.get(i2 + 1));
                continue;
            }
            if (!strict || TypeScriptTypeRelations.isGenericIndexType(type) || TypeScriptTypeRelations.isPatternLiteralPlaceholderType(type)) {
                newTypes.add(type);
                newTexts.add(text.toString());
                text.setLength(0);
                text.append(texts.get(i2 + 1));
                continue;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static String getTemplateStringForType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(55);
        }
        if (type instanceof JSBooleanLiteralTypeImpl || type instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSPrimitiveLiteralType)type).getValueAsString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(56);
            }
            return string;
        }
        if (type instanceof JSBigIntLiteralTypeImpl) {
            String string = ((JSBigIntLiteralTypeImpl)type).getLiteral().toString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(57);
            }
            return string;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            String string = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(58);
            }
            return string;
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(59);
            }
            return string;
        }
        return "";
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(60);
        }
        visitor.visitTypeScriptTemplateLiteralType(this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(61);
        }
        for (JSType type : this.getTypes()) {
            type.accept(visitor);
        }
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(62);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(63);
        }
        if (elementType instanceof JSUnionType) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        boolean isProcessingGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        if (isProcessingGenerics) {
            return this.inferAndApplyGenerics(elementType, processingContext);
        }
        List<JSType> inferred = this.inferTypesFromTemplateLiteralType(elementType);
        return TypeScriptTypeRelations.everyType(inferred, this.myTypes, (source2, target) -> TypeScriptTemplateLiteralJSTypeImpl.isValidTypeForTemplateLiteralPlaceholder(source2, target, processingContext));
    }

    private boolean inferAndApplyGenerics(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        List<JSType> inferredTypes;
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(64);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(65);
        }
        boolean isInferred = !(inferredTypes = this.inferTypesFromTemplateLiteralType(elementType)).isEmpty();
        JSGenericMappings genericMappings = JSGenericTypesEvaluator.getGenericMappings(processingContext);
        assert (genericMappings != null);
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = genericMappings.getMapping();
        TypeScriptNeverJSTypeImpl defaultType = new TypeScriptNeverJSTypeImpl(this.getSource());
        for (int i2 = 0; i2 < this.myTypes.size(); ++i2) {
            JSGenericParameterImpl parameterType = (JSGenericParameterImpl)ObjectUtils.tryCast((Object)this.myTypes.get(i2), JSGenericParameterImpl.class);
            if (parameterType == null || !parameterType.isApplying()) continue;
            JSType inferredType = (JSType)ContainerUtil.getOrElse(inferredTypes, (int)i2, (Object)defaultType);
            if (inferredType instanceof TypeScriptNeverJSTypeImpl) {
                isInferred = false;
            }
            mapping.putValue((Object)parameterType.getGenericId(), (Object)inferredType);
        }
        return isInferred;
    }

    private static boolean isValidTypeForTemplateLiteralPlaceholder(@NotNull JSType source2, @NotNull JSType target, @NotNull ProcessingContext processingContext) {
        JSType constraint;
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(66);
        }
        if (target == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(67);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(68);
        }
        if ((constraint = TypeScriptTypeRelations.getBaseConstraintOfType(target, target.getSourceElement())) != null) {
            target = constraint;
        }
        if (source2 == target || target instanceof JSAnyType || target instanceof JSStringType && !(target instanceof JSStringLiteralTypeImpl)) {
            return true;
        }
        if (source2 instanceof JSStringLiteralTypeImpl && TypeScriptTemplateLiteralJSTypeImpl.isPlaceholderType(target)) {
            String literal = TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(source2);
            return target instanceof JSNumberType && TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal) || target instanceof JSBigIntType && TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal + "n") || target instanceof JSBooleanType && (literal.equals("true") || literal.equals("false")) || target instanceof JSUndefinedType && literal.equals("undefined") || target instanceof JSNullType && literal.equals("null");
        }
        if (source2 instanceof JSTemplateLiteralType) {
            List<String> texts = ((JSTemplateLiteralType)source2).getTexts();
            return texts.size() == 2 && texts.get(0).isEmpty() && texts.get(1).isEmpty() && target.isDirectlyAssignableType(((JSTemplateLiteralType)source2).getTypes().get(0), processingContext);
        }
        return target.isDirectlyAssignableType(source2, processingContext);
    }

    private static boolean isPlaceholderType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(69);
        }
        return type instanceof JSNumberType || type instanceof JSBigIntType || type instanceof JSBooleanType || type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    @NotNull
    private List<JSType> inferTypesFromTemplateLiteralType(@NotNull JSType source2) {
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(70);
        }
        if (source2 instanceof JSStringLiteralTypeImpl) {
            return this.inferFromLiteralPartsToTemplateLiteral(Collections.singletonList(TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(source2)), Collections.emptyList(), source2.getSource());
        }
        if (source2 instanceof JSTemplateLiteralType) {
            return this.getTexts().equals(((JSTemplateLiteralType)source2).getTexts()) ? ContainerUtil.map(((JSTemplateLiteralType)source2).getTypes(), TypeScriptTemplateLiteralJSTypeImpl::getStringLikeTypeForType) : this.inferFromLiteralPartsToTemplateLiteral(((JSTemplateLiteralType)source2).getTexts(), ((JSTemplateLiteralType)source2).getTypes(), source2.getSource());
        }
        List<JSType> list2 = Collections.emptyList();
        if (list2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(71);
        }
        return list2;
    }

    @NotNull
    private static JSType getStringLikeTypeForType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(72);
        }
        return type instanceof JSAnyType || type instanceof TypeScriptNeverJSTypeImpl || TypeScriptTypeRelations.isStringLike(type) ? type : TypeScriptTemplateLiteralJSTypeImpl.createType(EMPTY_TEXTS, Collections.singletonList(type), false, type.getSource());
    }

    @NotNull
    private List<JSType> inferFromLiteralPartsToTemplateLiteral(@NotNull List<String> sourceTexts, @NotNull List<JSType> sourceTypes, @NotNull JSTypeSource source2) {
        if (sourceTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(73);
        }
        if (sourceTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(74);
        }
        if (source2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(75);
        }
        if (sourceTexts.isEmpty()) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(76);
            }
            return list2;
        }
        int lastSourceIndex = sourceTexts.size() - 1;
        String sourceStartText = sourceTexts.get(0);
        String sourceEndText = sourceTexts.get(lastSourceIndex);
        List<String> targetTexts = this.getTexts();
        int lastTargetIndex = targetTexts.size() - 1;
        String targetStartText = targetTexts.get(0);
        String targetEndText = targetTexts.get(lastTargetIndex);
        if (lastSourceIndex == 0 && sourceStartText.length() < targetStartText.length() + targetEndText.length() || !sourceStartText.startsWith(targetStartText) || !sourceEndText.endsWith(targetEndText)) {
            List<JSType> list3 = Collections.emptyList();
            if (list3 == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(77);
            }
            return list3;
        }
        String remainingEndText = sourceEndText.substring(0, sourceEndText.length() - targetEndText.length());
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("infer:source", sourceTexts, sourceTypes, source2);
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("infer:target", targetTexts, this.getTypes(), this.getSource());
        }
        InferenceState state2 = new InferenceState(0, targetStartText.length(), sourceTexts, sourceTypes, remainingEndText, lastSourceIndex, this.getSource());
        for (int i2 = 1; i2 < lastTargetIndex; ++i2) {
            String delimiter = targetTexts.get(i2);
            if (delimiter.length() > 0) {
                int s = state2.mySeg;
                int p = state2.myPos;
                while ((p = state2.getSourceText(s).indexOf(delimiter, p)) < 0) {
                    if (++s == sourceTexts.size()) {
                        List<JSType> list4 = Collections.emptyList();
                        if (list4 == null) {
                            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(78);
                        }
                        return list4;
                    }
                    p = 0;
                }
                state2.addMatch(s, p);
                state2.myPos += delimiter.length();
                continue;
            }
            if (state2.myPos < state2.getSourceText(state2.mySeg).length()) {
                state2.addMatch(state2.mySeg, state2.myPos + 1);
                continue;
            }
            if (state2.mySeg < lastSourceIndex) {
                state2.addMatch(state2.mySeg + 1, 0);
                continue;
            }
            List<JSType> list5 = Collections.emptyList();
            if (list5 == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(79);
            }
            return list5;
        }
        state2.addMatch(lastSourceIndex, state2.getSourceText(lastSourceIndex).length());
        List<JSType> list6 = state2.myMatches;
        if (list6 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(80);
        }
        return list6;
    }

    private static boolean isValidNumberString(@NotNull String literal) {
        if (literal == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(81);
        }
        JSFlexAdapter flexAdapter = new JSFlexAdapter(DialectOptionHolder.TS);
        flexAdapter.start(literal);
        if (flexAdapter.getTokenType() == JSTokenTypes.MINUS) {
            flexAdapter.advance();
        }
        if (flexAdapter.getTokenType() != JSTokenTypes.NUMERIC_LITERAL) {
            return false;
        }
        flexAdapter.advance();
        return flexAdapter.getTokenType() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 15: 
            case 16: 
            case 24: 
            case 39: 
            case 49: 
            case 66: 
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 25: 
            case 35: 
            case 40: 
            case 55: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constituents";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 47: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTexts";
                break;
            }
            case 48: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTexts";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypes";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 63: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteConstituentTypes";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanTypeAsUnion";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeTemplateLiteralType";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateStringForType";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypesFromTemplateLiteralType";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "inferFromLiteralPartsToTemplateLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "traceTemplateTypeOperation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithPrimitiveIfPossible";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceholderOrGenericParameterType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "substituteConstituentTypes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "substituteConstituentType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "booleanTypeAsUnion";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createInlinedTemplateLiteral";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "distributeTemplateLiteralType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "distributeTypeLiteralConstituents";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addSpans";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateStringForType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "inferAndApplyGenerics";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isValidTypeForTemplateLiteralPlaceholder";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceholderType";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "inferTypesFromTemplateLiteralType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getStringLikeTypeForType";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "inferFromLiteralPartsToTemplateLiteral";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isValidNumberString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InferenceState {
        private final List<JSType> myMatches = new ArrayList<JSType>();
        private final List<String> mySourceTexts;
        private final List<JSType> mySourceTypes;
        private final String myRemainingEndText;
        private final int myLastSourceIndex;
        private final JSTypeSource mySource;
        private int mySeg;
        private int myPos;

        InferenceState(int seg, int pos, List<String> sourceTexts, List<JSType> sourceTypes, String remainingEndText, int lastSourceIndex, JSTypeSource source2) {
            this.mySeg = seg;
            this.myPos = pos;
            this.mySourceTexts = sourceTexts;
            this.mySourceTypes = sourceTypes;
            this.myRemainingEndText = remainingEndText;
            this.myLastSourceIndex = lastSourceIndex;
            this.mySource = source2;
        }

        @NotNull
        private String getSourceText(int index) {
            String string = index < this.myLastSourceIndex ? this.mySourceTexts.get(index) : this.myRemainingEndText;
            if (string == null) {
                InferenceState.$$$reportNull$$$0(0);
            }
            return string;
        }

        private void addMatch(int s, int p) {
            JSType matchType;
            if (s == this.mySeg) {
                matchType = new JSStringLiteralTypeImpl(this.getSourceText(s).substring(this.myPos, p), false, this.mySource);
            } else {
                ArrayList<String> texts = new ArrayList<String>();
                texts.add(this.mySourceTexts.get(this.mySeg).substring(this.myPos));
                texts.addAll(this.mySourceTexts.subList(this.mySeg + 1, s));
                texts.add(this.getSourceText(s).substring(0, p));
                ArrayList<JSType> types2 = new ArrayList<JSType>(this.mySourceTypes.subList(this.mySeg, s));
                matchType = TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types2, false, this.mySource);
            }
            this.myMatches.add(matchType);
            this.mySeg = s;
            this.myPos = p;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl$InferenceState", "getSourceText"));
        }
    }
}

