/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonElementType
extends JSTypeOfPsiElementBase<JsonElement>
implements JSEvaluableOnlyType,
JSPropertiesOwnerType {
    private JsonElementType(@NotNull JsonElement element) {
        if (element == null) {
            JsonElementType.$$$reportNull$$$0(0);
        }
        super(element);
    }

    private JsonElementType(@NotNull JsonElement element, @NotNull JSTypeSource source2) {
        if (element == null) {
            JsonElementType.$$$reportNull$$$0(1);
        }
        if (source2 == null) {
            JsonElementType.$$$reportNull$$$0(2);
        }
        super(element, source2);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JsonElementType.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            JsonElementType.$$$reportNull$$$0(4);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            PsiElement element = this.getSourceElement();
            builder.append("json(" + (element != null ? element.getText() : "") + ")");
            return;
        }
        JSRecordType type = this.asRecordType();
        builder.append(type, format);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JsonElementType.$$$reportNull$$$0(5);
        }
        return new JsonElementType((JsonElement)this.getElement(), source2);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        PsiElement element = this.getSourceElement();
        if (element instanceof JsonFile) {
            element = ((JsonFile)element).getTopLevelValue();
        }
        if (element instanceof JsonObject) {
            List list2 = ((JsonObject)element).getPropertyList();
            SmartList properties2 = new SmartList();
            for (JsonProperty property : list2) {
                JsonValue value = property.getValue();
                JSType type = value == null ? null : JsonElementType.createJsonElementType((JsonElement)value, null);
                properties2.add(new JSRecordTypeImpl.PropertySignatureImpl(property.getName(), type, false, false, (PsiElement)property));
            }
            return new JSRecordTypeImpl(this.getSource(), (List<? extends JSRecordType.TypeMember>)properties2);
        }
        JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JsonElementType.$$$reportNull$$$0(6);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSType createJsonElementType(@NotNull JsonElement element, @Nullable PsiElement context) {
        if (element == null) {
            JsonElementType.$$$reportNull$$$0(7);
        }
        if (context == null) {
            context = element;
        }
        if (element instanceof JsonFile) {
            JsonElement finalElement = element;
            element = (JsonElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)((JsonFile)finalElement), () -> ((JsonFile)finalElement).getTopLevelValue());
        } else if (element instanceof JsonProperty) {
            element = ((JsonProperty)element).getValue();
        }
        if (element instanceof JsonValue) {
            if (element instanceof JsonObject || element instanceof JsonArray) {
                return new JsonElementType(element);
            }
            String name = null;
            if (element instanceof JsonBooleanLiteral) {
                name = "boolean";
            }
            if (element instanceof JsonStringLiteral) {
                name = "string";
            }
            if (element instanceof JsonNumberLiteral) {
                name = "number";
            }
            if (name != null) {
                JSType jSType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSTypeContext.INSTANCE);
                if (jSType == null) {
                    JsonElementType.$$$reportNull$$$0(8);
                }
                return jSType;
            }
        }
        JSAnyType jSAnyType = JSAnyType.get(context, true);
        if (jSAnyType == null) {
            JsonElementType.$$$reportNull$$$0(9);
        }
        return jSAnyType;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JsonElementType.$$$reportNull$$$0(10);
        }
        JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
        if (jSEvaluationTaskList == null) {
            JsonElementType.$$$reportNull$$$0(11);
        }
        return jSEvaluationTaskList;
    }

    @Override
    public boolean matchesSourceElement() {
        return false;
    }

    @Nullable
    public JSType getComponentType(@Nullable JSType indexType, @Nullable PsiElement collectionExpression) {
        JsonProperty property;
        String propertyName;
        double literal;
        int index;
        JsonElement jsonElement = (JsonElement)this.getElement();
        if (jsonElement instanceof JsonArray && indexType instanceof JSNumberLiteralTypeImpl && (double)(index = (int)(literal = ((JSNumberLiteralTypeImpl)indexType).getLiteral().doubleValue())) == literal) {
            List values = ((JsonArray)jsonElement).getValueList();
            if (index >= 0 && index < values.size()) {
                return JsonElementType.createJsonElementType((JsonElement)values.get(index), collectionExpression);
            }
        }
        String string = indexType instanceof JSNumberLiteralTypeImpl ? JSPsiImplUtils.convertECMAScriptNumberToString(((JSNumberLiteralTypeImpl)indexType).getLiteral()) : (propertyName = indexType instanceof JSStringLiteralTypeImpl ? ((JSStringLiteralTypeImpl)indexType).getLiteral() : null);
        if (jsonElement instanceof JsonObject && propertyName != null && (property = ((JsonObject)jsonElement).findProperty(propertyName)) != null) {
            return JsonElementType.createJsonElementType((JsonElement)property, collectionExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JsonElementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JsonElementType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonElementType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJsonElementType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

