/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeSource {
    public static final JSTypeSource EMPTY = new JSTypeSource(null, SourceLanguage.JS, false);
    public static final JSTypeSource EMPTY_AS = new JSTypeSource(null, SourceLanguage.AS, false);
    public static final JSTypeSource EXPLICITLY_DECLARED = new JSTypeSource(null, SourceLanguage.JS, true);
    public static final JSTypeSource EMPTY_TS = new JSTypeSource(null, SourceLanguage.TS, false);
    private final PsiFile myScope;
    private final PsiElement mySourceElement;
    private final boolean isStrict;
    private final SourceLanguage myLanguage;

    public JSTypeSource(@Nullable PsiElement sourceElement, @NotNull SourceLanguage language, boolean isStrict) {
        if (language == null) {
            JSTypeSource.$$$reportNull$$$0(0);
        }
        this(sourceElement != null ? sourceElement.getContainingFile() : null, sourceElement, language, isStrict);
    }

    private JSTypeSource(@Nullable PsiFile scope, @Nullable PsiElement sourceElement, @NotNull SourceLanguage language, boolean isStrict) {
        if (language == null) {
            JSTypeSource.$$$reportNull$$$0(1);
        }
        this.myScope = scope;
        this.isStrict = isStrict;
        this.myLanguage = language;
        this.mySourceElement = sourceElement;
    }

    @Nullable
    public PsiFile getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    @Nullable
    public Project getProject() {
        return this.mySourceElement != null ? this.mySourceElement.getProject() : null;
    }

    public boolean isEcma() {
        return this.myLanguage == SourceLanguage.AS;
    }

    public boolean isTypeScript() {
        return this.myLanguage == SourceLanguage.TS;
    }

    public boolean isJavaScript() {
        return this.myLanguage == SourceLanguage.JS;
    }

    @NotNull
    public SourceLanguage getLanguage() {
        SourceLanguage sourceLanguage = this.myLanguage;
        if (sourceLanguage == null) {
            JSTypeSource.$$$reportNull$$$0(2);
        }
        return sourceLanguage;
    }

    @NotNull
    public JSTypeSource copyWithNewLanguage(@NotNull SourceLanguage language) {
        if (language == null) {
            JSTypeSource.$$$reportNull$$$0(3);
        }
        return new JSTypeSource(this.myScope, this.mySourceElement, language, this.isStrict);
    }

    @NotNull
    public JSTypeSource copyWithStrict(boolean isStrict) {
        return new JSTypeSource(this.myScope, this.mySourceElement, this.myLanguage, isStrict);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SourceLanguage {
        JS,
        AS,
        TS;

    }
}

